/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.zip;

import ivorius.reccomplex.utils.ByteArrays;
import ivorius.reccomplex.utils.zip.IvZips;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.zip.ZipInputStream;

public class ZipFinder {
    private final Map<String, EntryConsumer<InputStream>> map = new HashMap<String, EntryConsumer<InputStream>>();

    public void read(ZipInputStream stream) throws IOException {
        IvZips.walkStreams(stream, (name, inputStream) -> {
            EntryConsumer<InputStream> consumer = this.map.get(name);
            if (consumer != null) {
                consumer.accept((InputStream)inputStream);
            }
        });
    }

    public <T> Result<T> stream(String name, Function<InputStream, T> function) {
        if (this.map.containsKey(name)) {
            throw new IllegalArgumentException();
        }
        Result result = new Result(name);
        this.map.put(name, inputStream -> result.set(function.apply((InputStream)inputStream)));
        return result;
    }

    public <T> Result<T> bytes(String name, Function<byte[], T> function) {
        return this.stream(name, inputStream -> {
            byte[] bytes = ByteArrays.completeByteArray(inputStream);
            return bytes != null ? function.apply(bytes) : null;
        });
    }

    public class MissingEntryException
    extends RuntimeException {
        public final String name;

        public MissingEntryException(String name) {
            super("Missing Entry: " + name);
            this.name = name;
        }
    }

    public class Result<T> {
        protected String name;
        protected T t;
        protected boolean present;

        public Result(String name) {
            this.name = name;
        }

        protected void set(T t) {
            this.t = t;
            this.present = true;
        }

        public boolean isPresent() {
            return this.present;
        }

        public T get() {
            if (!this.isPresent()) {
                throw new MissingEntryException(this.name);
            }
            return this.t;
        }

        public T orElse(Supplier<T> defaultVal) {
            return this.isPresent() ? this.t : defaultVal.get();
        }

        public Optional<T> peek() {
            return this.present ? Optional.of(this.t) : Optional.empty();
        }
    }

    @FunctionalInterface
    private static interface EntryConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    @FunctionalInterface
    public static interface Function<S, D> {
        public D apply(S var1) throws IOException;
    }
}

