/*
 * Decompiled with CFR 0.152.
 */
package requious.block;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import requious.block.IDynamicModel;
import requious.data.AssemblyData;
import requious.tile.TileEntityAssembly;
import requious.util.Misc;

public class BlockAssembly
extends Block
implements IDynamicModel {
    public static final PropertyDirection facing = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool active = PropertyBool.func_177716_a((String)"active");
    AssemblyData data;
    AxisAlignedBB[] aabbs = new AxisAlignedBB[6];

    public BlockAssembly(Material materialIn, AssemblyData data) {
        super(materialIn);
        this.data = data;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.aabbs[facing.func_176745_a()] = Misc.rotateAABB(data.aabb, facing);
        }
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
    }

    public AssemblyData getData() {
        return this.data;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing, active});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)facing)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)facing, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAssembly) {
            return state.func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(((TileEntityAssembly)tile).isActive()));
        }
        return state;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.data.hardness;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.data.blastResistance;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockAssembly.facing);
        return this.aabbs[facing.func_176745_a()];
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        double d0 = placer.field_70163_u + (double)placer.func_70047_e();
        switch (this.data.placeType) {
            case Any: {
                face = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
                break;
            }
            case Up: {
                face = EnumFacing.UP;
                break;
            }
            case Down: {
                face = EnumFacing.DOWN;
                break;
            }
            case Horizontal: {
                face = placer.func_174811_aO().func_176734_d();
                break;
            }
            case Vertical: {
                if (d0 - (double)pos.func_177956_o() < 0.0) {
                    face = EnumFacing.DOWN;
                    break;
                }
                face = EnumFacing.UP;
                break;
            }
            case HorizontalUp: {
                if (Math.abs(placer.field_70165_t - (double)((float)pos.func_177958_n() + 0.5f)) < 2.0 && Math.abs(placer.field_70161_v - (double)((float)pos.func_177952_p() + 0.5f)) < 2.0) {
                    if (d0 - (double)pos.func_177956_o() > 2.0) {
                        face = EnumFacing.UP;
                    }
                    if (!((double)pos.func_177956_o() - d0 > 0.0)) break;
                    face = placer.func_174811_aO().func_176734_d();
                    break;
                }
                face = placer.func_174811_aO().func_176734_d();
                break;
            }
            case HorizontalDown: {
                if (Math.abs(placer.field_70165_t - (double)((float)pos.func_177958_n() + 0.5f)) < 2.0 && Math.abs(placer.field_70161_v - (double)((float)pos.func_177952_p() + 0.5f)) < 2.0) {
                    if (d0 - (double)pos.func_177956_o() > 2.0) {
                        face = placer.func_174811_aO().func_176734_d();
                    }
                    if (!((double)pos.func_177956_o() - d0 > 0.0)) break;
                    face = EnumFacing.DOWN;
                    break;
                }
                face = placer.func_174811_aO().func_176734_d();
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)facing, (Comparable)face);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityAssembly && placer instanceof EntityPlayer) {
            ((TileEntityAssembly)tile).setOwner((EntityPlayer)placer);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        switch (this.data.layerType) {
            case Cutout: {
                return BlockRenderLayer.CUTOUT == layer;
            }
            case Translucent: {
                return BlockRenderLayer.TRANSLUCENT == layer;
            }
            case MultiLayer: {
                return BlockRenderLayer.CUTOUT == layer || BlockRenderLayer.TRANSLUCENT == layer;
            }
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityAssembly) {
            ((TileEntityAssembly)tile).breakBlock(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && this.data.hasGUI) {
            playerIn.openGui((Object)"requious", 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return this.data.hasGUI;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileEntityAssembly assembly = new TileEntityAssembly();
        assembly.setBlock(this);
        return assembly;
    }

    @Override
    public ResourceLocation getRedirect() {
        return this.data.model;
    }

    @Override
    public Color getTint(int tintIndex) {
        return this.data.getColor(tintIndex);
    }
}

