/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.annotations.ZenRegister;
import java.awt.Color;
import net.minecraft.util.ResourceLocation;
import requious.util.Misc;
import requious.util.color.EnergyColor;
import requious.util.color.FluidColor;
import requious.util.color.ICustomColor;
import requious.util.color.LerpColor;
import requious.util.color.NormalColor;
import requious.util.color.RandomColor;
import requious.util.color.TimeColor;
import requious.util.color.VariableColor;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.Color")
public class ColorCT {
    ICustomColor internal;

    public ColorCT(ICustomColor internal) {
        this.internal = internal;
    }

    public ICustomColor get() {
        return this.internal;
    }

    @ZenMethod
    public static ColorCT normal(int[] rgb) {
        return new ColorCT(new NormalColor(Misc.parseColor(rgb)));
    }

    @ZenMethod
    public static ColorCT fluid() {
        return new ColorCT(new FluidColor());
    }

    @ZenMethod
    public static ColorCT energy(int[][] rgbs, boolean hsb) {
        Object[] colors = ColorCT.parseColors(rgbs);
        return new ColorCT(new EnergyColor(Lists.newArrayList((Object[])colors), hsb));
    }

    @ZenMethod
    public static ColorCT variable(int[][] rgbs, String override, boolean hsb) {
        Object[] colors = ColorCT.parseColors(rgbs);
        return new ColorCT(new VariableColor(Lists.newArrayList((Object[])colors), new ResourceLocation(override), hsb));
    }

    @ZenMethod
    public static ColorCT random(int[][] rgbs) {
        Object[] colors = ColorCT.parseColors(rgbs);
        return new ColorCT(new RandomColor(Lists.newArrayList((Object[])colors)));
    }

    @ZenMethod
    public static ColorCT time(int[][] rgbs, double pulseLength, boolean hsb) {
        Object[] colors = ColorCT.parseColors(rgbs);
        return new ColorCT(new TimeColor(Lists.newArrayList((Object[])colors), pulseLength, false, hsb));
    }

    @ZenMethod
    public static ColorCT timePulse(int[][] rgbs, double pulseLength, boolean hsb) {
        Object[] colors = ColorCT.parseColors(rgbs);
        return new ColorCT(new TimeColor(Lists.newArrayList((Object[])colors), pulseLength, true, hsb));
    }

    @ZenMethod
    public static ColorCT lerp(int[][] rgbs, boolean hsb) {
        Object[] colors = ColorCT.parseColors(rgbs);
        return new ColorCT(new LerpColor(Lists.newArrayList((Object[])colors), hsb));
    }

    private static Color[] parseColors(int[][] rgbs) {
        Color[] colors = new Color[rgbs.length];
        for (int i = 0; i < rgbs.length; ++i) {
            colors[i] = Misc.parseColor(rgbs[i]);
        }
        return colors;
    }
}

