/*
 * Decompiled with CFR 0.152.
 */
package requious.data.component;

import crafttweaker.annotations.ZenRegister;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import requious.compat.crafttweaker.SlotVisualCT;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.gui.slot.DurationSlot;
import requious.recipe.RequirementDuration;
import requious.util.ComponentFace;
import requious.util.SlotVisual;
import stanhebben.zenscript.annotations.ReturnsSelf;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.DurationSlot")
public class ComponentDuration
extends ComponentBase {
    public SlotVisual visual = SlotVisual.EMPTY;

    public ComponentDuration() {
        super(ComponentFace.None);
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentDuration setVisual(SlotVisualCT visual) {
        this.visual = SlotVisualCT.unpack(visual);
        return this;
    }

    @Override
    public ComponentBase.Slot createSlot() {
        return new Slot(this);
    }

    public static class Slot
    extends ComponentBase.Slot<ComponentDuration> {
        RequirementDuration currentRecipe;
        int time;
        int duration;
        boolean active;

        public Slot(ComponentDuration component) {
            super(component);
        }

        public RequirementDuration getCurrentRecipe() {
            return this.currentRecipe;
        }

        public void setCurrentRecipe(RequirementDuration recipe) {
            if (this.currentRecipe != null && this.currentRecipe != recipe) {
                this.time = 0;
            }
            this.active = true;
            this.currentRecipe = recipe;
            this.duration = recipe.getDuration();
        }

        public int getTime() {
            return this.time;
        }

        public int getDuration() {
            return this.duration;
        }

        @Override
        public void addCollectors(List<ComponentBase.Collector> collectors) {
        }

        @Override
        public net.minecraft.inventory.Slot createGui(AssemblyProcessor assembly, int x, int y) {
            return new DurationSlot(assembly, this, x, y);
        }

        @Override
        public void update() {
            if (this.active) {
                ++this.time;
                if (this.time > this.duration) {
                    this.time = this.duration;
                }
            } else {
                this.reset();
            }
            this.active = false;
        }

        @Override
        public void machineBroken(World world, Vec3d position) {
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("active", this.active);
            compound.func_74768_a("time", this.time);
            compound.func_74768_a("duration", this.duration);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.active = compound.func_74767_n("active");
            this.time = compound.func_74762_e("time");
            this.duration = compound.func_74762_e("duration");
        }

        public SlotVisual getVisual() {
            return ((ComponentDuration)this.component).visual;
        }

        public void reset() {
            this.currentRecipe = null;
            this.time = 0;
            this.duration = 0;
        }

        @Override
        public boolean isDirty() {
            return super.isDirty();
        }

        @Override
        public void markClean() {
            super.markClean();
        }

        public boolean isDone() {
            return this.time >= this.duration;
        }
    }
}

