/*
 * Decompiled with CFR 0.152.
 */
package requious.gui.slot;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentText;
import requious.gui.GuiAssembly;
import requious.gui.slot.BaseSlot;
import requious.util.SlotVisual;

public class TextSlot
extends BaseSlot<ComponentText.Slot> {
    public TextSlot(AssemblyProcessor assembly, ComponentText.Slot binding, int xPosition, int yPosition) {
        super(assembly, binding, xPosition, yPosition);
    }

    public boolean func_75214_a(ItemStack stack) {
        return false;
    }

    @Nonnull
    public ItemStack func_75211_c() {
        return ItemStack.field_190927_a;
    }

    public void func_75215_d(ItemStack stack) {
    }

    public void func_75220_a(ItemStack p_75220_1_, ItemStack p_75220_2_) {
    }

    public int func_75219_a() {
        return 0;
    }

    public int func_178170_b(ItemStack stack) {
        return 0;
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        return false;
    }

    @Override
    public void incrStack(int n) {
    }

    public ItemStack func_75209_a(int amount) {
        return ItemStack.field_190927_a;
    }

    @Override
    public void renderBackground(GuiAssembly assembly, int x, int y, float partialTicks, int mousex, int mousey) {
        SlotVisual visual = ((ComponentText.Slot)this.binding).getVisual();
        if (visual != null) {
            visual.render(assembly.field_146297_k, x - 1, y - 1, 100, ((ComponentText.Slot)this.binding).getFill(this.assembly));
        }
    }

    @Override
    public void renderForeground(GuiAssembly assembly, int x, int y, int mousex, int mousey) {
        SlotVisual visual = ((ComponentText.Slot)this.binding).getVisual();
        ComponentText.TextPart renderText = ((ComponentText.Slot)this.binding).getRenderText();
        if (renderText != null) {
            int left = 0;
            int right = 18 * visual.getWidth() - 2;
            FontRenderer renderer = assembly.field_146297_k.field_71466_p;
            String[] text = this.localize(renderText).split("\n");
            for (int i = 0; i < text.length; ++i) {
                int width = renderer.func_78256_a(text[i]);
                int height = renderer.field_78288_b;
                int align = right - left - width;
                switch (((ComponentText.Slot)this.binding).getAlignment()) {
                    case LEFT: {
                        align *= 0;
                        break;
                    }
                    case CENTER: {
                        align /= 2;
                        break;
                    }
                }
                renderer.func_78276_b(text[i], x + left + align, y + i * height, 0x404040);
            }
        }
    }

    @Override
    public boolean hasToolTip() {
        return ((ComponentText.Slot)this.binding).hasToolTip();
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        for (ComponentText.TextPart part : ((ComponentText.Slot)this.binding).getToolTip()) {
            tooltip.add(this.localize(part));
        }
        return tooltip;
    }

    private String localize(ComponentText.TextPart part) {
        String[] variableNames = part.getVariables();
        Object[] variableValues = new Object[variableNames.length];
        for (int i = 0; i < variableNames.length; ++i) {
            variableValues[i] = this.assembly.getVariable(variableNames[i]);
        }
        return I18n.func_135052_a((String)part.getText(), (Object[])variableValues);
    }

    @Override
    public boolean func_111238_b() {
        return false;
    }

    @Override
    public boolean isHoverEnabled() {
        return true;
    }
}

