/*
 * Decompiled with CFR 0.152.
 */
package requious.item;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class Shape {
    Shape inner;
    Part[] parts = new Part[4];

    public Shape() {
    }

    public Shape(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b("shape", 10)) {
            this.readFromNBT(tagCompound.func_74775_l("shape"));
        }
    }

    public Shape(NBTTagCompound tag) {
        this.readFromNBT(tag);
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i] == null) continue;
            return false;
        }
        return this.inner == null || this.inner.isEmpty();
    }

    public void setInner(Shape inner) {
        this.inner = inner;
    }

    public Shape getInner() {
        return this.inner;
    }

    public void setPart(Piece piece, Part part) {
        this.parts[piece.ordinal()] = part;
    }

    public Part getPart(Piece piece) {
        return this.parts[piece.ordinal()];
    }

    public Shape toLayer() {
        Shape layer = new Shape();
        for (int i = 0; i < this.parts.length; ++i) {
            layer.parts[i] = this.parts[i];
        }
        return layer;
    }

    public List<Shape> split() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        for (Shape piece = this; piece != null; piece = piece.getInner()) {
            shapes.add(piece);
        }
        return shapes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Shape) {
            Shape other = (Shape)obj;
            for (int i = 0; i < this.parts.length; ++i) {
                if (Objects.equals(this.parts[i], other.parts[i])) continue;
                return false;
            }
            return Objects.equals(this.inner, other.inner);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.inner, this.parts[0], this.parts[1], this.parts[2], this.parts[3]);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.parts.length; ++i) {
            Part part = this.parts[i];
            if (part == null) continue;
            tag.func_74768_a("color" + i, part.getColor().getRGB());
            tag.func_74778_a("material" + i, part.getMaterial());
            tag.func_74778_a("texture" + i, part.getTexture().toString());
        }
        tag.func_74782_a("inner", (NBTBase)this.inner.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.parts.length; ++i) {
            if (!tag.func_74764_b("color" + i)) continue;
            Color color = new Color(tag.func_74762_e("color" + i));
            String material = tag.func_74779_i("material" + i);
            ResourceLocation texture = new ResourceLocation(tag.func_74779_i("texture" + i));
            this.parts[i] = new Part(texture, material, color);
        }
        if (tag.func_74764_b("inner")) {
            this.inner = new Shape(tag.func_74775_l("inner"));
        }
    }

    public static class Part {
        ResourceLocation texture;
        String material;
        Color color;

        public Part(ResourceLocation texture, String material, Color color) {
            this.texture = texture;
            this.material = material;
            this.color = color;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public String getMaterial() {
            return this.material;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Part) {
                Part other = (Part)obj;
                return other.material.equals(this.material) && other.texture.equals((Object)this.texture) && other.color.equals(this.color);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return Objects.hash(this.texture, this.material, this.color);
        }
    }

    public static enum Piece {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

