/*
 * Decompiled with CFR 0.152.
 */
package requious.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;

public class TextureConverter {
    public static List<BakedQuad> getQuadsForSprite(int tint, int colorMod, TextureAtlasSprite template, TextureAtlasSprite sprite, VertexFormat format, TRSRTransformation transform) {
        ArrayList bakedQuads = Lists.newArrayList();
        int uSpriteMax = sprite.func_94211_a();
        int vSpriteMax = sprite.func_94216_b();
        int uMaskMax = template.func_94211_a();
        int vMaskMax = template.func_94216_b();
        int uMax = Math.max(uMaskMax, uSpriteMax);
        int vMax = Math.max(vMaskMax, vSpriteMax);
        float un = (float)uSpriteMax / 16.0f;
        float vn = (float)vSpriteMax / 16.0f;
        for (int f = 0; f < sprite.func_110970_k(); ++f) {
            int[] spritepixels = sprite.func_147965_a(f)[0];
            int[] maskpixels = template.func_147965_a(0)[0];
            for (int v = 0; v < vMax; ++v) {
                for (int u = 0; u < uMax; ++u) {
                    int maskindex;
                    int spriteindex = TextureConverter.mapToSmallerPixel(u, v, uMax, vMax, uSpriteMax, vSpriteMax);
                    if (TextureConverter.isTransparent(spritepixels, maskpixels, spriteindex, maskindex = TextureConverter.mapToSmallerPixel(u, v, uMax, vMax, uMaskMax, vMaskMax))) continue;
                    int color = TextureConverter.multiplyColors(colorMod, maskpixels[maskindex]);
                    float x1 = (float)u / (float)uMax;
                    float x2 = (float)(u + 1) / (float)uMax;
                    float y1 = (float)(vMax - 1 - v) / (float)vMax;
                    float y2 = (float)(vMax - v) / (float)vMax;
                    float u1 = sprite.func_94214_a((double)((float)u / un));
                    float u2 = sprite.func_94214_a((double)((float)(u + 1) / un));
                    float v1 = sprite.func_94207_b((double)((float)v / vn));
                    float v2 = sprite.func_94207_b((double)((float)(v + 1) / vn));
                    bakedQuads.add(TextureConverter.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, color, x1, y1, 0.46875f, u1, v2, x1, y2, 0.46875f, u1, v1, x2, y2, 0.46875f, u2, v1, x2, y1, 0.46875f, u2, v2));
                    bakedQuads.add(TextureConverter.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, color, x1, y1, 0.53125f, u1, v2, x2, y1, 0.53125f, u2, v2, x2, y2, 0.53125f, u2, v1, x1, y2, 0.53125f, u1, v1));
                    bakedQuads.add(TextureConverter.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, color, x2, y1, 0.46875f, u2, v2, x2, y1, 0.53125f, u2, v1, x1, y1, 0.53125f, u1, v1, x1, y1, 0.46875f, u1, v2));
                    bakedQuads.add(TextureConverter.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, color, x1, y2, 0.46875f, u1, v2, x1, y2, 0.53125f, u1, v1, x2, y2, 0.53125f, u2, v1, x2, y2, 0.46875f, u2, v2));
                    bakedQuads.add(TextureConverter.buildQuad(format, transform, EnumFacing.EAST, sprite, tint, color, x2, y1, 0.46875f, u1, v2, x2, y2, 0.46875f, u1, v1, x2, y2, 0.53125f, u2, v1, x2, y1, 0.53125f, u2, v2));
                    bakedQuads.add(TextureConverter.buildQuad(format, transform, EnumFacing.WEST, sprite, tint, color, x1, y1, 0.53125f, u2, v2, x1, y2, 0.53125f, u2, v1, x1, y2, 0.46875f, u1, v1, x1, y1, 0.46875f, u1, v2));
                }
            }
        }
        return bakedQuads;
    }

    private static int multiplyColors(int color1, int color2) {
        int r = (color1 & 0xFF) * (color2 & 0xFF) / 255;
        int g = (color1 >> 8 & 0xFF) * (color2 >> 8 & 0xFF) / 255;
        int b = (color1 >> 16 & 0xFF) * (color2 >> 16 & 0xFF) / 255;
        int a = (color1 >> 24 & 0xFF) * (color2 >> 24 & 0xFF) / 255;
        return r | g << 8 | b << 16 | a << 24;
    }

    private static int getPixelIndex(int u, int v, int uMax, int vMax) {
        return u + v * vMax;
    }

    private static int mapToSmallerPixel(int u, int v, int uMax, int vMax, int uMin, int vMin) {
        int uMod = uMax / uMin;
        int vMod = vMax / vMin;
        return TextureConverter.getPixelIndex(u / uMod % uMin, v / vMod % uMin, uMin, vMin);
    }

    private static boolean isTransparent(int[] pixels, int[] maskpixels, int index, int maskindex) {
        return (pixels[index] >> 24 & 0xFF) == 0 || (maskpixels[maskindex] >> 24 & 0xFF) == 0;
    }

    private static final BakedQuad buildQuad(VertexFormat format, TRSRTransformation transform, EnumFacing side, TextureAtlasSprite sprite, int tint, int color, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        TextureConverter.putVertex(builder, format, transform, side, color, x0, y0, z0, u0, v0);
        TextureConverter.putVertex(builder, format, transform, side, color, x1, y1, z1, u1, v1);
        TextureConverter.putVertex(builder, format, transform, side, color, x2, y2, z2, u2, v2);
        TextureConverter.putVertex(builder, format, transform, side, color, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, TRSRTransformation transform, EnumFacing side, int color, float x, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    vec.x = x;
                    vec.y = y;
                    vec.z = z;
                    vec.w = 1.0f;
                    transform.getMatrix().transform((Tuple4f)vec);
                    builder.put(e, new float[]{vec.x, vec.y, vec.z, vec.w});
                    continue block6;
                }
                case COLOR: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a = (float)(color >> 24 & 0xFF) / 255.0f;
                    builder.put(e, new float[]{r, g, b, a});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }
}

