/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.block.INoCullBlock;
import epicsquid.mysticallib.model.ICustomModeledObject;
import epicsquid.mysticallib.model.IModeledObject;
import epicsquid.roots.init.ModDamage;
import epicsquid.roots.util.EntityUtil;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWildFire
extends BlockFire
implements IBlock,
IModeledObject,
ICustomModeledObject,
INoCullBlock {
    @Nonnull
    public String name;

    public BlockWildFire(@Nonnull String name) {
        this.name = name;
        this.func_149663_c(name);
        this.setRegistryName(LibRegistry.getActiveModid(), name);
        this.func_149713_g(15);
        this.func_149715_a(0.25f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)field_176545_N, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176546_O, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176541_P, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176539_Q, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176542_R, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public Item getItemBlock() {
        return null;
    }

    public ItemBlock setItemBlock(ItemBlock block) {
        return block;
    }

    public boolean noCull() {
        return false;
    }

    @Nullable
    protected IBlockState getParentState() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
    }

    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!EntityUtil.isHostile(entityIn) || EntityUtil.isFriendly(entityIn)) {
            return;
        }
        entityIn.func_70015_d(1);
        if (worldIn.field_72995_K) {
            return;
        }
        DamageSource feyFire = ModDamage.wildfireDamage(worldIn);
        if (feyFire != null) {
            entityIn.func_70097_a(feyFire, 2.0f);
        }
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return PathNodeType.DAMAGE_FIRE;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i;
        if (!worldIn.func_175697_a(pos, 2)) {
            return;
        }
        if (!this.func_176196_c(worldIn, pos) || worldIn.func_175623_d(pos.func_177977_b())) {
            worldIn.func_175698_g(pos);
        }
        if ((i = ((Integer)state.func_177229_b((IProperty)field_176543_a)).intValue()) < 15) {
            state = state.func_177226_a((IProperty)field_176543_a, (Comparable)Integer.valueOf(Math.max(15, i + rand.nextInt(6) / 2)));
            worldIn.func_180501_a(pos, state, 4);
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + rand.nextInt(10));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(24) == 0) {
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        if (rand.nextBoolean()) {
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble();
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble();
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        return source.func_175626_b(pos, 15);
    }
}

