/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.container;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.container.IInvalidatingContainer;
import epicsquid.roots.container.IModifierContainer;
import epicsquid.roots.container.slots.SlotImposerModifierInfo;
import epicsquid.roots.container.slots.SlotImposerSpellInfo;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstance;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.MessageInvalidateContainer;
import epicsquid.roots.spell.info.StaffSpellInfo;
import epicsquid.roots.spell.info.storage.StaffSpellStorage;
import epicsquid.roots.tileentity.TileEntityImposer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContainerImposer
extends Container
implements IInvalidatingContainer,
IModifierContainer {
    public final TileEntityImposer tile;
    private final Map<IModifierCore, Slot> coreSlotMap = new HashMap<IModifierCore, Slot>();
    private List<SlotImposerSpellInfo> spellSlots = new ArrayList<SlotImposerSpellInfo>();
    private boolean shiftDown = false;
    private boolean altDown = false;
    private boolean ctrlDown = false;
    private final EntityPlayer player;

    public ContainerImposer(EntityPlayer player, TileEntityImposer tile) {
        this.tile = tile;
        this.player = player;
        this.createPlayerInventory(player.field_71071_by);
        this.createModifierSlots();
        this.createSpellSlots();
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean isSelectSpell() {
        return this.tile.getSlot() == 0;
    }

    private StaffSpellInfo getInfoFor(int slot) {
        StaffSpellStorage storage = this.tile.getSpellStorage();
        if (storage == null) {
            return StaffSpellInfo.EMPTY;
        }
        return storage.getSpellInSlot(slot);
    }

    @Nullable
    private StaffModifierInstance getInstanceFor(IModifierCore core) {
        StaffSpellStorage storage = this.tile.getSpellStorage();
        if (storage == null) {
            return null;
        }
        int slot = this.tile.getSlot();
        if (slot == 0) {
            return null;
        }
        StaffSpellInfo info = storage.getSpellInSlot(slot);
        if (info == null) {
            return null;
        }
        StaffModifierInstanceList mods = info.getModifiers();
        if (mods == null) {
            return null;
        }
        return (StaffModifierInstance)mods.getByCore(core);
    }

    @Nullable
    public StaffModifierInstanceList getModifiers() {
        StaffSpellStorage storage = this.tile.getSpellStorage();
        if (storage == null) {
            return null;
        }
        int slot = this.tile.getSlot();
        if (slot == 0) {
            return null;
        }
        StaffSpellInfo info = storage.getSpellInSlot(slot);
        if (info == null) {
            return null;
        }
        StaffModifierInstanceList mods = info.getModifiers();
        if (mods == null) {
            return null;
        }
        return mods;
    }

    private void createSpellSlots() {
        this.addSpellSlot(new SlotImposerSpellInfo(this::isSelectSpell, this::getInfoFor, 1, 51, 37));
        this.addSpellSlot(new SlotImposerSpellInfo(this::isSelectSpell, this::getInfoFor, 2, 56, 13));
        this.addSpellSlot(new SlotImposerSpellInfo(this::isSelectSpell, this::getInfoFor, 3, 80, 8));
        this.addSpellSlot(new SlotImposerSpellInfo(this::isSelectSpell, this::getInfoFor, 4, 104, 13));
        this.addSpellSlot(new SlotImposerSpellInfo(this::isSelectSpell, this::getInfoFor, 5, 109, 37));
    }

    private void addSpellSlot(SlotImposerSpellInfo slot) {
        this.spellSlots.add(slot);
        this.func_75146_a(slot);
    }

    @Override
    public void invalidate() {
        this.spellSlots.forEach(SlotImposerSpellInfo::invalidate);
    }

    private void addModifierSlot(IModifierCore core, TileEntityImposer imposer, int x, int y) {
        SlotImposerModifierInfo slot = new SlotImposerModifierInfo(this, this::isSelectSpell, this::getInstanceFor, core, imposer, x, y);
        this.coreSlotMap.put(core, slot);
        this.func_75146_a(slot);
    }

    private void createModifierSlots() {
        this.addModifierSlot(ModifierCores.PERESKIA, this.tile, 80, 18);
        this.addModifierSlot(ModifierCores.WILDROOT, this.tile, 80, 43);
        this.addModifierSlot(ModifierCores.TERRA_MOSS, this.tile, 80, 68);
        this.addModifierSlot(ModifierCores.INFERNAL_BULB, this.tile, 80, 93);
        this.addModifierSlot(ModifierCores.DEWGONIA, this.tile, 80, 118);
        this.addModifierSlot(ModifierCores.WILDEWHEET, this.tile, 55, 38);
        this.addModifierSlot(ModifierCores.SPIRIT_HERB, this.tile, 55, 73);
        this.addModifierSlot(ModifierCores.CLOUD_BERRY, this.tile, 55, 108);
        this.addModifierSlot(ModifierCores.MOONGLOW_LEAF, this.tile, 105, 38);
        this.addModifierSlot(ModifierCores.BAFFLE_CAP, this.tile, 105, 73);
        this.addModifierSlot(ModifierCores.STALICRIPE, this.tile, 105, 108);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0 && !player.field_70170_p.field_72995_K) {
            StaffModifierInstanceList modifiers;
            StaffModifierInstance modifier;
            StaffSpellStorage storage;
            StaffSpellInfo staffInfo;
            SlotImposerModifierInfo info;
            Slot slot = this.func_75139_a(slotId);
            if (slot instanceof SlotImposerSpellInfo) {
                StaffSpellInfo info2 = ((SlotImposerSpellInfo)slot).getInfo();
                if (info2 != null && info2 != StaffSpellInfo.EMPTY) {
                    this.tile.setSlot(((SlotImposerSpellInfo)slot).getSlot());
                    this.invalidate();
                    MessageInvalidateContainer message = new MessageInvalidateContainer();
                    PacketHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
                }
            } else if (slot instanceof SlotImposerModifierInfo && (info = (SlotImposerModifierInfo)slot).isApplicable() && info.isApplied() && this.tile.func_145831_w() != null && !this.tile.func_145831_w().field_72995_K && (staffInfo = this.tile.getCurrentInfo(storage = this.tile.getSpellStorage())) != null && (modifier = (StaffModifierInstance)(modifiers = staffInfo.getModifiers()).getByCore(info.getCore())) != null) {
                if (modifier.isEnabled() || !modifier.isConflicting(modifiers) && !this.isAltDown() && !this.isControlDown()) {
                    modifier.setEnabled(!modifier.isEnabled());
                } else if (!modifier.isEnabled() && modifier.isConflicting(modifiers) && (this.isAltDown() || this.isControlDown())) {
                    for (StaffModifierInstance conflictingMod : modifier.getConflicts(modifiers)) {
                        conflictingMod.setEnabled(false);
                    }
                    modifier.setEnabled(true);
                }
                storage.saveToStack();
                this.tile.func_70296_d();
                this.tile.updatePacketViaState();
                this.invalidate();
                MessageInvalidateContainer message = new MessageInvalidateContainer();
                PacketHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    private void createPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = 8;
        int yOffset = 160;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        BlockPos pos = this.tile.func_174877_v();
        if (this.tile.func_145831_w().func_175625_s(pos) != this.tile) {
            return false;
        }
        return player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (this.isSelectSpell()) {
            return ItemStack.field_190927_a;
        }
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack inSlot = slot.func_75211_c();
        ModifierCores core = ModifierCores.fromItemStack(inSlot);
        if (core == null) {
            return ItemStack.field_190927_a;
        }
        Slot coreSlot = this.coreSlotMap.get(core);
        if (coreSlot == null) {
            throw new IllegalStateException("slot for modifier core " + core + " must exist and cannot be null");
        }
        if (coreSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        if (inSlot.func_190916_E() > 1) {
            inSlot.func_190918_g(1);
            slot.func_75215_d(inSlot);
            inSlot = inSlot.func_77946_l();
            inSlot.func_190920_e(1);
        } else {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        coreSlot.func_75215_d(inSlot);
        return ItemStack.field_190927_a;
    }

    @Override
    public void setModifierStatus(int modifier, boolean status) {
        if (modifier == 0) {
            this.shiftDown = status;
        } else if (modifier == 1) {
            this.ctrlDown = status;
        } else if (modifier == 2) {
            this.altDown = status;
        }
    }

    @Override
    public boolean getModifierStatus(int modifier) {
        if (modifier == 0) {
            return this.shiftDown;
        }
        if (modifier == 1) {
            return this.ctrlDown;
        }
        if (modifier == 2) {
            return this.altDown;
        }
        return false;
    }
}

