/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.container;

import epicsquid.roots.handler.ClientPouchHandler;
import epicsquid.roots.handler.IPouchHandler;
import epicsquid.roots.handler.PouchHandler;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.item.ItemPouch;
import epicsquid.roots.util.CommonHerbUtil;
import epicsquid.roots.util.ServerHerbUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerPouch
extends Container {
    private IItemHandlerModifiable inventoryHandler;
    private IItemHandlerModifiable herbsHandler;
    private IPouchHandler handler;
    private EntityPlayer player;
    private ItemStack pouch;
    private int inventoryBegin;
    private int herbsBegin;
    private int inventoryEnd;
    private int herbsEnd;
    private boolean isServerSide;

    public ContainerPouch(EntityPlayer player, boolean isServerSide) {
        this.player = player;
        this.isServerSide = isServerSide;
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        ItemStack first = isServerSide ? ServerHerbUtil.getFirstPouch(player) : CommonHerbUtil.getFirstPouch(player);
        ItemStack use = ItemStack.field_190927_a;
        if (main.func_77973_b() instanceof ItemPouch) {
            use = main;
        } else if (off.func_77973_b() instanceof ItemPouch) {
            use = off;
        } else if (first.func_77973_b() instanceof ItemPouch) {
            use = first;
        }
        this.handler = isServerSide ? PouchHandler.getHandler(use) : new ClientPouchHandler(use);
        this.inventoryHandler = this.handler.getInventory();
        this.herbsHandler = this.handler.getHerbs();
        this.pouch = use;
        this.createPlayerInventory(player.field_71071_by);
        this.createPouchSlots();
    }

    private void createPouchSlots() {
        if (this.isApothecary()) {
            this.createApothecaryPouchSlots();
        } else if (this.isFey()) {
            this.createFeyPouchSlots();
        } else if (this.isHerb()) {
            this.createHerbPouchSlots();
        } else {
            this.createComponentPouchSlots();
        }
    }

    public boolean isApothecary() {
        return this.handler.isApothecary();
    }

    public boolean isHerb() {
        return this.handler.isHerb();
    }

    public boolean isFey() {
        return this.handler.isFey();
    }

    private void createHerbPouchSlots() {
        int xOffset = -80;
        int yOffset = -50;
        for (int i = 0; i < 9; ++i) {
            int yPosOffset = 0;
            if (i >= 3) {
                yPosOffset += 21;
            }
            if (i >= 6) {
                yPosOffset += 22;
            }
            this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.herbsHandler, true, i, xOffset + 127 + 21 * (i % 3), yOffset + 23 + yPosOffset));
        }
        this.herbsBegin = 0;
        this.herbsEnd = 9;
        this.inventoryBegin = 0;
        this.inventoryEnd = 0;
    }

    private void createFeyPouchSlots() {
        int q;
        int xOffset = 13;
        int yOffset = -44;
        this.herbsBegin = q = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.herbsHandler, j + i * 4, xOffset + j * 20, 22 + yOffset + i * 20));
                ++q;
            }
        }
        this.herbsEnd = q;
        this.inventoryBegin = q;
        this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, 0, 103, -21));
        this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, 1, 123, -21));
        this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, 2, 103, -1));
        this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, 3, 123, -1));
        this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, 4, 103, 19));
        this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, 5, 123, 19));
        this.inventoryEnd = q + 6;
    }

    private void createComponentPouchSlots() {
        int i;
        int q;
        int xOffset = -13;
        int yOffset = -55;
        this.inventoryBegin = q = 0;
        for (i = 0; i < 12; ++i) {
            if (i < 5) {
                this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, q++, xOffset + 11 + i * 21, yOffset + 23));
            }
            if (i >= 5 && i < 9) {
                this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, q++, xOffset + 22 + (i - 5) * 21, yOffset + 44));
            }
            if (i < 9 || i >= 12) continue;
            this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, q++, xOffset + 33 + (i - 9) * 21, yOffset + 65));
        }
        this.inventoryEnd = q;
        this.herbsBegin = q;
        for (i = 0; i < 6; ++i) {
            if (q < 12 || q >= 18) continue;
            int yPosOffset = q >= 14 ? (q >= 16 ? 42 : 21) : 0;
            this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.herbsHandler, true, i, xOffset + 127 + 21 * (q % 2), yOffset + 23 + yPosOffset));
            ++q;
        }
        this.herbsEnd = q;
    }

    private void createApothecaryPouchSlots() {
        int i;
        int q;
        int xOffset = -35;
        int yOffset = -63;
        this.inventoryBegin = q = 0;
        for (i = 0; i < 18; ++i) {
            if (i < 6) {
                this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, q, xOffset + 25 + 20 * (q % 6), yOffset + 19));
            }
            if (i >= 6 && i < 12) {
                this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, q, xOffset + 25 + 20 * (q % 6), yOffset + 43));
            }
            if (i >= 12 && i < 18) {
                this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.inventoryHandler, q, xOffset + 25 + 20 * (q % 6), yOffset + 66));
            }
            ++q;
        }
        this.inventoryEnd = q;
        this.herbsBegin = q;
        for (i = 0; i < 9; ++i) {
            q = this.inventoryEnd + i;
            if (q >= 18 && q < 21) {
                this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.herbsHandler, true, i, xOffset + 149 + 16 * (q % 3), yOffset + 16 + 4 * (q % 2)));
            }
            if (q >= 21 && q < 24) {
                this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.herbsHandler, true, i, xOffset + 149 + 16 * (q % 3), yOffset + 39 + 4 * ((q + 1) % 2)));
            }
            if (q < 24 || q >= 27) continue;
            this.func_75146_a((Slot)new PouchSlot((IItemHandler)this.herbsHandler, true, i, xOffset + 149 + 16 * (q % 3), yOffset + 64 + 4 * (q % 2)));
        }
        this.herbsEnd = q;
    }

    private void createPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = -5;
        int yOffset = 70;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer player) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        ItemStack first = ServerHerbUtil.getFirstPouch(player);
        return main.equals(this.pouch) || off.equals(this.pouch) || first.equals(this.pouch);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack slotStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        int herbStart = this.herbsBegin + 36;
        int herbStop = this.herbsEnd + 36;
        int inventoryStart = this.inventoryBegin + 36;
        int inventoryStop = this.inventoryEnd + 36;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            slotStack = stack.func_77946_l();
            boolean herb = HerbRegistry.isHerb(slotStack.func_77973_b());
            if (index < 36 ? (herb && !this.func_75135_a(stack, herbStart, herbStop, false) ? !this.func_75135_a(stack, inventoryStart, inventoryStop, false) : !herb && !this.func_75135_a(stack, inventoryStart, inventoryStop, false)) : !this.func_75135_a(stack, 27, 36, false) && !this.func_75135_a(stack, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
        }
        return slotStack;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack stack;
        if (slotId >= 0 && (stack = this.func_75139_a(slotId).func_75211_c()).func_77973_b() instanceof ItemPouch) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.handler.markDirty();
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.player.field_70170_p.field_72995_K) {
            Objects.requireNonNull(this.player.field_70170_p.func_175693_T()).func_75744_a();
        }
    }

    public class PouchSlot
    extends SlotItemHandler {
        private final boolean herb;

        public PouchSlot(IItemHandler itemHandler, boolean herb, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.herb = herb;
        }

        public PouchSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.herb = false;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            if (stack.func_77973_b() instanceof ItemPouch) {
                return false;
            }
            if (this.herb && !HerbRegistry.isHerb(stack.func_77973_b())) {
                return false;
            }
            return super.func_75214_a(stack);
        }

        public void func_75220_a(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
            super.func_75220_a(stack1, stack2);
            ContainerPouch.this.handler.markDirty();
        }

        public void func_75218_e() {
            super.func_75218_e();
            ContainerPouch.this.handler.markDirty();
        }
    }
}

