/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.event;

import epicsquid.mysticallib.block.BlockBase;
import epicsquid.mysticalworld.init.ModItems;
import epicsquid.roots.compat.OldHerbRegistry;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModVillagers;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="roots")
public class MappingsEvent {
    @SubscribeEvent
    public static void onMissingPotionMappings(RegistryEvent.MissingMappings<Potion> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            ResourceLocation missing = mapping.key;
            if (!missing.func_110624_b().equals("roots")) continue;
            switch (missing.func_110623_a()) {
                case "invulnerability": {
                    mapping.remap((IForgeRegistryEntry)ModPotions.nondetection);
                    break;
                }
                case "freeze": {
                    mapping.remap((IForgeRegistryEntry)ModPotions.storm_cloud);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMissingProfessionMappings(RegistryEvent.MissingMappings<VillagerRegistry.VillagerProfession> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            ResourceLocation missing = mapping.key;
            if (!missing.func_110624_b().equals("roots")) continue;
            switch (missing.func_110623_a()) {
                case "druid": {
                    mapping.remap((IForgeRegistryEntry)ModVillagers.mageProfession);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            ResourceLocation missing = mapping.key;
            if (!missing.func_110624_b().equals("roots")) continue;
            switch (missing.func_110623_a()) {
                case "offering_plate": {
                    mapping.remap((IForgeRegistryEntry)ModBlocks.catalyst_plate);
                    break;
                }
                case "reinforced_offering_plate": {
                    mapping.remap((IForgeRegistryEntry)ModBlocks.reinforced_catalyst_plate);
                    break;
                }
                case "thatch": {
                    mapping.remap((IForgeRegistryEntry)epicsquid.mysticalworld.init.ModBlocks.thatch);
                    break;
                }
                case "grove_crafter": {
                    mapping.remap((IForgeRegistryEntry)ModBlocks.fey_crafter);
                    break;
                }
                case "fey_light": {
                    mapping.ignore();
                    break;
                }
                case "bonfire": {
                    mapping.remap((IForgeRegistryEntry)ModBlocks.pyre);
                    break;
                }
                case "decorative_bonfire": {
                    mapping.remap((IForgeRegistryEntry)ModBlocks.decorative_pyre);
                    break;
                }
                case "reinforced_bonfire": {
                    mapping.remap((IForgeRegistryEntry)ModBlocks.reinforced_pyre);
                    break;
                }
                case "offertory_plate": {
                    mapping.remap((IForgeRegistryEntry)ModBlocks.catalyst_plate);
                    break;
                }
                case "wildwood_rune": {
                    mapping.remap((IForgeRegistryEntry)ModBlocks.wildroot_rune);
                    break;
                }
                case "structure_marker": {
                    mapping.ignore();
                    break;
                }
                case "incense_burner": {
                    mapping.ignore();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMissingEntityMappings(RegistryEvent.MissingMappings<EntityEntry> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            ResourceLocation missing = mapping.key;
            if (!missing.func_110624_b().equals("roots")) continue;
            switch (missing.func_110623_a()) {
                case "entity_ritual_wild_growth": {
                    mapping.remap(ForgeRegistries.ENTITIES.getValue(new ResourceLocation("roots", "entity_ritual_wildroot_growth")));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMissingSoundMappings(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            if (!mapping.key.func_110624_b().equals("roots")) continue;
            mapping.ignore();
        }
    }

    @SubscribeEvent
    public static void onMissingHerbs(RegistryEvent.MissingMappings<OldHerbRegistry.Herb> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            mapping.ignore();
        }
    }

    @SubscribeEvent
    public static void onMissingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            ResourceLocation missing = mapping.key;
            if (!missing.func_110624_b().equals("roots")) continue;
            switch (missing.func_110623_a()) {
                case "spell_chrysopoeia": {
                    mapping.ignore();
                    break;
                }
                case "offering_plate": {
                    mapping.remap((IForgeRegistryEntry)((BlockBase)ModBlocks.catalyst_plate).getItemBlock());
                    break;
                }
                case "reinforced_offering_plate": {
                    mapping.remap((IForgeRegistryEntry)((BlockBase)ModBlocks.reinforced_catalyst_plate).getItemBlock());
                    break;
                }
                case "thatch": {
                    mapping.remap((IForgeRegistryEntry)((BlockBase)epicsquid.mysticalworld.init.ModBlocks.thatch).getItemBlock());
                    break;
                }
                case "grove_crafter": {
                    mapping.remap((IForgeRegistryEntry)((BlockBase)ModBlocks.fey_crafter).getItemBlock());
                    break;
                }
                case "fey_light": {
                    mapping.ignore();
                    break;
                }
                case "assorted_seeds": {
                    mapping.remap((IForgeRegistryEntry)ModItems.seeds);
                    break;
                }
                case "cooked_seeds": {
                    mapping.remap((IForgeRegistryEntry)ModItems.cooked_seeds);
                    break;
                }
                case "bonfire": {
                    mapping.remap((IForgeRegistryEntry)((BlockBase)ModBlocks.pyre).getItemBlock());
                    break;
                }
                case "decorative_bonfire": {
                    mapping.remap((IForgeRegistryEntry)((BlockBase)ModBlocks.decorative_pyre).getItemBlock());
                    break;
                }
                case "reinforced_bonfire": {
                    mapping.remap((IForgeRegistryEntry)((BlockBase)ModBlocks.reinforced_pyre).getItemBlock());
                    break;
                }
                case "offertory_plate": {
                    mapping.remap((IForgeRegistryEntry)((BlockBase)ModBlocks.catalyst_plate).getItemBlock());
                    break;
                }
                case "ritual_wild_growth": {
                    mapping.remap((IForgeRegistryEntry)epicsquid.roots.init.ModItems.ritual_wildroot_growth);
                    break;
                }
                case "wildwood_rune": {
                    mapping.remap((IForgeRegistryEntry)((BlockBase)ModBlocks.wildroot_rune).getItemBlock());
                    break;
                }
                case "structure_marker": {
                    mapping.ignore();
                    break;
                }
                case "incense_burner": {
                    mapping.ignore();
                    break;
                }
                case "fey_feather": {
                    mapping.remap((IForgeRegistryEntry)epicsquid.roots.init.ModItems.mystic_feather);
                    break;
                }
                case "strange_slime": {
                    mapping.remap((IForgeRegistryEntry)epicsquid.roots.init.ModItems.strange_ooze);
                    break;
                }
                case "golden_eye": {
                    mapping.ignore();
                }
            }
            if (!missing.func_110623_a().startsWith("runic_")) continue;
            ResourceLocation replacement = new ResourceLocation("roots", missing.func_110623_a().replace("runic_", "runed_"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(replacement);
            if (replacement == null) {
                throw new NullPointerException(replacement.toString() + " replacement for " + missing.toString() + " is null!");
            }
            mapping.remap((IForgeRegistryEntry)item);
        }
    }
}

