/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.init;

import com.google.common.collect.Lists;
import epicsquid.mysticallib.event.RegisterModRecipesEvent;
import epicsquid.mysticallib.recipe.factories.AccessibleCompoundIngredient;
import epicsquid.mysticallib.recipe.factories.MultiOreIngredient;
import epicsquid.mysticallib.recipe.factories.OreFallbackIngredient;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.entity.EntityBeetle;
import epicsquid.mysticalworld.entity.EntityClam;
import epicsquid.mysticalworld.entity.EntityDeer;
import epicsquid.mysticalworld.entity.EntityFox;
import epicsquid.mysticalworld.entity.EntityFrog;
import epicsquid.mysticalworld.entity.EntityHellSprout;
import epicsquid.mysticalworld.entity.EntityLavaCat;
import epicsquid.mysticalworld.entity.EntityOwl;
import epicsquid.mysticalworld.entity.EntitySilkworm;
import epicsquid.mysticalworld.entity.EntitySprout;
import epicsquid.mysticalworld.materials.Material;
import epicsquid.mysticalworld.materials.Materials;
import epicsquid.mysticalworld.recipe.Ingredients;
import epicsquid.roots.Roots;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.item.ItemDruidKnife;
import epicsquid.roots.recipe.AnimalHarvestFishRecipe;
import epicsquid.roots.recipe.AnimalHarvestRecipe;
import epicsquid.roots.recipe.ApothecaryPouchRecipe;
import epicsquid.roots.recipe.BarkRecipe;
import epicsquid.roots.recipe.ChrysopoeiaRecipe;
import epicsquid.roots.recipe.DyeRecipe;
import epicsquid.roots.recipe.FeyCraftingRecipe;
import epicsquid.roots.recipe.FeyPouchRecipe;
import epicsquid.roots.recipe.FlowerRecipe;
import epicsquid.roots.recipe.MortarRecipe;
import epicsquid.roots.recipe.PacifistEntry;
import epicsquid.roots.recipe.PyreCraftingRecipe;
import epicsquid.roots.recipe.RunicShearEntityRecipe;
import epicsquid.roots.recipe.RunicShearRecipe;
import epicsquid.roots.recipe.RunicShearRecipes;
import epicsquid.roots.recipe.SalmonRecipe;
import epicsquid.roots.recipe.SummonCreatureRecipe;
import epicsquid.roots.recipe.TransmutationRecipe;
import epicsquid.roots.recipe.ingredient.GoldOrSilverIngotIngredient;
import epicsquid.roots.recipe.transmutation.BlockStateAbove;
import epicsquid.roots.recipe.transmutation.BlockStateBelow;
import epicsquid.roots.recipe.transmutation.LavaPredicate;
import epicsquid.roots.recipe.transmutation.LeavesPredicate;
import epicsquid.roots.recipe.transmutation.MultiStatePropertyPredicate;
import epicsquid.roots.recipe.transmutation.PropertyPredicate;
import epicsquid.roots.recipe.transmutation.StatePredicate;
import epicsquid.roots.recipe.transmutation.WaterPredicate;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.util.IngredientWithStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;

public class ModRecipes {
    private static Map<ResourceLocation, ChrysopoeiaRecipe> chrysopoeiaRecipes = new HashMap<ResourceLocation, ChrysopoeiaRecipe>();
    private static Map<ResourceLocation, AnimalHarvestRecipe> harvestRecipes = new HashMap<ResourceLocation, AnimalHarvestRecipe>();
    private static Map<ResourceLocation, AnimalHarvestFishRecipe> fishRecipes = new HashMap<ResourceLocation, AnimalHarvestFishRecipe>();
    private static Set<Class<? extends EntityLivingBase>> harvestClasses = null;
    private static Map<ResourceLocation, TransmutationRecipe> transmutationRecipes = new HashMap<ResourceLocation, TransmutationRecipe>();
    private static Map<ResourceLocation, SummonCreatureRecipe> summonCreatureRecipes = new HashMap<ResourceLocation, SummonCreatureRecipe>();
    private static Map<Class<? extends EntityLivingBase>, SummonCreatureRecipe> summonCreatureClasses = new HashMap<Class<? extends EntityLivingBase>, SummonCreatureRecipe>();
    private static Map<ResourceLocation, MortarRecipe> mortarRecipes = new HashMap<ResourceLocation, MortarRecipe>();
    private static Map<ResourceLocation, PyreCraftingRecipe> pyreCraftingRecipes = new HashMap<ResourceLocation, PyreCraftingRecipe>();
    private static Map<ResourceLocation, FeyCraftingRecipe> feyCraftingRecipes = new HashMap<ResourceLocation, FeyCraftingRecipe>();
    private static Map<ResourceLocation, RunicShearRecipe> runicShearRecipes = new HashMap<ResourceLocation, RunicShearRecipe>();
    private static Map<ResourceLocation, RunicShearEntityRecipe> runicShearEntityRecipes = new HashMap<ResourceLocation, RunicShearEntityRecipe>();
    private static Map<Class<? extends Entity>, RunicShearEntityRecipe> generatedEntityRecipes = null;
    private static Map<ResourceLocation, PacifistEntry> pacifistEntities = new HashMap<ResourceLocation, PacifistEntry>();
    private static Map<Class<? extends Entity>, PacifistEntry> pacifistClasses = new HashMap<Class<? extends Entity>, PacifistEntry>();
    private static Map<ResourceLocation, BarkRecipe> barkRecipes = new HashMap<ResourceLocation, BarkRecipe>();
    private static Map<ResourceLocation, FlowerRecipe> flowerRecipes = new HashMap<ResourceLocation, FlowerRecipe>();
    public static boolean lifeEssenceCleared = false;
    public static Set<Class<? extends EntityLivingBase>> lifeEssenceAdditions = new HashSet<Class<? extends EntityLivingBase>>();
    public static Set<Class<? extends EntityLivingBase>> lifeEssenceRemovals = new HashSet<Class<? extends EntityLivingBase>>();
    private static Set<Class<? extends EntityLivingBase>> lifeEssenceList = new HashSet<Class<? extends EntityLivingBase>>();

    public static void initChrysopoeiaRecipes() {
        ModRecipes.addChrysopoeiaRecipe("gold_from_silver", new IngredientWithStack((Ingredient)new OreIngredient("ingotSilver"), 2), new ItemStack(Items.field_151043_k));
        ModRecipes.addChrysopoeiaRecipe("iron_from_copper", new IngredientWithStack((Ingredient)new OreIngredient("ingotCopper"), 2), new ItemStack(Items.field_151042_j));
        ModRecipes.addChrysopoeiaRecipe("gold_nugget_from_silver", new IngredientWithStack((Ingredient)new OreIngredient("nuggetSilver"), 2), new ItemStack(Items.field_151074_bl));
        ModRecipes.addChrysopoeiaRecipe("iron_nugget_from_copper", new IngredientWithStack((Ingredient)new OreIngredient("nuggetCopper"), 2), new ItemStack(Items.field_191525_da));
        ModRecipes.addChrysopoeiaRecipe("leather_from_rotten_flesh", new IngredientWithStack(Ingredient.func_193367_a((Item)Items.field_151078_bh), 10), new ItemStack(Items.field_151116_aA));
    }

    public static Collection<ChrysopoeiaRecipe> getChrysopoeiaRecipes() {
        return chrysopoeiaRecipes.values();
    }

    public static ChrysopoeiaRecipe addChrysopoeiaRecipe(String name, IngredientWithStack ingredient, ItemStack output) {
        return ModRecipes.addChrysopoeiaRecipe(new ResourceLocation("mysticalworld", name), ingredient, output);
    }

    public static ChrysopoeiaRecipe addChrysopoeiaRecipe(ResourceLocation name, IngredientWithStack ingredient, ItemStack output) {
        return ModRecipes.addChrysopoeiaRecipe(name, ingredient, output, ItemStack.field_190927_a, 0.0f, 0.0f);
    }

    public static ChrysopoeiaRecipe addChrysopoeiaRecipe(ResourceLocation name, IngredientWithStack inputs, ItemStack outputs, ItemStack byproduct, float overload, float byproductChance) {
        if (chrysopoeiaRecipes.containsKey(name)) {
            Roots.logger.error("Invalid key: " + name.toString() + " for Chrysopoeia recipe. Key already exists.");
            return null;
        }
        ChrysopoeiaRecipe recipe = new ChrysopoeiaRecipe(inputs, outputs, byproduct, overload, byproductChance);
        recipe.setRegistryName(name);
        chrysopoeiaRecipes.put(name, recipe);
        return recipe;
    }

    @Nullable
    public static ChrysopoeiaRecipe getChrysopoeiaRecipe(ItemStack stack) {
        for (ChrysopoeiaRecipe recipe : ModRecipes.getChrysopoeiaRecipes()) {
            if (!recipe.matches(stack)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static ChrysopoeiaRecipe getChrysopoeiaRecipeByOutput(ItemStack output) {
        for (ChrysopoeiaRecipe recipe : ModRecipes.getChrysopoeiaRecipes()) {
            if (!ItemUtil.equalWithoutSize((ItemStack)recipe.getOutput(), (ItemStack)output)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean removeChrysopoeiaRecipe(ResourceLocation name) {
        return chrysopoeiaRecipes.remove(name) != null;
    }

    public static boolean removeChrysopoeiaRecipe(ItemStack stack) {
        ChrysopoeiaRecipe recipe = ModRecipes.getChrysopoeiaRecipe(stack);
        if (recipe != null) {
            return ModRecipes.removeChrysopoeiaRecipe(recipe.getRegistryName());
        }
        return false;
    }

    public static boolean removeChrysopoeiaRecipeByOutput(ItemStack stack) {
        ChrysopoeiaRecipe recipe = ModRecipes.getChrysopoeiaRecipeByOutput(stack);
        if (recipe != null) {
            return ModRecipes.removeChrysopoeiaRecipe(recipe.getRegistryName());
        }
        return false;
    }

    public static void initSummonCreatureEntries() {
        ModRecipes.addSummonCreatureEntry("owl", EntityOwl.class, new Ingredient[]{new OreIngredient("treeSapling"), new OreIngredient("treeLeaves")});
        ModRecipes.addSummonCreatureEntry("deer", EntityDeer.class, Ingredient.func_193367_a((Item)ModItems.petals), Ingredient.func_193367_a((Item)ModItems.bark_oak));
        ModRecipes.addSummonCreatureEntry("sprout", EntitySprout.class, new Ingredient[]{Ingredient.func_193367_a((Item)ModItems.bark_birch), Ingredients.AUBERGINE});
        ModRecipes.addSummonCreatureEntry("beetle", EntityBeetle.class, new Ingredient[]{new OreIngredient("tallgrass"), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150328_O))});
        ModRecipes.addSummonCreatureEntry("frog", EntityFrog.class, new Ingredient[]{new OreIngredient("tallgrass"), Ingredient.func_193367_a((Item)Items.field_151119_aD)});
        ModRecipes.addSummonCreatureEntry("fox", EntityFox.class, new Ingredient[]{Ingredient.func_193367_a((Item)ModItems.bark_spruce), new OreIngredient("dustRedstone")});
        ModRecipes.addSummonCreatureEntry("wolf", EntityWolf.class, new Ingredient[]{new OreIngredient("bone"), Ingredient.func_193367_a((Item)Items.field_151145_ak)});
        ModRecipes.addSummonCreatureEntry("squid", EntitySquid.class, new Ingredient[]{new OreIngredient("sugarcane"), new OreIngredient("paper")});
        ModRecipes.addSummonCreatureEntry("sheep", EntitySheep.class, new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151014_N), new OreIngredient("wool")});
        ModRecipes.addSummonCreatureEntry("rabbit", EntityRabbit.class, new Ingredient[]{new OreIngredient("cropCarrot"), new OreIngredient("string")});
        ModRecipes.addSummonCreatureEntry("polar_bear", EntityPolarBear.class, new Ingredient[]{new OreIngredient("stone"), Ingredient.func_193367_a((Item)Items.field_151126_ay)});
        ModRecipes.addSummonCreatureEntry("pig", EntityPig.class, Ingredient.func_193367_a((Item)Items.field_185164_cV), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)epicsquid.mysticalworld.init.ModBlocks.wet_mud_block)));
        ModRecipes.addSummonCreatureEntry("mooshroom", EntityMooshroom.class, new Ingredient[]{new OreIngredient("cropWheat"), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150337_Q))});
        ModRecipes.addSummonCreatureEntry("cow", EntityCow.class, new Ingredient[]{new OreIngredient("cropWheat"), Ingredient.func_193367_a((Item)Items.field_151100_aR)});
        ModRecipes.addSummonCreatureEntry("horse", EntityHorse.class, new Ingredient[]{new OreIngredient("cropWheat"), Ingredient.func_193367_a((Item)Items.field_151034_e)});
        ModRecipes.addSummonCreatureEntry("llama", EntityLlama.class, new Ingredient[]{new OreIngredient("cropWheat"), new OreIngredient("wool")});
        ModRecipes.addSummonCreatureEntry("bat", EntityBat.class, new Ingredient[]{new OreIngredient("treeSapling"), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150321_G))});
        ModRecipes.addSummonCreatureEntry("chicken", EntityChicken.class, new Ingredient[]{new OreIngredient("egg"), Ingredient.func_193367_a((Item)Items.field_151014_N)});
        ModRecipes.addSummonCreatureEntry("donkey", EntityDonkey.class, new Ingredient[]{new OreIngredient("cropCarrot"), new OreIngredient("chestWood")});
        ModRecipes.addSummonCreatureEntry("parrot", EntityParrot.class, Ingredient.func_193367_a((Item)ModItems.bark_jungle), Ingredient.func_193367_a((Item)Items.field_185163_cU));
        ModRecipes.addSummonCreatureEntry("ocelot", EntityOcelot.class, new Ingredient[]{new OreIngredient("tallgrass"), Ingredient.func_193367_a((Item)Items.field_151102_aT)});
        ModRecipes.addSummonCreatureEntry("mule", EntityMule.class, new Ingredient[]{new OreIngredient("cropWheat"), Ingredient.func_193367_a((Item)Items.field_151044_h)});
        ModRecipes.addSummonCreatureEntry("zombie_pigman", EntityPigZombie.class, new Ingredient[]{new OreIngredient("nuggetGold"), Ingredient.func_193367_a((Item)Items.field_151147_al), Ingredient.func_193367_a((Item)Items.field_151112_aM)});
        ModRecipes.addSummonCreatureEntry("zombie", EntityZombie.class, new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b())}), Ingredient.func_193367_a((Item)Items.field_151078_bh), new OreIngredient("cropPotato")});
        ModRecipes.addSummonCreatureEntry("skeleton", EntitySkeleton.class, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b())}), Ingredient.func_193367_a((Item)Items.field_151145_ak), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)Items.field_151031_f, 1, Short.MAX_VALUE)}));
        ModRecipes.addSummonCreatureEntry("husk", EntityHusk.class, Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150434_aF)), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150330_I)), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Item.func_150898_a((Block)Blocks.field_150322_A), 1, BlockSandStone.EnumType.CHISELED.func_176675_a())}));
        ModRecipes.addSummonCreatureEntry("spider", EntitySpider.class, new Ingredient[]{Ingredient.func_193367_a((Item)ModItems.glass_eye), new OreIngredient("string"), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150468_ap))});
        ModRecipes.addSummonCreatureEntry("creeper", EntityCreeper.class, new Ingredient[]{Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150346_d)), new OreIngredient("tallgrass"), Ingredient.func_193367_a((Item)Items.field_151016_H)});
        ModRecipes.addSummonCreatureEntry("witch", EntityWitch.class, new Ingredient[]{new OreIngredient("stickWood"), new OreIngredient("dustRedstone"), new OreIngredient("string")});
        ModRecipes.addSummonCreatureEntry("stray", EntityStray.class, Ingredient.func_193367_a((Item)Items.field_151126_ay), Ingredient.func_193367_a((Item)Items.field_151145_ak), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)Items.field_151031_f, 1, Short.MAX_VALUE)}));
    }

    public static SummonCreatureRecipe addSummonCreatureEntry(String name, Class<? extends EntityLivingBase> clazz, Ingredient ... ingredients) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        SummonCreatureRecipe recipe = new SummonCreatureRecipe(rl, clazz, ingredients);
        return ModRecipes.addSummonCreatureEntry(recipe);
    }

    public static SummonCreatureRecipe addSummonCreatureEntry(String name, Class<? extends EntityLivingBase> clazz, List<Ingredient> ingredients) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        SummonCreatureRecipe recipe = new SummonCreatureRecipe(rl, clazz, ingredients);
        return ModRecipes.addSummonCreatureEntry(recipe);
    }

    public static SummonCreatureRecipe addSummonCreatureEntry(SummonCreatureRecipe recipe) {
        ResourceLocation rl = recipe.getRegistryName();
        if (summonCreatureRecipes.containsKey(rl)) {
            throw new IllegalArgumentException("Resource location " + rl.toString() + " already contained within the Summon Creatures registry.");
        }
        if (summonCreatureClasses.containsKey(recipe.getClazz())) {
            throw new IllegalArgumentException("Class " + recipe.getClazz().toString() + " already contained within the Summon Creatures registry.");
        }
        try {
            if (ModRecipes.findSummonCreatureEntry(recipe.getIngredients().stream().map(o -> o.func_193365_a()[0].func_77946_l()).collect(Collectors.toList())) != null) {
                throw new IllegalArgumentException("Combination of ingredients for recipe (" + rl.toString() + "/" + recipe.getClazz().toString() + ") is already in use!");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Invalid ingredient for recipe " + rl.toString());
        }
        summonCreatureRecipes.put(rl, recipe);
        summonCreatureClasses.put(recipe.getClazz(), recipe);
        return recipe;
    }

    @Nullable
    public static SummonCreatureRecipe getSummonCreatureEntry(String name) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        return ModRecipes.getSummonCreatureEntry(rl);
    }

    @Nullable
    public static SummonCreatureRecipe getSummonCreatureEntry(ResourceLocation location) {
        return summonCreatureRecipes.get(location);
    }

    @Nullable
    public static SummonCreatureRecipe getSummonCreatureEntry(Class<? extends Entity> clazz) {
        return summonCreatureClasses.get(clazz);
    }

    public static Collection<SummonCreatureRecipe> getSummonCreatureEntries() {
        return summonCreatureRecipes.values();
    }

    @Nullable
    public static SummonCreatureRecipe findSummonCreatureEntry(List<ItemStack> ingredients) {
        for (SummonCreatureRecipe recipe : ModRecipes.getSummonCreatureEntries()) {
            if (!recipe.matches(ingredients)) continue;
            return recipe;
        }
        return null;
    }

    public static void removeLifeEssence(Class<? extends EntityLivingBase> clzz) {
        lifeEssenceRemovals.add(clzz);
    }

    public static void addLifeEssence(Class<? extends EntityLivingBase> clazz) {
        lifeEssenceAdditions.add(clazz);
    }

    public static void clearLifeEssence() {
        lifeEssenceCleared = true;
    }

    public static void generateLifeEssence() {
        lifeEssenceList.clear();
        if (!lifeEssenceCleared) {
            lifeEssenceList.addAll(ModRecipes.getAnimalHarvestClasses());
        }
        lifeEssenceList.addAll(lifeEssenceAdditions);
        lifeEssenceList.removeAll(lifeEssenceRemovals);
    }

    public static Set<Class<? extends EntityLivingBase>> getLifeEssenceList() {
        return lifeEssenceList;
    }

    public static boolean isLifeEssenceAllowed(Class<? extends EntityLivingBase> clzz) {
        return lifeEssenceList.contains(clzz);
    }

    public static boolean isLifeEssenceAllowed(EntityLivingBase entity) {
        return ModRecipes.isLifeEssenceAllowed(entity.getClass());
    }

    public static void removeSummonCreatureEntry(Class<? extends EntityLivingBase> clazz) {
        SummonCreatureRecipe recipe = summonCreatureClasses.remove(clazz);
        if (recipe != null) {
            summonCreatureRecipes.remove(recipe.getRegistryName());
        }
    }

    public static void removeSummonCreatureEntry(String name) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        ModRecipes.removeSummonCreatureEntry(rl);
    }

    public static void removeSummonCreatureEntry(ResourceLocation location) {
        SummonCreatureRecipe recipe = summonCreatureRecipes.get(location);
        if (recipe == null) {
            return;
        }
        summonCreatureRecipes.remove(location);
        summonCreatureClasses.remove(recipe.getClazz());
    }

    public static PacifistEntry addPacifistEntry(String name, Class<? extends Entity> clazz) {
        PacifistEntry entry = new PacifistEntry(clazz, name);
        pacifistEntities.put(entry.getRegistryName(), entry);
        pacifistClasses.put(clazz, entry);
        return entry;
    }

    public static PacifistEntry getPacifistEntry(String name) {
        return ModRecipes.getPacifistEntry(new ResourceLocation("roots", name));
    }

    public static PacifistEntry getPacifistEntry(ResourceLocation name) {
        return pacifistEntities.get(name);
    }

    public static PacifistEntry getPacifistEntry(Entity entity) {
        return pacifistClasses.get(entity.getClass());
    }

    public static void removePacifistEntry(String name) {
        ModRecipes.removePacifistEntry(new ResourceLocation("roots", name));
    }

    public static void removePacifistEntry(ResourceLocation name) {
        PacifistEntry entry = ModRecipes.getPacifistEntry(name);
        if (entry != null) {
            pacifistEntities.remove(name);
            pacifistClasses.remove(entry.getEntityClass());
        }
    }

    public static Map<ResourceLocation, PacifistEntry> getPacifistEntities() {
        return pacifistEntities;
    }

    public static void initPacifistEntities() {
        ModRecipes.addPacifistEntry("chicken", EntityChicken.class);
        ModRecipes.addPacifistEntry("cow", EntityCow.class);
        ModRecipes.addPacifistEntry("donkey", EntityDonkey.class);
        ModRecipes.addPacifistEntry("horse", EntityHorse.class);
        ModRecipes.addPacifistEntry("llama", EntityLlama.class);
        ModRecipes.addPacifistEntry("mooshroom", EntityMooshroom.class);
        ModRecipes.addPacifistEntry("mule", EntityMule.class);
        ModRecipes.addPacifistEntry("ocelot", EntityOcelot.class);
        ModRecipes.addPacifistEntry("parrot", EntityParrot.class);
        ModRecipes.addPacifistEntry("pig", EntityPig.class);
        ModRecipes.addPacifistEntry("rabbit", EntityRabbit.class);
        ModRecipes.addPacifistEntry("sheep", EntitySheep.class);
        ModRecipes.addPacifistEntry("squid", EntitySquid.class);
        ModRecipes.addPacifistEntry("villager", EntityVillager.class).setCheckTarget(true);
        ModRecipes.addPacifistEntry("wolf", EntityWolf.class);
        ModRecipes.addPacifistEntry("beetle", EntityBeetle.class);
        ModRecipes.addPacifistEntry("deer", EntityDeer.class);
        ModRecipes.addPacifistEntry("fox", EntityFox.class);
        ModRecipes.addPacifistEntry("frog", EntityFrog.class);
        ModRecipes.addPacifistEntry("owl", EntityOwl.class);
        ModRecipes.addPacifistEntry("sprout", EntitySprout.class);
        ModRecipes.addPacifistEntry("silkworm", EntitySilkworm.class);
        ModRecipes.addPacifistEntry("lava_cat", EntityLavaCat.class);
        ModRecipes.addPacifistEntry("hellsprout", EntityHellSprout.class);
        ModRecipes.addPacifistEntry("clam", EntityClam.class);
    }

    public static void addFlowerRecipe(String name, IBlockState state) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        FlowerRecipe recipe = new FlowerRecipe(rl, state);
        flowerRecipes.put(rl, recipe);
    }

    public static void addFlowerRecipe(String name, Block block, int meta) {
        ModRecipes.addFlowerRecipe(name, block, meta, Collections.emptyList());
    }

    public static void addFlowerRecipe(String name, Block block, int meta, List<Ingredient> allowedSoils) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        FlowerRecipe recipe = new FlowerRecipe(rl, meta, block, allowedSoils);
        flowerRecipes.put(rl, recipe);
    }

    public static void removeFlowerRecipe(ResourceLocation name) {
        flowerRecipes.remove(name);
    }

    public static IBlockState getRandomFlowerRecipe(IBlockState soil) {
        if (flowerRecipes.isEmpty()) {
            return Blocks.field_150327_N.func_176203_a(BlockFlower.EnumFlowerType.DANDELION.func_176968_b());
        }
        ItemStack soilStack = ItemUtil.stackFromState((IBlockState)soil);
        ArrayList<FlowerRecipe> matches = new ArrayList<FlowerRecipe>();
        block0: for (FlowerRecipe recipe : flowerRecipes.values()) {
            if (recipe.getAllowedSoils().isEmpty()) {
                matches.add(recipe);
                continue;
            }
            for (Ingredient allowedSoil : recipe.getAllowedSoils()) {
                if (!allowedSoil.apply(soilStack)) continue;
                matches.add(recipe);
                continue block0;
            }
        }
        if (matches.isEmpty()) {
            return null;
        }
        return ((FlowerRecipe)matches.get(Util.rand.nextInt(matches.size()))).getFlower();
    }

    public static Map<ResourceLocation, FlowerRecipe> getFlowerRecipes() {
        return flowerRecipes;
    }

    @Nullable
    public static FlowerRecipe getFlowerRecipe(IBlockState state) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        for (FlowerRecipe recipe : flowerRecipes.values()) {
            if (!recipe.matches(block, meta)) continue;
            return recipe;
        }
        return null;
    }

    public static void initFlowerRecipes() {
        ModRecipes.addFlowerRecipe("dandelion", Blocks.field_150327_N.func_176203_a(BlockFlower.EnumFlowerType.DANDELION.func_176968_b()));
        ModRecipes.addFlowerRecipe("poppy", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.POPPY.func_176968_b()));
        ModRecipes.addFlowerRecipe("blue_orchid", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()));
        ModRecipes.addFlowerRecipe("allium", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.ALLIUM.func_176968_b()));
        ModRecipes.addFlowerRecipe("houstonia", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b()));
        ModRecipes.addFlowerRecipe("red_tulip", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b()));
        ModRecipes.addFlowerRecipe("orange_tulip", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.ORANGE_TULIP.func_176968_b()));
        ModRecipes.addFlowerRecipe("white_tulip", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b()));
        ModRecipes.addFlowerRecipe("pink_tulip", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b()));
        ModRecipes.addFlowerRecipe("oxeye_daisy", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b()));
    }

    public static void addVanillaBarkRecipe(String name, BlockPlanks.EnumType type, ItemStack item) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        barkRecipes.put(rl, new BarkRecipe(rl, item, type));
    }

    public static void initVanillaBarkRecipes() {
        ModRecipes.addVanillaBarkRecipe("oak", BlockPlanks.EnumType.OAK, new ItemStack(ModItems.bark_oak, 4));
        ModRecipes.addVanillaBarkRecipe("spruce", BlockPlanks.EnumType.SPRUCE, new ItemStack(ModItems.bark_spruce, 4));
        ModRecipes.addVanillaBarkRecipe("birch", BlockPlanks.EnumType.BIRCH, new ItemStack(ModItems.bark_birch, 4));
        ModRecipes.addVanillaBarkRecipe("jungle", BlockPlanks.EnumType.JUNGLE, new ItemStack(ModItems.bark_jungle, 4));
        ModRecipes.addVanillaBarkRecipe("acacia", BlockPlanks.EnumType.ACACIA, new ItemStack(ModItems.bark_acacia, 4));
        ModRecipes.addVanillaBarkRecipe("dark_oak", BlockPlanks.EnumType.DARK_OAK, new ItemStack(ModItems.bark_dark_oak, 4));
    }

    public static void initModdedBarkRecipes() {
        ModRecipes.addModdedBarkRecipe("wildwood", new ItemStack(ModItems.bark_wildwood, 4), new ItemStack(ModBlocks.wildwood_log));
    }

    public static void addModdedBarkRecipe(String name, ItemStack item, ItemStack blockStack) {
        if (blockStack.func_77973_b() instanceof ItemBlock) {
            for (Item knife : ModItems.knives) {
                ((ItemDruidKnife)knife).addEffectiveBlock(((ItemBlock)blockStack.func_77973_b()).func_179223_d());
            }
        }
        ResourceLocation rl = new ResourceLocation("roots", name);
        barkRecipes.put(rl, new BarkRecipe(rl, item, blockStack));
    }

    @Nullable
    public static BarkRecipe getBarkRecipeByName(ResourceLocation name) {
        return barkRecipes.get(name);
    }

    @Nullable
    public static BarkRecipe getModdedBarkRecipe(IBlockState block) {
        ItemStack stack = new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_180651_a(block));
        for (BarkRecipe recipe : barkRecipes.values()) {
            if (!ItemUtil.equalWithoutSize((ItemStack)recipe.getBlockStack(), (ItemStack)stack)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static BarkRecipe getVanillaBarkRecipe(BlockPlanks.EnumType type) {
        for (BarkRecipe recipe : barkRecipes.values()) {
            if (recipe.getType() != type) continue;
            return recipe;
        }
        return null;
    }

    public static Collection<BarkRecipe> getBarkRecipes() {
        return barkRecipes.values();
    }

    public static Map<ResourceLocation, BarkRecipe> getBarkRecipeMap() {
        return barkRecipes;
    }

    public static boolean removeBarkRecipe(ItemStack stack) {
        ArrayList<BarkRecipe> toRemove = new ArrayList<BarkRecipe>();
        for (BarkRecipe recipe : barkRecipes.values()) {
            if (!ItemUtil.equalWithoutSize((ItemStack)stack, (ItemStack)recipe.getItem())) continue;
            toRemove.add(recipe);
            break;
        }
        if (!toRemove.isEmpty()) {
            for (BarkRecipe removing : toRemove) {
                barkRecipes.remove(removing.getName());
            }
            return true;
        }
        return false;
    }

    public static void addTransmutationRecipe(String name, TransmutationRecipe recipe) {
        ResourceLocation n = new ResourceLocation("roots", name);
        recipe.setRegistryName(n);
        transmutationRecipes.put(n, recipe);
    }

    public static void addTransmutationRecipe(TransmutationRecipe recipe) {
        ResourceLocation n = recipe.getRegistryName();
        transmutationRecipes.put(n, recipe);
    }

    public static boolean removeTransmutationRecipe(ResourceLocation name) {
        return transmutationRecipes.remove(name) != null;
    }

    public static TransmutationRecipe getTransmutationRecipe(ResourceLocation name) {
        return transmutationRecipes.get(name);
    }

    public static Collection<TransmutationRecipe> getTransmutationRecipes() {
        return transmutationRecipes.values();
    }

    public static List<TransmutationRecipe> getTransmutationRecipesFor(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return ModRecipes.getTransmutationRecipesFor(state, world, pos);
    }

    public static List<TransmutationRecipe> getTransmutationRecipesFor(IBlockState state, World world, BlockPos pos) {
        ArrayList<TransmutationRecipe> result = new ArrayList<TransmutationRecipe>();
        for (TransmutationRecipe recipe : ModRecipes.getTransmutationRecipes()) {
            if (!recipe.matches(state, world, pos)) continue;
            result.add(recipe);
        }
        return result;
    }

    public static void initTransmutationRecipes() {
        WaterPredicate water = new WaterPredicate();
        LavaPredicate lava = new LavaPredicate();
        StatePredicate wool = new StatePredicate(Blocks.field_150325_L.func_176223_P());
        LeavesPredicate leaves = new LeavesPredicate();
        StatePredicate cobblestone = new StatePredicate(Blocks.field_150347_e.func_176223_P());
        StatePredicate sand = new StatePredicate(Blocks.field_150354_m.func_176223_P());
        StatePredicate cobblestoneSlab = new StatePredicate(ModBlocks.runestone_slab.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
        TransmutationRecipe deadbush_cocoa = new TransmutationRecipe(Blocks.field_150330_I.func_176223_P()).item(new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.BROWN.func_176767_b()));
        ModRecipes.addTransmutationRecipe("deadbush_cocoa", deadbush_cocoa);
        TransmutationRecipe birch_jungle = new TransmutationRecipe(new PropertyPredicate(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH), (IProperty<?>)BlockOldLog.field_176301_b)).state(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE));
        ModRecipes.addTransmutationRecipe("birch_jungle", birch_jungle);
        TransmutationRecipe birch_jungle_leaves = new TransmutationRecipe(new PropertyPredicate(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH), (IProperty<?>)BlockOldLeaf.field_176239_P)).state(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE));
        ModRecipes.addTransmutationRecipe("birch_jungle_leaves", birch_jungle_leaves);
        TransmutationRecipe pumpkin_to_melon = new TransmutationRecipe(Blocks.field_150423_aK.func_176223_P()).state(Blocks.field_150440_ba.func_176223_P()).condition(new BlockStateBelow(water));
        ModRecipes.addTransmutationRecipe("pumpkin_to_melon", pumpkin_to_melon);
        TransmutationRecipe pumpkin_to_cactus = new TransmutationRecipe(Blocks.field_150423_aK.func_176223_P()).state(Blocks.field_150434_aF.func_176223_P()).condition(new BlockStateBelow(sand));
        ModRecipes.addTransmutationRecipe("pumpkin_to_cactus", pumpkin_to_cactus);
        TransmutationRecipe cocoa_to_carrot = new TransmutationRecipe(Blocks.field_150375_by.func_176223_P()).item(new ItemStack(Items.field_151172_bF));
        ModRecipes.addTransmutationRecipe("cocoa_to_carrot", cocoa_to_carrot);
        TransmutationRecipe carrot_to_beetroot = new TransmutationRecipe(new PropertyPredicate(Blocks.field_150459_bM.func_176223_P().func_177226_a((IProperty)BlockCrops.field_176488_a, (Comparable)Integer.valueOf(7)), (IProperty<?>)BlockCrops.field_176488_a)).state(Blocks.field_185773_cZ.func_176223_P().func_177226_a((IProperty)BlockBeetroot.field_185531_a, (Comparable)Integer.valueOf(3)));
        ModRecipes.addTransmutationRecipe("carrot_to_beetroot", carrot_to_beetroot);
        TransmutationRecipe carpet_to_lilypad = new TransmutationRecipe(Blocks.field_150404_cg.func_176223_P()).state(Blocks.field_150392_bi.func_176223_P()).condition(new BlockStateBelow(water));
        ModRecipes.addTransmutationRecipe("carpet_to_lilypad", carpet_to_lilypad);
        TransmutationRecipe trapdoor_to_cobweb = new TransmutationRecipe(Blocks.field_150415_aT.func_176223_P()).state(Blocks.field_150321_G.func_176223_P()).condition(new BlockStateBelow(wool));
        ModRecipes.addTransmutationRecipe("trapdoor_to_cobweb", trapdoor_to_cobweb);
        TransmutationRecipe redstone_to_vines = new TransmutationRecipe(Blocks.field_150488_af.func_176223_P()).item(new ItemStack(Blocks.field_150395_bd)).condition(new BlockStateAbove(cobblestone));
        ModRecipes.addTransmutationRecipe("redstone_to_vines", redstone_to_vines);
        TransmutationRecipe melon_to_pumpkin = new TransmutationRecipe(Blocks.field_150440_ba.func_176223_P()).state(Blocks.field_150423_aK.func_176223_P()).condition(new BlockStateBelow(cobblestone));
        ModRecipes.addTransmutationRecipe("melon_to_pumpkin", melon_to_pumpkin);
        TransmutationRecipe redstone_block_to_glowstone = new TransmutationRecipe(Blocks.field_150451_bX.func_176223_P()).state(Blocks.field_150426_aN.func_176223_P()).condition(new BlockStateBelow(lava));
        ModRecipes.addTransmutationRecipe("redstone_block_to_glowstone", redstone_block_to_glowstone);
        TransmutationRecipe carpet_diorite = new TransmutationRecipe(Blocks.field_150404_cg.func_176223_P()).state(Blocks.field_150431_aC.func_176223_P()).condition(new BlockStateBelow(new MultiStatePropertyPredicate((IProperty<?>)BlockStone.field_176247_a, Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE_SMOOTH))));
        ModRecipes.addTransmutationRecipe("carpet_to_snow", carpet_diorite);
        TransmutationRecipe lever_brown_mushroom = new TransmutationRecipe(Blocks.field_150442_at.func_176223_P()).state(Blocks.field_150338_P.func_176223_P()).condition(new BlockStateBelow(new PropertyPredicate(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL), (IProperty<?>)BlockDirt.field_176386_a)));
        ModRecipes.addTransmutationRecipe("lever_to_brown_mushroom", lever_brown_mushroom);
        TransmutationRecipe redstone_torch_red_mushroom = new TransmutationRecipe(Blocks.field_150429_aA.func_176223_P()).state(Blocks.field_150337_Q.func_176223_P()).condition(new BlockStateBelow(new PropertyPredicate(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL), (IProperty<?>)BlockDirt.field_176386_a)));
        ModRecipes.addTransmutationRecipe("redstone_torch_to_red_mushroom", redstone_torch_red_mushroom);
    }

    public static void addAnimalHarvestRecipe(EntityLivingBase entity) {
        ModRecipes.addAnimalHarvestRecipe(EntityList.func_75621_b((Entity)entity), entity);
    }

    public static void addAnimalHarvestRecipe(String name, EntityLivingBase entity) {
        ModRecipes.addAnimalHarvestRecipe(name, entity.getClass());
    }

    public static void addAnimalHarvestRecipe(String name, Class<? extends EntityLivingBase> clazz) {
        ResourceLocation n = new ResourceLocation("roots", name);
        if (harvestRecipes.containsKey(n)) {
            Roots.logger.error("Animal Harvest recipe name is already registered: " + n.toString());
            return;
        }
        AnimalHarvestRecipe recipe = new AnimalHarvestRecipe(n, clazz);
        harvestRecipes.put(n, recipe);
        harvestClasses = null;
    }

    public static void removeAnimalHarvestRecipe(ResourceLocation location) {
        harvestClasses = null;
        harvestRecipes.remove(location);
    }

    public static void removeAnimalHarvestRecipe(Class<? extends Entity> clz) {
        harvestClasses = null;
        ResourceLocation toRemove = null;
        for (Map.Entry<ResourceLocation, AnimalHarvestRecipe> entry : harvestRecipes.entrySet()) {
            AnimalHarvestRecipe recipe = entry.getValue();
            if (!recipe.getHarvestClass().equals(clz)) continue;
            toRemove = entry.getKey();
        }
        if (toRemove != null) {
            harvestRecipes.remove(toRemove);
        }
    }

    public static void removeAnimalHarvestRecipe(Entity entity) {
        ResourceLocation n = new ResourceLocation("roots", entity.func_70005_c_());
        if (harvestRecipes.containsKey(n)) {
            harvestRecipes.remove(n);
            harvestClasses = null;
        } else {
            n = null;
            for (Map.Entry<ResourceLocation, AnimalHarvestRecipe> entry : harvestRecipes.entrySet()) {
                if (!entry.getValue().matches(entity)) continue;
                n = entry.getKey();
                break;
            }
            if (n != null) {
                harvestRecipes.remove(n);
                harvestClasses = null;
            }
        }
    }

    public static Map<ResourceLocation, AnimalHarvestRecipe> getAnimalHarvestRecipes() {
        return harvestRecipes;
    }

    public static Map<ResourceLocation, AnimalHarvestFishRecipe> getAnimalHarvestFishRecipes() {
        return fishRecipes;
    }

    public static AnimalHarvestRecipe getAnimalHarvestRecipe(ResourceLocation location) {
        return harvestRecipes.getOrDefault(location, null);
    }

    public static AnimalHarvestRecipe getAnimalHarvestRecipe(Entity entity) {
        ResourceLocation n = new ResourceLocation("roots", entity.func_70005_c_());
        if (harvestRecipes.containsKey(n)) {
            return harvestRecipes.get(n);
        }
        for (AnimalHarvestRecipe recipe : harvestRecipes.values()) {
            if (!recipe.matches(entity)) continue;
            return recipe;
        }
        return null;
    }

    public static Set<Class<? extends EntityLivingBase>> getAnimalHarvestClasses() {
        if (harvestClasses == null || harvestClasses.size() != harvestRecipes.size()) {
            harvestClasses = new HashSet<Class<? extends EntityLivingBase>>();
            for (AnimalHarvestRecipe recipe : harvestRecipes.values()) {
                harvestClasses.add(recipe.getHarvestClass());
            }
        }
        return harvestClasses;
    }

    public static void addAnimalHarvestFishRecipe(String name, ItemStack item, int weight) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        if (ModRecipes.getAnimalHarvestFishRecipe(rl) != null) {
            return;
        }
        if (ModRecipes.getAnimalHarvestFishRecipe(item) != null) {
            return;
        }
        AnimalHarvestFishRecipe recipe = new AnimalHarvestFishRecipe(rl, item, weight);
        fishRecipes.put(rl, recipe);
    }

    @Nullable
    public static AnimalHarvestFishRecipe getAnimalHarvestFishRecipe(ItemStack item) {
        for (AnimalHarvestFishRecipe recipe : fishRecipes.values()) {
            if (!ItemUtil.equalWithoutSize((ItemStack)recipe.getItemStack(), (ItemStack)item)) continue;
            return recipe;
        }
        return null;
    }

    public static AnimalHarvestFishRecipe getAnimalHarvestFishRecipe(ResourceLocation resource) {
        return fishRecipes.get(resource);
    }

    public static boolean removeAnimalHarvestFishRecipe(ResourceLocation resource) {
        return fishRecipes.remove(resource) != null;
    }

    public static boolean removeAnimalHarvestFishRecipe(ItemStack item) {
        AnimalHarvestFishRecipe recipe = ModRecipes.getAnimalHarvestFishRecipe(item);
        if (recipe == null) {
            return false;
        }
        return fishRecipes.remove(recipe.getRegistryName()) != null;
    }

    public static List<AnimalHarvestFishRecipe> getFishRecipes() {
        return Lists.newArrayList(fishRecipes.values());
    }

    public static void clearFishRecipes() {
        fishRecipes.clear();
    }

    public static void initAnimalHarvestRecipes() {
        ModRecipes.addAnimalHarvestRecipe("bat", EntityBat.class);
        ModRecipes.addAnimalHarvestRecipe("chicken", EntityChicken.class);
        ModRecipes.addAnimalHarvestRecipe("cow", EntityCow.class);
        ModRecipes.addAnimalHarvestRecipe("donkey", EntityDonkey.class);
        ModRecipes.addAnimalHarvestRecipe("horse", EntityHorse.class);
        ModRecipes.addAnimalHarvestRecipe("llama", EntityLlama.class);
        ModRecipes.addAnimalHarvestRecipe("mooshroom", EntityMooshroom.class);
        ModRecipes.addAnimalHarvestRecipe("mule", EntityMule.class);
        ModRecipes.addAnimalHarvestRecipe("ocelot", EntityOcelot.class);
        ModRecipes.addAnimalHarvestRecipe("parrot", EntityParrot.class);
        ModRecipes.addAnimalHarvestRecipe("pig", EntityPig.class);
        ModRecipes.addAnimalHarvestRecipe("rabbit", EntityRabbit.class);
        ModRecipes.addAnimalHarvestRecipe("sheep", EntitySheep.class);
        ModRecipes.addAnimalHarvestRecipe("squid", EntitySquid.class);
        ModRecipes.addAnimalHarvestRecipe("wolf", EntityWolf.class);
        ModRecipes.addAnimalHarvestRecipe("polar_bear", EntityPolarBear.class);
        ModRecipes.addAnimalHarvestRecipe("beetle", EntityBeetle.class);
        ModRecipes.addAnimalHarvestRecipe("deer", EntityDeer.class);
        ModRecipes.addAnimalHarvestRecipe("fox", EntityFox.class);
        ModRecipes.addAnimalHarvestRecipe("frog", EntityFrog.class);
        ModRecipes.addAnimalHarvestRecipe("owl", EntityOwl.class);
        ModRecipes.addAnimalHarvestRecipe("sprout", EntitySprout.class);
        ModRecipes.addAnimalHarvestRecipe("lava_cat", EntityLavaCat.class);
        ModRecipes.addAnimalHarvestRecipe("hellsprout", EntityHellSprout.class);
        ModRecipes.addAnimalHarvestRecipe("silkworm", EntitySilkworm.class);
        ModRecipes.addAnimalHarvestRecipe("clam", EntityClam.class);
        ModRecipes.addAnimalHarvestFishRecipe("cod", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()), 60);
        ModRecipes.addAnimalHarvestFishRecipe("salmon", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), 25);
        ModRecipes.addAnimalHarvestFishRecipe("clownfish", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), 2);
        ModRecipes.addAnimalHarvestFishRecipe("pufferfish", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), 13);
    }

    public static void addRunicShearRecipe(RunicShearRecipe recipe) {
        if (recipe instanceof RunicShearEntityRecipe) {
            RunicShearEntityRecipe eRecipe = (RunicShearEntityRecipe)recipe;
            for (RunicShearEntityRecipe entityRecipe : runicShearEntityRecipes.values()) {
                if (!entityRecipe.getClazz().equals(eRecipe.getClazz())) continue;
                Roots.logger.error("RunicShearEntityRecipe duplicate found for class " + eRecipe.getClazz().getSimpleName());
                return;
            }
            runicShearEntityRecipes.put(eRecipe.getRegistryName(), eRecipe);
        } else {
            runicShearRecipes.put(recipe.getRegistryName(), recipe);
        }
    }

    public static RunicShearRecipe getRunicShearRecipe(IBlockState state) {
        for (RunicShearRecipe recipe : runicShearRecipes.values()) {
            if (!recipe.matches(state)) continue;
            return recipe;
        }
        return null;
    }

    public static void clearGeneratedEntityRecipes() {
        generatedEntityRecipes = null;
    }

    private static void generateEntityRecipes() {
        generatedEntityRecipes = new HashMap<Class<? extends Entity>, RunicShearEntityRecipe>();
        for (RunicShearEntityRecipe recipe : runicShearEntityRecipes.values()) {
            generatedEntityRecipes.put(recipe.getClazz(), recipe);
        }
    }

    public static RunicShearEntityRecipe getRunicShearRecipe(EntityLivingBase entity) {
        if (generatedEntityRecipes == null || generatedEntityRecipes.isEmpty()) {
            ModRecipes.generateEntityRecipes();
        }
        return generatedEntityRecipes.get(entity.getClass());
    }

    public static RunicShearRecipe getRunicShearRecipe(String name) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        return runicShearRecipes.get(rl);
    }

    public static Set<RunicShearRecipe> getRunicShearRecipe(ItemStack stack) {
        HashSet<RunicShearRecipe> result = new HashSet<RunicShearRecipe>();
        for (RunicShearRecipe recipe : runicShearRecipes.values()) {
            if (!recipe.getDropMatch().test((Object)stack)) continue;
            result.add(recipe);
        }
        return result;
    }

    public static Set<RunicShearEntityRecipe> getRunicShearEntityRecipe(ItemStack stack) {
        HashSet<RunicShearEntityRecipe> result = new HashSet<RunicShearEntityRecipe>();
        for (RunicShearEntityRecipe recipe : runicShearEntityRecipes.values()) {
            if (!recipe.getDropMatch().test((Object)stack)) continue;
            result.add(recipe);
        }
        return result;
    }

    @Nullable
    public static RunicShearEntityRecipe getRunicShearEntityRecipe(Class<? extends EntityLivingBase> entity) {
        for (RunicShearEntityRecipe recipe : runicShearEntityRecipes.values()) {
            if (!recipe.getClazz().equals(entity)) continue;
            return recipe;
        }
        return null;
    }

    public static Set<Class<? extends Entity>> getRunicShearEntities() {
        if (generatedEntityRecipes == null) {
            ModRecipes.generateEntityRecipes();
        }
        return generatedEntityRecipes.keySet();
    }

    public static void addMortarRecipe(MortarRecipe recipe) {
        mortarRecipes.put(recipe.getRegistryName(), recipe);
    }

    public static MortarRecipe getMortarRecipe(List<ItemStack> items) {
        for (MortarRecipe mortarRecipe : mortarRecipes.values()) {
            if (!mortarRecipe.matches(items)) continue;
            return mortarRecipe;
        }
        return null;
    }

    public static MortarRecipe getMortarRecipe(ResourceLocation name) {
        return mortarRecipes.get(name);
    }

    public static void removeMortarRecipes(ItemStack output) {
        MortarRecipe recipeToRemove = ModRecipes.getMortarRecipe(output);
        if (recipeToRemove != null) {
            while (recipeToRemove != null) {
                mortarRecipes.remove(recipeToRemove.getRegistryName());
                recipeToRemove = ModRecipes.getMortarRecipe(output);
            }
        }
    }

    public static void removeMortarRecipe(ResourceLocation location) {
        mortarRecipes.remove(location);
    }

    public static void removeMortarRecipe(String name) {
        ModRecipes.removeMortarRecipe(new ResourceLocation("roots", name));
    }

    public static MortarRecipe getMortarRecipe(ItemStack output) {
        for (MortarRecipe mortarRecipe : mortarRecipes.values()) {
            if (!ItemUtil.equalWithoutSize((ItemStack)mortarRecipe.getResult(), (ItemStack)output)) continue;
            return mortarRecipe;
        }
        return null;
    }

    public static List<MortarRecipe> getMortarRecipes(String name, int meta) {
        ArrayList<MortarRecipe> recipes = new ArrayList<MortarRecipe>();
        for (MortarRecipe recipe : mortarRecipes.values()) {
            if (!recipe.getResult().func_77973_b().getRegistryName().toString().equals(name) || recipe.getResult().func_77960_j() != meta && meta != -1) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    public static MortarRecipe getMortarRecipe(String name, int meta) {
        ResourceLocation item = new ResourceLocation(name);
        for (MortarRecipe mortarRecipe : mortarRecipes.values()) {
            ItemStack output = mortarRecipe.getResult();
            if (!Objects.equals(output.func_77973_b().getRegistryName(), item) || output.func_77960_j() != meta) continue;
            return mortarRecipe;
        }
        return null;
    }

    private static void addMortarRecipe(String name, ItemStack output, Ingredient input, float red1, float green1, float blue1, float red2, float green2, float blue2) {
        mortarRecipes.putAll(ModRecipes.getMortarRecipeList(name, output, input, red1, green1, blue1, red2, green2, blue2));
    }

    public static Map<ResourceLocation, MortarRecipe> getMortarRecipeList(String name, ItemStack output, Ingredient input) {
        return ModRecipes.getMortarRecipeList(name, output, input, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static Map<ResourceLocation, MortarRecipe> getMortarRecipeList(String name, ItemStack output, Ingredient input, float red1, float green1, float blue1, float red2, float green2, float blue2) {
        HashMap<ResourceLocation, MortarRecipe> result = new HashMap<ResourceLocation, MortarRecipe>();
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        int count = output.func_190916_E();
        for (int i = 0; i < 5; ++i) {
            ingredients.add(input);
            ItemStack copy = output.func_77946_l();
            copy.func_190920_e((i + 1) * count);
            MortarRecipe recipe = new MortarRecipe(copy, ingredients.toArray(new Ingredient[0]), red1, green1, blue1, red2, green2, blue2);
            recipe.setRegistryName(new ResourceLocation("roots", name + "_" + (i + 1)));
            result.put(recipe.getRegistryName(), recipe);
        }
        return result;
    }

    public static SpellBase getSpellRecipe(String name) {
        return SpellRegistry.getSpell(name);
    }

    public static SpellBase getSpellRecipe(List<ItemStack> items) {
        for (SpellBase spell : SpellRegistry.spellRegistry.values()) {
            if (!spell.matchesIngredients(items)) continue;
            return spell;
        }
        return null;
    }

    public static PyreCraftingRecipe getCraftingRecipe(List<ItemStack> items) {
        items.removeIf(ItemStack::func_190926_b);
        for (PyreCraftingRecipe pyreCraftingRecipe : pyreCraftingRecipes.values()) {
            if (!pyreCraftingRecipe.matches(items)) continue;
            return pyreCraftingRecipe;
        }
        return null;
    }

    public static void addFeyCraftingRecipe(ResourceLocation name, FeyCraftingRecipe recipe) {
        assert (!feyCraftingRecipes.containsKey(name));
        feyCraftingRecipes.put(name, recipe);
    }

    public static void addPyreCraftingRecipe(ResourceLocation name, PyreCraftingRecipe recipe) {
        if (pyreCraftingRecipes.containsKey(name)) {
            Roots.logger.error("Duplicate recipe registered for the name: " + name);
        }
        pyreCraftingRecipes.put(name, recipe);
    }

    public static Map<ResourceLocation, FeyCraftingRecipe> getFeyCraftingRecipes() {
        return feyCraftingRecipes;
    }

    @Nullable
    public static FeyCraftingRecipe getFeyCraftingRecipe(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (FeyCraftingRecipe recipe : feyCraftingRecipes.values()) {
            if (!ItemUtil.equalWithoutSize((ItemStack)recipe.getResult(), (ItemStack)stack)) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static FeyCraftingRecipe getFeyCraftingRecipe(List<ItemStack> items) {
        for (FeyCraftingRecipe recipe : feyCraftingRecipes.values()) {
            if (!recipe.matches(items)) continue;
            return recipe;
        }
        return null;
    }

    public static FeyCraftingRecipe getFeyCraftingRecipe(String name) {
        return ModRecipes.getFeyCraftingRecipe(new ResourceLocation("roots", name));
    }

    @Nullable
    public static FeyCraftingRecipe getFeyCraftingRecipe(ResourceLocation name) {
        return feyCraftingRecipes.get(name);
    }

    public static PyreCraftingRecipe getCraftingRecipe(String recipeName) {
        return ModRecipes.getCraftingRecipe(new ResourceLocation("roots", recipeName));
    }

    public static PyreCraftingRecipe getCraftingRecipe(ResourceLocation recipeName) {
        return pyreCraftingRecipes.get(recipeName);
    }

    @Nullable
    public static PyreCraftingRecipe getCraftingRecipe(ItemStack output) {
        for (PyreCraftingRecipe recipe : pyreCraftingRecipes.values()) {
            if (!ItemUtil.equalWithoutSize((ItemStack)recipe.getResult(), (ItemStack)output)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean removePyreCraftingRecipe(ResourceLocation name) {
        return pyreCraftingRecipes.remove(name) != null;
    }

    public static boolean removePyreCraftingRecipe(ItemStack output) {
        PyreCraftingRecipe recipe = ModRecipes.getCraftingRecipe(output);
        if (recipe == null) {
            return false;
        }
        return ModRecipes.removePyreCraftingRecipe(recipe.getRegistryName());
    }

    public static void removeFeyCraftingRecipe(ResourceLocation name) {
        feyCraftingRecipes.remove(name);
    }

    private static void addPyreCraftingRecipe(String recipeName, PyreCraftingRecipe pyreCraftingRecipe) {
        ResourceLocation rl = new ResourceLocation("roots", recipeName);
        if (ModRecipes.getCraftingRecipe(rl) != null) {
            throw new IllegalStateException("Already have a PyreCraftingRecipe registered for name: " + rl.toString());
        }
        pyreCraftingRecipes.put(rl, pyreCraftingRecipe.setName(recipeName));
    }

    private static void addFeyCraftingRecipe(String recipeName, FeyCraftingRecipe recipe) {
        ResourceLocation recipeId = new ResourceLocation("roots", recipeName);
        if (feyCraftingRecipes.containsKey(recipeId)) {
            throw new IllegalStateException("Already have a FeyCraftingRecipe registered for name: " + recipeId.toString());
        }
        feyCraftingRecipes.put(recipeId, recipe.setName(recipeName));
    }

    public static Map<ResourceLocation, RunicShearRecipe> getRunicShearRecipes() {
        return runicShearRecipes;
    }

    public static Map<ResourceLocation, RunicShearEntityRecipe> getRunicShearEntityRecipes() {
        return runicShearEntityRecipes;
    }

    public static Map<Class<? extends Entity>, RunicShearEntityRecipe> getGeneratedEntityRecipes() {
        if (generatedEntityRecipes == null) {
            ModRecipes.generateEntityRecipes();
        }
        return generatedEntityRecipes;
    }

    public static Map<ResourceLocation, PyreCraftingRecipe> getPyreCraftingRecipes() {
        return pyreCraftingRecipes;
    }

    public static Map<ResourceLocation, AnimalHarvestRecipe> getHarvestRecipes() {
        return harvestRecipes;
    }

    public static Collection<MortarRecipe> getMortarRecipes() {
        return mortarRecipes.values();
    }

    public static void initMortarRecipes() {
        ModRecipes.addMortarRecipe("carapace_blue_dye", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.LIGHT_BLUE.func_176767_b()), Ingredient.func_193367_a((Item)epicsquid.mysticalworld.init.ModItems.carapace), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ModRecipes.addMortarRecipe("carrot_orange_dye", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.ORANGE.func_176767_b()), (Ingredient)new OreIngredient("cropCarrot"), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ModRecipes.addMortarRecipe("wheat_flour", new ItemStack(ModItems.flour), (Ingredient)new OreIngredient("cropWheat"), 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        ModRecipes.addMortarRecipe("potato_flour", new ItemStack(ModItems.flour), (Ingredient)new OreIngredient("cropPotato"), 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        ModRecipes.addMortarRecipe("bone_to_bone_meal", new ItemStack(Items.field_151100_aR, 4, 15), (Ingredient)new OreIngredient("bone"), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        ModRecipes.addMortarRecipe("sugarcane_to_sugar", new ItemStack(Items.field_151102_aT, 2), (Ingredient)new OreIngredient("sugarcane"), 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        ModRecipes.addMortarRecipe("rod_to_blaze_powder", new ItemStack(Items.field_151065_br, 5), Ingredient.func_193367_a((Item)Items.field_151072_bj), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ModRecipes.addMortarRecipe("wool_to_string", new ItemStack(Items.field_151007_F, 4), (Ingredient)new OreIngredient("wool"), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ModRecipes.addMortarRecipe("cocoon_to_silk_thread", new ItemStack(epicsquid.mysticalworld.init.ModItems.silk_thread, 5), Ingredient.func_193367_a((Item)epicsquid.mysticalworld.init.ModItems.silk_cocoon), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        ModRecipes.addMortarRecipe("magma_cream_from_magma_blocks", new ItemStack(Items.field_151064_bs, 2), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_189877_df)), 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        ModRecipes.addMortarRecipe("flint_from_gravel", new ItemStack(Items.field_151145_ak), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150351_n)), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        for (Material metal : Materials.getMaterials()) {
            Item metalDust;
            if (!metal.isEnabled() || (metalDust = metal.getDust()) == null) continue;
            ModRecipes.addMortarRecipe(metal.getOredictNameSuffix().toLowerCase() + "_to_dust", new ItemStack(metalDust), (Ingredient)new OreIngredient("ingot" + metal.getOredictNameSuffix()), 0.32156864f, 0.36078432f, 0.44705883f, 0.627451f, 0.654902f, 0.7176471f);
        }
        if (ConfigManager.gold.enableDusts) {
            ModRecipes.addMortarRecipe("gold_to_dust", new ItemStack(epicsquid.mysticalworld.init.ModItems.gold_dust), (Ingredient)new OreIngredient("ingotGold"), 0.32156864f, 0.36078432f, 0.44705883f, 0.627451f, 0.654902f, 0.7176471f);
        }
        if (ConfigManager.iron.enableDusts) {
            ModRecipes.addMortarRecipe("iron_to_dust", new ItemStack(epicsquid.mysticalworld.init.ModItems.iron_dust), (Ingredient)new OreIngredient("ingotIron"), 0.32156864f, 0.36078432f, 0.44705883f, 0.627451f, 0.654902f, 0.7176471f);
        }
        ModRecipes.addMortarRecipe("flowers_to_petals", new ItemStack(ModItems.petals), (Ingredient)new OreIngredient("allFlowers"), 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        ModRecipes.addMortarRecipe("double_flowers_to_petals", new ItemStack(ModItems.petals, 2), (Ingredient)new OreIngredient("allTallFlowers"), 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        ModRecipes.addMortarRecipe("runestone_to_runic_dust", new ItemStack(ModItems.runic_dust), (Ingredient)new OreIngredient("runestone"), 0.0f, 0.0f, 1.0f, 0.23529412f, 0.0f, 1.0f);
    }

    public static void initRecipes(@Nonnull RegisterModRecipesEvent event) {
        ModRecipes.initDrops();
        ModRecipes.initMortarRecipes();
        ModRecipes.initAnimalHarvestRecipes();
        ModRecipes.initTransmutationRecipes();
        ModRecipes.initPacifistEntities();
        ModRecipes.initVanillaBarkRecipes();
        ModRecipes.initModdedBarkRecipes();
        ModRecipes.initFlowerRecipes();
        ModRecipes.initSummonCreatureEntries();
        ModRecipes.initChrysopoeiaRecipes();
        GameRegistry.addSmelting((Item)ModItems.flour, (ItemStack)new ItemStack(Items.field_151025_P), (float)0.125f);
        GameRegistry.addSmelting((Item)ModItems.pereskia_bulb, (ItemStack)new ItemStack(ModItems.cooked_pereskia), (float)0.125f);
        ModRecipes.initCraftingRecipes();
        RunicShearRecipes.initRecipes();
        event.getRegistry().register(new DyeRecipe().setRegistryName(new ResourceLocation("roots", "pouch_dye_recipe")));
    }

    private static void initCraftingRecipes() {
        ModRecipes.addPyreCraftingRecipe("infernal_bulb", new PyreCraftingRecipe(new ItemStack(ModItems.infernal_bulb, 3), 1).addIngredients(new OreIngredient("wildroot"), new ItemStack(Items.field_151064_bs), new OreIngredient("gunpowder"), new ItemStack(Items.field_151129_at), new OreIngredient("dustGlowstone")));
        ModRecipes.addPyreCraftingRecipe("dewgonia", new PyreCraftingRecipe(new ItemStack(ModItems.dewgonia, 3), 1).addIngredients(new OreIngredient("tallgrass"), new ItemStack(Items.field_151102_aT), new OreIngredient("dyeBlue"), new ItemStack(ModItems.terra_moss), new ItemStack(Item.func_150898_a((Block)Blocks.field_150392_bi))));
        ModRecipes.addPyreCraftingRecipe("cloud_berry", new PyreCraftingRecipe(new ItemStack(ModItems.cloud_berry, 3), 1).addIngredients(new OreIngredient("treeLeaves"), new OreIngredient("tallgrass"), new OreIngredient("wool"), new ItemStack(ModItems.terra_moss), new ItemStack(ModItems.terra_moss)));
        ModRecipes.addPyreCraftingRecipe("stalicripe", new PyreCraftingRecipe(new ItemStack(ModItems.stalicripe, 3), 1).addIngredients(new ItemStack(Items.field_151145_ak), new OreIngredient("stone"), new OreIngredient("ingotIron"), new OreIngredient("wildroot"), new OreIngredient("dustRedstone")));
        ModRecipes.addPyreCraftingRecipe("moonglow_leaf", new PyreCraftingRecipe(new ItemStack(ModItems.moonglow_leaf, 3), 1).addIngredients(new OreIngredient("treeLeaves"), new OreIngredient("blockGlass"), new OreIngredient("gemQuartz"), new ItemStack(ModItems.bark_birch), new ItemStack(ModItems.bark_birch)));
        ModRecipes.addPyreCraftingRecipe("pereskia", new PyreCraftingRecipe(new ItemStack(ModItems.pereskia, 3), 1).addIngredients(new OreIngredient("wildroot"), new ItemStack(Items.field_151060_bw), new OreIngredient("dustRedstone"), new ItemStack(Items.field_185164_cV), new OreIngredient("sugarcane")));
        ModRecipes.addPyreCraftingRecipe("baffle_cap", new PyreCraftingRecipe(new ItemStack(Item.func_150898_a((Block)ModBlocks.baffle_cap_mushroom), 3), 1).addIngredients(new ItemStack(ModItems.terra_moss), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151014_N), new ItemStack((Block)Blocks.field_150337_Q), new ItemStack((Block)Blocks.field_150338_P)));
        ModRecipes.addPyreCraftingRecipe("cooked_seeds", new PyreCraftingRecipe(new ItemStack(epicsquid.mysticalworld.init.ModItems.cooked_seeds, 5), 1).addIngredients(new ItemStack(epicsquid.mysticalworld.init.ModItems.seeds), new ItemStack(epicsquid.mysticalworld.init.ModItems.seeds), new ItemStack(epicsquid.mysticalworld.init.ModItems.seeds), new ItemStack(epicsquid.mysticalworld.init.ModItems.seeds), new ItemStack(epicsquid.mysticalworld.init.ModItems.seeds)).setBurnTime(20));
        ModRecipes.addPyreCraftingRecipe("dead_bush", new PyreCraftingRecipe(new ItemStack((Block)Blocks.field_150330_I, 3)).addIngredients(new OreIngredient("treeSapling"), new OreIngredient("treeSapling"), new OreIngredient("treeSapling"), new OreIngredient("treeSapling"), new OreIngredient("treeSapling")));
        ModRecipes.addPyreCraftingRecipe("cooked_potato", new PyreCraftingRecipe(new ItemStack(Items.field_151168_bH, 5), 1).addIngredients(new OreIngredient("cropPotato"), new OreIngredient("cropPotato"), new OreIngredient("cropPotato"), new OreIngredient("cropPotato"), new OreIngredient("cropPotato")).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("cooked_chicken", new PyreCraftingRecipe(new ItemStack(Items.field_151077_bg, 5), 1).addIngredients(new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151076_bf), new ItemStack(Items.field_151076_bf)).setBurnTime(300));
        Ingredient acceptableFish = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a())});
        ModRecipes.addPyreCraftingRecipe("cooked_fish", new PyreCraftingRecipe(new ItemStack(Items.field_179566_aV, 5), 1).addIngredients(acceptableFish, acceptableFish, acceptableFish, acceptableFish, acceptableFish).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("cooked_salmon", new PyreCraftingRecipe(new ItemStack(Items.field_179566_aV, 5, ItemFishFood.FishType.SALMON.func_150976_a()), 1).addIngredients(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a())).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("steak", new PyreCraftingRecipe(new ItemStack(Items.field_151083_be, 5), 1).addIngredients(new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151082_bd)).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("cooked_mutton", new PyreCraftingRecipe(new ItemStack(Items.field_179557_bn, 5), 1).addIngredients(new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_179561_bm), new ItemStack(Items.field_179561_bm)).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("cooked_porkchop", new PyreCraftingRecipe(new ItemStack(Items.field_151157_am, 5), 1).addIngredients(new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151147_al)).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("cooked_rabbit", new PyreCraftingRecipe(new ItemStack(Items.field_179559_bp, 5), 1).addIngredients(new ItemStack(Items.field_179558_bo), new ItemStack(Items.field_179558_bo), new ItemStack(Items.field_179558_bo), new ItemStack(Items.field_179558_bo), new ItemStack(Items.field_179558_bo)).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("cooked_pereskia", new PyreCraftingRecipe(new ItemStack(ModItems.cooked_pereskia, 5), 1).addIngredients(new ItemStack(ModItems.pereskia_bulb), new ItemStack(ModItems.pereskia_bulb), new ItemStack(ModItems.pereskia_bulb), new ItemStack(ModItems.pereskia_bulb), new ItemStack(ModItems.pereskia_bulb)).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("cooked_aubergine", new PyreCraftingRecipe(new ItemStack(epicsquid.mysticalworld.init.ModItems.cooked_aubergine, 5), 1).addIngredients(Ingredients.AUBERGINE, Ingredients.AUBERGINE, Ingredients.AUBERGINE, Ingredients.AUBERGINE, Ingredients.AUBERGINE).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("cooked_squid", new PyreCraftingRecipe(new ItemStack(epicsquid.mysticalworld.init.ModItems.cooked_squid, 10), 1).addIngredients(new ItemStack(epicsquid.mysticalworld.init.ModItems.raw_squid), new ItemStack(epicsquid.mysticalworld.init.ModItems.raw_squid), new ItemStack(epicsquid.mysticalworld.init.ModItems.raw_squid), new ItemStack(epicsquid.mysticalworld.init.ModItems.raw_squid), new ItemStack(epicsquid.mysticalworld.init.ModItems.raw_squid)).setBurnTime(300));
        ModRecipes.addPyreCraftingRecipe("cooked_venison", new PyreCraftingRecipe(new ItemStack(epicsquid.mysticalworld.init.ModItems.cooked_venison, 5), 1).addIngredients(new ItemStack(epicsquid.mysticalworld.init.ModItems.venison), new ItemStack(epicsquid.mysticalworld.init.ModItems.venison), new ItemStack(epicsquid.mysticalworld.init.ModItems.venison), new ItemStack(epicsquid.mysticalworld.init.ModItems.venison), new ItemStack(epicsquid.mysticalworld.init.ModItems.venison)).setBurnTime(300));
        ModRecipes.addFeyCraftingRecipe("unending_bowl", new FeyCraftingRecipe(new ItemStack(ItemBlock.func_150898_a((Block)ModBlocks.unending_bowl)), 2).addIngredients(new ItemStack(Items.field_151131_as), new ItemStack(ItemBlock.func_150898_a((Block)ModBlocks.mortar)), new ItemStack(ModItems.dewgonia), new ItemStack(ModItems.terra_moss), new ItemStack(ModItems.dewgonia)));
        ModRecipes.addFeyCraftingRecipe("elemental_soil", new FeyCraftingRecipe(new ItemStack(ModBlocks.elemental_soil, 4), 4).addIngredients(new OreIngredient("dirt"), new ItemStack(ModItems.terra_moss), new OreIngredient("wildroot"), new ItemStack(Blocks.field_150351_n), new OreIngredient("dye")));
        ModRecipes.addFeyCraftingRecipe("living_pickaxe", new FeyCraftingRecipe(new ItemStack(ModItems.living_pickaxe), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151039_o), new OreIngredient("wildroot"), new OreIngredient("rootsBark"), new OreIngredient("rootsBark")}));
        ModRecipes.addFeyCraftingRecipe("living_axe", new FeyCraftingRecipe(new ItemStack(ModItems.living_axe), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151053_p), new OreIngredient("wildroot"), new OreIngredient("rootsBark"), new OreIngredient("rootsBark")}));
        ModRecipes.addFeyCraftingRecipe("living_shovel", new FeyCraftingRecipe(new ItemStack(ModItems.living_shovel), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151038_n), new OreIngredient("wildroot"), new OreIngredient("rootsBark"), new OreIngredient("rootsBark")}));
        ModRecipes.addFeyCraftingRecipe("living_hoe", new FeyCraftingRecipe(new ItemStack(ModItems.living_hoe), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151017_I), new OreIngredient("wildroot"), new OreIngredient("rootsBark"), new OreIngredient("rootsBark")}));
        ModRecipes.addFeyCraftingRecipe("living_sword", new FeyCraftingRecipe(new ItemStack(ModItems.living_sword), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151041_m), new OreIngredient("wildroot"), new OreIngredient("rootsBark"), new OreIngredient("rootsBark")}));
        ModRecipes.addFeyCraftingRecipe("living_arrow", new FeyCraftingRecipe(new ItemStack(ModItems.living_arrow, 6), 1).addIngredients(new OreIngredient("treeLeaves"), new OreIngredient("treeLeaves"), new OreIngredient("rootsBark"), new OreIngredient("wildroot"), new ItemStack(Items.field_151145_ak)));
        ModRecipes.addFeyCraftingRecipe("wildwood_quiver", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_quiver), 2).addIngredients(new OreIngredient("chestWood"), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.terra_moss), new ItemStack(ModItems.spirit_herb)));
        ModRecipes.addFeyCraftingRecipe("wildwood_bow", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_bow), 2).addIngredients(new ItemStack((Item)Items.field_151031_f), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.terra_moss), new ItemStack(ModItems.spirit_herb)));
        ModRecipes.addFeyCraftingRecipe("runic_shears", new FeyCraftingRecipe(new ItemStack(ModItems.runic_shears), 1).addIngredients(new ItemStack((Item)Items.field_151097_aZ), new ItemStack(ModItems.pereskia), new ItemStack(ModItems.pereskia), new OreIngredient("runestone"), new OreIngredient("runestone")));
        ModRecipes.addFeyCraftingRecipe("runestone", new FeyCraftingRecipe(new ItemStack(Item.func_150898_a((Block)ModBlocks.runestone), 8), 1).addIngredients(new MultiOreIngredient(new String[]{"gemLapis", "dustRedstone", "dustGlowstone", "dustPrismarine", "gemPrismarine", "gemEmerald", "gemDiamond", "gunpowder", "dustBlaze"}), new OreIngredient("stone"), new OreIngredient("stone"), new OreIngredient("stone"), new OreIngredient("stone")));
        ModRecipes.addFeyCraftingRecipe("runed_obsidian", new FeyCraftingRecipe(new ItemStack(Item.func_150898_a((Block)ModBlocks.runed_obsidian), 4), 1).addIngredients(new ItemStack(ModItems.runic_dust), new OreIngredient("obsidian"), new OreIngredient("runestone"), new OreIngredient("obsidian"), new OreIngredient("runestone")));
        ModRecipes.addFeyCraftingRecipe("runic_crafter", new FeyCraftingRecipe(new ItemStack(Item.func_150898_a((Block)ModBlocks.runic_crafter), 1), 1).addIngredients(new ItemStack(ModBlocks.fey_crafter), new ItemStack(ModBlocks.chiseled_runestone), new ItemStack(ModBlocks.chiseled_runestone), new ItemStack(ModItems.runic_dust), new ItemStack(ModItems.mystic_feather)));
        ModRecipes.addFeyCraftingRecipe("wildwood_helmet", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_helmet), 1).addIngredients(new ItemStack((Item)Items.field_151028_Y), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new OreIngredient("plankWood"), new OreIngredient("gemDiamond")));
        ModRecipes.addFeyCraftingRecipe("wildwood_chestplate", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_chestplate), 1).addIngredients(new ItemStack((Item)Items.field_151030_Z), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new OreIngredient("plankWood"), new OreIngredient("gemDiamond")));
        ModRecipes.addFeyCraftingRecipe("wildwood_leggings", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_leggings), 1).addIngredients(new ItemStack((Item)Items.field_151165_aa), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new OreIngredient("plankWood"), new OreIngredient("gemDiamond")));
        ModRecipes.addFeyCraftingRecipe("wildwood_boots", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_boots), 1).addIngredients(new ItemStack((Item)Items.field_151167_ab), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new OreIngredient("plankWood"), new OreIngredient("gemDiamond")));
        ModRecipes.addFeyCraftingRecipe("component_pouch", new FeyCraftingRecipe(new ItemStack(ModItems.component_pouch), 1).addIngredients(new OreIngredient("chestWood"), new OreIngredient("wool"), new OreIngredient("wool"), new OreIngredient("wildroot"), new OreIngredient("rootsBark")));
        ModRecipes.addFeyCraftingRecipe("apothecary_pouch", new ApothecaryPouchRecipe(new ItemStack(ModItems.apothecary_pouch), 1).addIngredients(new ItemStack(Item.func_150898_a((Block)ModBlocks.baffle_cap_mushroom)), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.spirit_herb), new ItemStack(ModItems.component_pouch)));
        ModRecipes.addFeyCraftingRecipe("fey_pouch", new FeyPouchRecipe(new ItemStack(ModItems.fey_pouch), 1).addIngredients(new ItemStack(ModItems.herb_pouch), new ItemStack(ModItems.fey_leather), new ItemStack(ModItems.fey_leather), new ItemStack(ModItems.pereskia), new ItemStack(ModItems.mystic_feather)));
        ModRecipes.addFeyCraftingRecipe("salmon_of_knowledge", new SalmonRecipe(new ItemStack(ModItems.salmon), 1).addIngredients(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), new ItemStack(Items.field_151062_by), new OreIngredient("rootsBark"), new ItemStack(Items.field_151122_aG), new ItemStack(ModItems.terra_moss)));
        ModRecipes.addFeyCraftingRecipe("sylvan_helmet", new FeyCraftingRecipe(new ItemStack(ModItems.sylvan_helmet), 1).addIngredients(new ItemStack(ModItems.fey_leather), new OreIngredient("vine"), new ItemStack(ModItems.bark_birch), new OreFallbackIngredient("gemAmethyst", "gemDiamond"), new ItemStack((Item)Items.field_151028_Y)));
        ModRecipes.addFeyCraftingRecipe("sylvan_chestplate", new FeyCraftingRecipe(new ItemStack(ModItems.sylvan_chestplate), 1).addIngredients(new ItemStack(ModItems.fey_leather), new OreIngredient("vine"), new ItemStack(ModItems.bark_birch), new OreFallbackIngredient("gemAmethyst", "gemDiamond"), new ItemStack((Item)Items.field_151030_Z)));
        ModRecipes.addFeyCraftingRecipe("sylvan_leggings", new FeyCraftingRecipe(new ItemStack(ModItems.sylvan_leggings), 1).addIngredients(new ItemStack(ModItems.fey_leather), new OreIngredient("vine"), new ItemStack(ModItems.bark_birch), new OreFallbackIngredient("gemAmethyst", "gemDiamond"), new ItemStack((Item)Items.field_151165_aa)));
        ModRecipes.addFeyCraftingRecipe("sylvan_boots", new FeyCraftingRecipe(new ItemStack(ModItems.sylvan_boots), 1).addIngredients(new ItemStack(ModItems.fey_leather), new OreIngredient("vine"), new ItemStack(ModItems.bark_birch), new OreFallbackIngredient("gemAmethyst", "gemDiamond"), new ItemStack((Item)Items.field_151167_ab)));
        ModRecipes.addFeyCraftingRecipe("terrastone_pickaxe", new FeyCraftingRecipe(new ItemStack(ModItems.terrastone_pickaxe), 1).addIngredients(new OreIngredient("runestone"), new ItemStack(Items.field_151050_s), new ItemStack(ModItems.terra_moss), new OreIngredient("gemDiamond"), new OreIngredient("mossyCobblestone")));
        ModRecipes.addFeyCraftingRecipe("terrastone_axe", new FeyCraftingRecipe(new ItemStack(ModItems.terrastone_axe), 1).addIngredients(new OreIngredient("runestone"), new ItemStack(Items.field_151049_t), new ItemStack(ModItems.terra_moss), new OreIngredient("gemDiamond"), new OreIngredient("mossyCobblestone")));
        ModRecipes.addFeyCraftingRecipe("terrastone_shovel", new FeyCraftingRecipe(new ItemStack(ModItems.terrastone_shovel), 1).addIngredients(new OreIngredient("runestone"), new ItemStack(Items.field_151051_r), new ItemStack(ModItems.terra_moss), new OreIngredient("gemDiamond"), new OreIngredient("mossyCobblestone")));
        ModRecipes.addFeyCraftingRecipe("terrastone_hoe", new FeyCraftingRecipe(new ItemStack(ModItems.terrastone_hoe), 1).addIngredients(new OreIngredient("runestone"), new ItemStack(Items.field_151018_J), new ItemStack(ModItems.terra_moss), new OreIngredient("gemDiamond"), new OreIngredient("mossyCobblestone")));
        ModRecipes.addFeyCraftingRecipe("terrastone_sword", new FeyCraftingRecipe(new ItemStack(ModItems.terrastone_sword), 1).addIngredients(new OreIngredient("runestone"), new ItemStack(Items.field_151052_q), new ItemStack(ModItems.terra_moss), new OreIngredient("gemDiamond"), new OreIngredient("mossyCobblestone")));
        ModRecipes.addFeyCraftingRecipe("runed_pickaxe", new FeyCraftingRecipe(new ItemStack(ModItems.runed_pickaxe), 1).addIngredients(new OreIngredient("runedObsidian"), new OreIngredient("runedObsidian"), new AccessibleCompoundIngredient(new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151046_w), Ingredient.func_193367_a((Item)Materials.amethyst.getPickaxe())}), new OreIngredient("feyLeather"), new ItemStack(ModItems.stalicripe)));
        ModRecipes.addFeyCraftingRecipe("runed_axe", new FeyCraftingRecipe(new ItemStack(ModItems.runed_axe), 1).addIngredients(new OreIngredient("runedObsidian"), new OreIngredient("runedObsidian"), new AccessibleCompoundIngredient(new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151056_x), Ingredient.func_193367_a((Item)Materials.amethyst.getAxe())}), new OreIngredient("feyLeather"), new ItemStack(ModItems.cloud_berry)));
        ModRecipes.addFeyCraftingRecipe("runed_shovel", new FeyCraftingRecipe(new ItemStack(ModItems.runed_shovel), 1).addIngredients(new OreIngredient("runedObsidian"), new OreIngredient("runedObsidian"), new AccessibleCompoundIngredient(new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151047_v), Ingredient.func_193367_a((Item)Materials.amethyst.getShovel())}), new OreIngredient("feyLeather"), new ItemStack(ModItems.dewgonia)));
        ModRecipes.addFeyCraftingRecipe("runed_hoe", new FeyCraftingRecipe(new ItemStack(ModItems.runed_hoe), 1).addIngredients(new OreIngredient("runedObsidian"), new OreIngredient("runedObsidian"), new AccessibleCompoundIngredient(new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151012_L), Ingredient.func_193367_a((Item)Materials.amethyst.getHoe())}), new OreIngredient("feyLeather"), new ItemStack(ModItems.wildewheet)));
        ModRecipes.addFeyCraftingRecipe("runed_sword", new FeyCraftingRecipe(new ItemStack(ModItems.runed_sword), 1).addIngredients(new OreIngredient("runedObsidian"), new OreIngredient("runedObsidian"), new AccessibleCompoundIngredient(new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151048_u), Ingredient.func_193367_a((Item)Materials.amethyst.getSword())}), new OreIngredient("feyLeather"), new ItemStack(ModItems.infernal_bulb)));
        ModRecipes.addFeyCraftingRecipe("runed_dagger", new FeyCraftingRecipe(new ItemStack(ModItems.runed_dagger), 1).addIngredients(new OreIngredient("runedObsidian"), new OreIngredient("runedObsidian"), new AccessibleCompoundIngredient(new Ingredient[]{Ingredient.func_193367_a((Item)ModItems.diamond_knife), Ingredient.func_193367_a((Item)epicsquid.mysticalworld.init.ModItems.amethyst_knife)}), new OreIngredient("feyLeather"), new ItemStack(ModItems.moonglow_leaf)));
        ModRecipes.addFeyCraftingRecipe("mycelium", new FeyCraftingRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150391_bh), 5), 1).addIngredients(new OreIngredient("mushroom"), new OreIngredient("dirt"), new ItemStack(ModItems.terra_spores), new OreIngredient("dirt"), new ItemStack(ModItems.stalicripe)));
        ModRecipes.addFeyCraftingRecipe("clay", new FeyCraftingRecipe(new ItemStack(Items.field_151119_aD, 10), 1).addIngredients(new OreIngredient("dirt"), new ItemStack(ModItems.terra_moss), new OreIngredient("sand"), new ItemStack(ModItems.stalicripe), new ItemStack(Items.field_151131_as)));
        ModRecipes.addFeyCraftingRecipe("podzol", new FeyCraftingRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150346_d), 5, BlockDirt.DirtType.PODZOL.func_176925_a()), 1).addIngredients(new ItemStack(Item.func_150898_a((Block)Blocks.field_150346_d), 1, BlockDirt.DirtType.COARSE_DIRT.func_176925_a()), new OreIngredient("rootsBark"), new OreIngredient("treeLeaves"), new ItemStack(ModItems.stalicripe), new ItemStack(Item.func_150898_a((Block)Blocks.field_150346_d), 1, BlockDirt.DirtType.COARSE_DIRT.func_176925_a())));
        ModRecipes.addFeyCraftingRecipe("sand", new FeyCraftingRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), 5, BlockSand.EnumType.SAND.func_176688_a()), 1).addIngredients(new OreIngredient("gravel"), new OreIngredient("gravel"), new OreIngredient("gravel"), new OreIngredient("gravel"), new ItemStack(ModItems.stalicripe)));
        ModRecipes.addFeyCraftingRecipe("gravel", new FeyCraftingRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150351_n), 5), 1).addIngredients(new OreIngredient("cobblestone"), new OreIngredient("cobblestone"), new OreIngredient("cobblestone"), new OreIngredient("cobblestone"), new ItemStack(ModItems.stalicripe)));
        ModRecipes.addFeyCraftingRecipe("red_sand", new FeyCraftingRecipe(new ItemStack(Item.func_150898_a((Block)Blocks.field_150354_m), 2, BlockSand.EnumType.RED_SAND.func_176688_a()), 1).addIngredients(new OreIngredient("dustRedstone"), new OreIngredient("sand"), new OreIngredient("dustRedstone"), new OreIngredient("sand"), new OreIngredient("dyeRed")));
        ModRecipes.addFeyCraftingRecipe("gunpowder", new FeyCraftingRecipe(new ItemStack(Items.field_151016_H, 5), 1).addIngredients(new OreIngredient("netherrack"), new ItemStack(Items.field_151044_h, 1, 1), new OreIngredient("netherrack"), new ItemStack(Items.field_151064_bs, 1), new ItemStack(ModItems.infernal_bulb)));
    }

    public static void afterHerbRegisterInit() {
    }

    private static void initDrops() {
    }
}

