/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.FlowerGrowth")
@ZenDocAppend(value={"docs/include/flower_growth.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.FlowerGrowth")
public class FlowerTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="The name of the recipe you wish to remove")}, description={"Removes a flower growth recipe by name."})
    @ZenMethod
    public static void removeRecipe(String name) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(name));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="name", info="The name of the recipe that you're adding"), @ZenDocArg(arg="state", info="The state of the block of the flower")}, description={"Adds a recipe to create the specific block state during the flower growth ritual."})
    @ZenMethod
    public static void addRecipeBlockState(String name, crafttweaker.api.block.IBlockState state) {
        CraftTweaker.LATE_ACTIONS.add(new FlowerBlockState(name, CraftTweakerMC.getBlockState((crafttweaker.api.block.IBlockState)state)));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="name", info="The name of the recipe that you're adding"), @ZenDocArg(arg="block", info="The block of the flower to be placed"), @ZenDocArg(arg="meta", info="The meta of the state of the flower block")}, description={"Adds a recipe by creating a blockstate from a block along with the meta value from an itemblock to be grown during the flower growth ritual."})
    @ZenMethod
    public static void addRecipeBlock(String name, IBlock block, int meta) {
        CraftTweaker.LATE_ACTIONS.add(new FlowerBlockMeta(name, CraftTweakerMC.getBlock((IBlock)block), meta, null));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="name", info="The name of the recipe that you're adding"), @ZenDocArg(arg="stack", info="The itemstack describing an itemblock to be placed")}, description={"Adds a recipe by creating a blockstate from an itemstack containing an itemblock and metadata to be grown during the Flower Growth ritual."})
    @ZenMethod
    public static void addRecipeItem(String name, IItemStack stack) {
        ItemStack converted = CraftTweakerMC.getItemStack((IItemStack)stack);
        if (!(converted.func_77973_b() instanceof ItemBlock)) {
            CraftTweakerAPI.logError((String)("Cannot set " + stack.toString() + " as a Flower Growth ritual item as it is not an ItemBlock."));
            return;
        }
        Block block = ((ItemBlock)converted.func_77973_b()).func_179223_d();
        CraftTweaker.LATE_ACTIONS.add(new FlowerBlockMeta(name, block, converted.func_77960_j(), null));
    }

    @ZenDocMethod(order=4, args={@ZenDocArg(arg="name", info="The name of the recipe that you're adding"), @ZenDocArg(arg="stack", info="The itemstack describing an itemblock to be placed"), @ZenDocArg(arg="allowedSoils", info="A list of blocks that this flower can be placed on")}, description={"Adds a recipe by creating a blockstate from an itemstack containing an itemblock and metadata to be grown during the Flower Growth ritual. The flower will only be grown on a soil mentioned. Accepts oredict entries."})
    @ZenMethod
    public static void addRecipeItemOnSoils(String name, IItemStack stack, List<IIngredient> allowedSoils) {
        ItemStack converted = CraftTweakerMC.getItemStack((IItemStack)stack);
        if (!(converted.func_77973_b() instanceof ItemBlock)) {
            CraftTweakerAPI.logError((String)("Cannot set " + stack.toString() + " as a Flower Growth ritual item as it is not an ItemBlock."));
            return;
        }
        ArrayList<Ingredient> allowedSoilsMC = new ArrayList<Ingredient>(allowedSoils.size());
        for (IIngredient soil : allowedSoils) {
            allowedSoilsMC.add(CraftTweakerMC.getIngredient((IIngredient)soil));
        }
        Block block = ((ItemBlock)converted.func_77973_b()).func_179223_d();
        CraftTweaker.LATE_ACTIONS.add(new FlowerBlockMeta(name, block, converted.func_77960_j(), allowedSoilsMC));
    }

    private static class FlowerBlockMeta
    extends Action {
        private final Block block;
        private final int meta;
        private final String name;
        private final List<Ingredient> allowedSoils;

        protected FlowerBlockMeta(String name, Block block, int meta, List<Ingredient> allowedSoils) {
            super("add_block_meta_flower");
            this.name = name;
            this.block = block;
            this.meta = meta;
            this.allowedSoils = allowedSoils == null ? Collections.emptyList() : allowedSoils;
        }

        public void apply() {
            ModRecipes.addFlowerRecipe(this.name, this.block, this.meta, this.allowedSoils);
        }

        public String describe() {
            return String.format("Recipe to produce %s:%s with FlowerGrowth", this.block, this.meta);
        }
    }

    private static class FlowerBlockState
    extends Action {
        private final IBlockState state;
        private final String name;

        protected FlowerBlockState(String name, IBlockState state) {
            super("add_flower_block_state");
            this.name = name;
            this.state = state;
        }

        public void apply() {
            ModRecipes.addFlowerRecipe(this.name, this.state);
        }

        public String describe() {
            return String.format("Recipe to add %s to FlowerGrowth", this.state);
        }
    }

    private static class Remove
    extends Action {
        private final ResourceLocation name;

        public Remove(String name) {
            super("remove_flower");
            this.name = name.contains(":") ? new ResourceLocation(name) : new ResourceLocation("roots", name);
        }

        public void apply() {
            ModRecipes.removeFlowerRecipe(this.name);
        }

        public String describe() {
            return String.format("Recipe to remove %s from FlowerGrowth", this.name);
        }
    }
}

