/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.integration.crafttweaker.recipes.CTMortarRecipe;
import epicsquid.roots.integration.crafttweaker.recipes.CTSpellRecipe;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.Mortar")
@ZenDocAppend(value={"docs/include/mortar.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.Mortar")
public class MortarTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the name of this recipe, should match a recipe being replaced"), @ZenDocArg(arg="output", info="the item output of this recipe"), @ZenDocArg(arg="inputs", info="an array of ingredients that is either 5 long or 1 long")}, description={"Creates a recipe to create output from an array of ingredients (allows transformations). If the array is 5 long, a single recipe will be produced. If the array consists of only one ingredient, 5 separate recipes will be produced, with the output adjusted every time to compensate."})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient[] inputs) {
        if (inputs.length == 1) {
            CraftTweaker.LATE_ACTIONS.add(new AddMultiple(name, CraftTweakerMC.getItemStack((IItemStack)output), inputs[0]));
        } else if (inputs.length == 5) {
            CraftTweaker.LATE_ACTIONS.add(new Add(name, CraftTweakerMC.getItemStack((IItemStack)output), Arrays.asList(inputs)));
        } else {
            CraftTweakerAPI.getLogger().logError("Mortar recipe must have 5 items total, or 1 single item.");
        }
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="spellName", info="the name of the spell as in the spell registry"), @ZenDocArg(arg="inputs", info="an array of 5 items that are the new ingredients for the recipe")}, description={"Allows the modification of the recipe for a Spell using the specified array of 5 ingredients (allows for transformations)."})
    @ZenMethod
    public static void changeSpell(String spellName, IIngredient[] inputs) {
        if (inputs.length != 5) {
            CraftTweakerAPI.getLogger().logError(String.format("Invalid ingredients length to change recipe for spell %s: need 5 ingredients, got %d.", spellName, inputs.length));
        } else {
            CraftTweaker.LATE_ACTIONS.add(new ChangeSpell(spellName, Arrays.asList(inputs)));
        }
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="output", info="the item stack produced by the recipe")}, description={"Removes a Mortar Recipe based on output. Compares output to existing recipes without regard for size, meaning that matching recipes with 1-5 inputs and 1-5x outputs will all be removed."})
    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    private static class ChangeSpell
    extends Action {
        private String spell;
        private List<IIngredient> ingredients;

        private ChangeSpell(String spell, List<IIngredient> ingredients) {
            super("ChangeSpellRecipe");
            this.spell = spell;
            this.ingredients = ingredients;
        }

        public void apply() {
            SpellBase spell = SpellRegistry.getSpell(this.spell);
            if (spell == null) {
                CraftTweakerAPI.logError((String)("Invalid spell name: " + this.spell));
            } else {
                CTSpellRecipe recipe = new CTSpellRecipe(spell, this.ingredients);
                spell.setRecipe(recipe);
            }
        }

        public String describe() {
            return String.format("ChangeSpellRecipe to change spell %s", this.spell);
        }
    }

    private static class AddMultiple
    extends Action {
        private ItemStack output;
        private IIngredient input;
        private String name;

        private AddMultiple(String name, ItemStack output, IIngredient input) {
            super("MultiMortarRecipe");
            this.output = output;
            this.input = input;
            this.name = name;
        }

        public void apply() {
            ItemStack output2 = this.output.func_77946_l();
            output2.func_190920_e(this.output.func_190916_E() * 2);
            ItemStack output3 = this.output.func_77946_l();
            output3.func_190920_e(this.output.func_190916_E() * 3);
            ItemStack output4 = this.output.func_77946_l();
            output4.func_190920_e(this.output.func_190916_E() * 4);
            ItemStack output5 = this.output.func_77946_l();
            output5.func_190920_e(this.output.func_190916_E() * 5);
            List<CTMortarRecipe> recipes = Arrays.asList(new CTMortarRecipe(this.name + "_1", this.output.func_77946_l(), Collections.singletonList(this.input)), new CTMortarRecipe(this.name + "_2", output2, Arrays.asList(this.input, this.input)), new CTMortarRecipe(this.name + "_3", output3, Arrays.asList(this.input, this.input, this.input)), new CTMortarRecipe(this.name + "_4", output4, Arrays.asList(this.input, this.input, this.input, this.input)), new CTMortarRecipe(this.name + "_5", output5, Arrays.asList(this.input, this.input, this.input, this.input, this.input)));
            recipes.forEach(ModRecipes::addMortarRecipe);
        }

        public String describe() {
            return String.format("MultiMortarRecipe for variable input of %s into variable output of %s.", this.input.toCommandString(), this.output.func_82833_r());
        }
    }

    private static class Add
    extends Action {
        private ItemStack output;
        private List<IIngredient> inputs;
        private String name;

        private Add(String name, ItemStack output, List<IIngredient> inputs) {
            super("MortarRecipe");
            this.output = output;
            this.inputs = inputs;
            this.name = name;
        }

        public void apply() {
            CTMortarRecipe recipe = new CTMortarRecipe(this.name, this.output, this.inputs);
            ModRecipes.addMortarRecipe(recipe);
        }

        public String describe() {
            return "Adding MortarRecipe to make " + this.output;
        }
    }

    private static class Remove
    extends Action {
        private ItemStack output;

        private Remove(ItemStack output) {
            super("MortarRecipe");
            this.output = output;
        }

        public String describe() {
            return "Removing Mortar Recipe for item output: " + this.output;
        }

        public void apply() {
            ModRecipes.removeMortarRecipes(this.output);
        }
    }
}

