/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.crafttweaker.tweaks;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.crafttweaker.Action;
import epicsquid.roots.integration.crafttweaker.recipes.CTPyreCraftingRecipe;
import epicsquid.roots.recipe.PyreCraftingRecipe;
import epicsquid.roots.util.zen.ZenDocAppend;
import epicsquid.roots.util.zen.ZenDocArg;
import epicsquid.roots.util.zen.ZenDocClass;
import epicsquid.roots.util.zen.ZenDocMethod;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.roots.Pyre")
@ZenDocAppend(value={"docs/include/pyre.example.md"})
@ZenRegister
@ZenClass(value="mods.roots.Pyre")
public class PyreCraftingTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the name of the recipe being added; if replacing an existing game recipe, ensure the correct name is used"), @ZenDocArg(arg="output", info="the output of this recipe"), @ZenDocArg(arg="inputs", info="a list of five ingredients (no more, no less)")}, description={"Adds a Pyre crafting recipe that produces output after the standard amount of time, with the specified input ingredients (with potential transformers)."})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient[] inputs) {
        PyreCraftingTweaker.addRecipe(name, output, inputs, 0);
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="name", info="the name of the recipe being added; if replacing an existing game recipe, ensure the correct name is used"), @ZenDocArg(arg="output", info="the output of this recipe"), @ZenDocArg(arg="inputs", info="a list of five ingredients"), @ZenDocArg(arg="xp", info="the amount of xp in levels that is granted after crafting")}, description={"Adds a Pyre crafting recipe that produces output after the standard amount of time, with the specified input ingredients (with potential transformers). Allows for the specification of an amount of experience to be generated once the craft is finished."})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient[] inputs, int xp) {
        if (inputs.length != 5) {
            CraftTweakerAPI.logError((String)("Pyre Crafting Ritual must have 5 items: " + name));
            return;
        }
        CraftTweaker.LATE_ACTIONS.add(new Add(name, CraftTweakerMC.getItemStack((IItemStack)output), Arrays.asList(inputs), xp));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="output", info="the output of the recipe to remove")}, description={"Removes a Pyre crafting recipe based on its output."})
    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    private static class Remove
    extends Action {
        private ItemStack output;

        public String describe() {
            return "Removing Pyre Altar Crafting recipe " + this.output;
        }

        private Remove(ItemStack output) {
            super("Pyre Crafting Ritual");
            this.output = output;
        }

        public void apply() {
            if (!ModRecipes.removePyreCraftingRecipe(this.output)) {
                CraftTweakerAPI.logError((String)("Couldn't properly remove Pyre Crafting Recipe: " + this.output.toString()));
            }
        }
    }

    private static class Add
    extends Action {
        private String name;
        private ItemStack output;
        private List<IIngredient> inputs;
        private int xp;

        private Add(String name, ItemStack output, List<IIngredient> inputs, int xp) {
            super("Pyre Crafting Ritual Add");
            this.name = name;
            this.output = output;
            this.inputs = inputs;
            this.xp = xp;
        }

        public String describe() {
            return "Adding Pyre Crafting Ritual for " + this.output;
        }

        public void apply() {
            CTPyreCraftingRecipe recipe = new CTPyreCraftingRecipe(this.output, this.inputs, this.xp);
            recipe.setName(this.name);
            ModRecipes.addPyreCraftingRecipe(new ResourceLocation("roots", this.name), (PyreCraftingRecipe)recipe);
        }
    }
}

