/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualTransmutation;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionStandingStones;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualTransmutation
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(2400);
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 4).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 4).setDescription("Radius on the Y Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 4).setDescription("Radius on the Z Axis of the cube in which the ritual takes place");
    public static Property.PropertyInterval PROP_INTERVAL = new Property.PropertyInterval(100).setDescription("interval in ticks between each block transmutation");
    public int radius_x;
    public int radius_y;
    public int radius_z;
    public int interval;

    public RitualTransmutation(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_INTERVAL, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z);
        this.setEntityClass(EntityRitualTransmutation.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(Blocks.field_150460_al), new ItemStack(Blocks.field_150351_n), new ItemStack(ModItems.cloud_berry), new OreIngredient("rootsBark"), new ItemStack(ModBlocks.chiseled_runestone));
        this.addCondition(new ConditionStandingStones(3, 1));
        this.setIcon(ModItems.ritual_transmutation);
        this.setColor(TextFormatting.DARK_PURPLE);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = radius[0];
        this.radius_y = radius[1];
        this.radius_z = radius[2];
        this.interval = this.properties.get(PROP_INTERVAL);
    }
}

