/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual.conditions;

import epicsquid.roots.ritual.conditions.ICondition;
import epicsquid.roots.tileentity.TileEntityPyre;
import epicsquid.roots.util.RitualUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ConditionRunedPillars
implements ICondition {
    private final int height;
    private final int amount;
    private final RitualUtil.RunedWoodType type;

    public ConditionRunedPillars(RitualUtil.RunedWoodType type, int height, int amount) {
        this.height = height;
        this.amount = amount;
        this.type = type;
    }

    public int getHeight() {
        return this.height;
    }

    public int getAmount() {
        return this.amount;
    }

    public RitualUtil.RunedWoodType getType() {
        return this.type;
    }

    @Override
    public boolean checkCondition(TileEntityPyre tile, EntityPlayer player) {
        return RitualUtil.getNearbyPillar(this.type, tile.func_145831_w(), tile.func_174877_v(), this.height) >= this.amount;
    }

    @Override
    @Nullable
    public ITextComponent failMessage() {
        return new TextComponentTranslation("roots.ritual.condition.pillar", new Object[]{new TextComponentTranslation("roots.ritual.condition.pillar.types", new Object[]{this.getAmount(), this.getHeight(), this.getType().toString()})});
    }
}

