/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.mechanics.Growth;
import epicsquid.roots.mechanics.Harvest;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.network.fx.MessageHarvestCompleteFX;
import epicsquid.roots.network.fx.MessageRampantLifeInfusionFX;
import epicsquid.roots.properties.Property;
import epicsquid.roots.recipe.FoodPoisoning;
import epicsquid.roots.recipe.MortarRecipe;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellNaturesScythe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellHarvest
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(25);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("wildewheet", 0.55));
    public static Property.PropertyCost PROP_COST_2 = new Property.PropertyCost(new SpellBase.SpellCost("terra_moss", 0.1));
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 6).setDescription("radius on the X axis of the area the spell has effect on");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 5).setDescription("radius on the Y axis of the area the spell has effect on");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 6).setDescription("radius on the Z axis of the area the spell has effect on");
    public static Property<Integer> PROP_RADIUS_BOOST = new Property<Integer>("radius_boost", 4).setDescription("how much the radius should be increased by");
    public static Property<Integer> PROP_RADIUS_UNBOOST = new Property<Integer>("radius_unboost", 3).setDescription("how much the radius should be decreased by");
    public static Property<Float> PROP_UNDEAD_CHANCE = new Property<Float>("undead_chance", Float.valueOf(0.3f)).setDescription("the chance per cast of getting an undead cache");
    public static Property<Integer> PROP_UNDEAD_COUNT = new Property<Integer>("undead_count", 1).setDescription("the number of guaranteed undead caches when granted");
    public static Property<Integer> PROP_UNDEAD_ADDITIONAL = new Property<Integer>("undead_additional", 3).setDescription("the number of (0-(x-1)) additional caches");
    public static Property<Float> PROP_UNDEAD_RARITY = new Property<Float>("undead_rare", Float.valueOf(0.3f)).setDescription("the frequency at which caches will be upgraded from common to rare");
    public static Property<Integer> PROP_GROWTH_COUNT = new Property<Integer>("growth_count", 3).setDescription("how many additional ticks of growth will be applied");
    public static Property<Integer> PROP_GROWTH_ADDITIONAL = new Property<Integer>("growth_additional", 6).setDescription("how many additional randomised ticks of growth will be applied");
    public static Modifier RADIUS1 = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "extended_harvest"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.275)));
    public static Modifier MAGNETISM = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "magnetic_harvest"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.125)));
    public static Modifier UNDEAD = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "gifts_of_undeath"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.75)));
    public static Modifier SMALL_RADIUS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "targeted_harvest"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.275)));
    public static Modifier POISON = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "poisoned_harvest"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.125)));
    public static Modifier GROWTH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "regrowth"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.345)));
    public static Modifier COOKING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "fiery_harvest"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.125)));
    public static Modifier CRUSHING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "yield"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.125)));
    public static Modifier SILK_TOUCH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "harvest_silk_touch"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.475)));
    public static ResourceLocation spellName;
    public static SpellHarvest instance;
    private int radius_x;
    private int radius_y;
    private int radius_z;
    private int radius_boost;
    private int radius_unboost;
    private int undead_count;
    private int undead_additional;
    private int growth_count;
    private int growth_additional;
    private float undead_chance;
    private float undead_rarity;
    private static final List<Block> skipBlocks;

    public SpellHarvest(ResourceLocation name) {
        super(name, TextFormatting.GREEN, 0.22352941f, 0.99215686f, 0.10980392f, 0.77254903f, 0.9137255f, 0.10980392f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_RADIUS_BOOST, PROP_RADIUS_UNBOOST, PROP_UNDEAD_ADDITIONAL, PROP_UNDEAD_CHANCE, PROP_UNDEAD_COUNT, PROP_UNDEAD_RARITY, PROP_GROWTH_COUNT, PROP_GROWTH_ADDITIONAL);
        this.acceptModifiers(RADIUS1, MAGNETISM, UNDEAD, SMALL_RADIUS, POISON, GROWTH, COOKING, CRUSHING, SILK_TOUCH);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(Items.field_151018_J), new ItemStack(epicsquid.mysticalworld.init.ModItems.aubergine_seed), new ItemStack(ModItems.wildewheet), new ItemStack(ModItems.wildewheet_seed), new ItemStack(Items.field_151014_N));
        this.setCastSound(ModSounds.Spells.HARVEST);
    }

    public ItemStack tryCook(ItemStack input) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(input);
        if (result.func_190926_b()) {
            return input;
        }
        return result.func_77946_l();
    }

    public ItemStack tryCrush(ItemStack input) {
        MortarRecipe recipe = ModRecipes.getMortarRecipe(Collections.singletonList(input));
        if (recipe == null) {
            return input;
        }
        return recipe.getResult().func_77946_l();
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        IBlockState state;
        Harvest.prepare();
        ArrayList<Function<ItemStack, ItemStack>> converters = new ArrayList<Function<ItemStack, ItemStack>>();
        if (info.has(CRUSHING)) {
            converters.add(this::tryCrush);
        }
        if (info.has(POISON)) {
            converters.add(FoodPoisoning::replacement);
        }
        if (info.has(COOKING)) {
            converters.add(this::tryCook);
        }
        int x = this.radius_x;
        int y = this.radius_y;
        int z = this.radius_z;
        if (info.has(RADIUS1)) {
            x += this.radius_boost;
            y += this.radius_boost;
            z += this.radius_boost;
        } else if (info.has(SMALL_RADIUS)) {
            x -= this.radius_unboost;
            y -= this.radius_unboost;
            z -= this.radius_unboost;
        }
        Predicate<IBlockState> pumpkinOrMelonTest = new Harvest.Matcher(Blocks.field_150423_aK).or(new Harvest.Matcher(Blocks.field_150440_ba));
        Predicate<IBlockState> reedsOrCactusTest = new Harvest.Matcher((Block)Blocks.field_150436_aH).or(new Harvest.Matcher((Block)Blocks.field_150434_aF));
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        ArrayList pumpkinsAndMelons = new ArrayList();
        ArrayList reedsAndCactus = new ArrayList();
        List crops = Util.getBlocksWithinRadius((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (float)x, (float)y, (float)z, pos -> {
            if (player.field_70170_p.func_175623_d(pos)) {
                return false;
            }
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (skipBlocks.contains(block)) {
                return false;
            }
            if (pumpkinOrMelonTest.test(state)) {
                pumpkinsAndMelons.add(pos);
                return false;
            }
            if (reedsOrCactusTest.test(state)) {
                IBlockState down = player.field_70170_p.func_180495_p(pos.func_177977_b());
                if (reedsOrCactusTest.test(down)) {
                    reedsAndCactus.add(pos);
                }
                return false;
            }
            IProperty<?> prop = Harvest.resolveStates(state);
            if (prop != null) {
                return Harvest.isGrown(state);
            }
            return false;
        });
        int count = 0;
        reedsAndCactus.sort((o1, o2) -> Integer.compare(o2.func_177956_o(), o1.func_177956_o()));
        pumpkinsAndMelons.addAll(reedsAndCactus);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos2 : crops) {
            state = player.field_70170_p.func_180495_p(pos2);
            if (!player.field_70170_p.field_72995_K) {
                List<ItemStack> blockDrops;
                List<ItemStack> origBlockDrops = Harvest.harvestReturnDrops(state, pos2, player.field_70170_p, player);
                if (converters.isEmpty()) {
                    blockDrops = origBlockDrops;
                } else {
                    blockDrops = new ArrayList<ItemStack>();
                    for (ItemStack orig : origBlockDrops) {
                        for (Function function : converters) {
                            orig = (ItemStack)function.apply(orig);
                        }
                        blockDrops.add(orig);
                    }
                }
                if (info.has(MAGNETISM)) {
                    drops.addAll(blockDrops);
                } else {
                    for (ItemStack stack : blockDrops) {
                        ItemUtil.spawnItem((World)player.field_70170_p, (BlockPos)pos2, (ItemStack)stack);
                    }
                }
                affectedPositions.add(pos2);
            }
            ++count;
        }
        for (BlockPos pos2 : pumpkinsAndMelons) {
            ++count;
            if (player.field_70170_p.field_72995_K) continue;
            SpellNaturesScythe.instance.breakBlock(player.field_70170_p, pos2, info, player, converters);
            affectedPositions.add(pos2);
        }
        if (info.has(UNDEAD) && !player.field_70170_p.field_72995_K && Util.rand.nextFloat() < this.undead_chance) {
            int c = this.undead_count + Util.rand.nextInt(this.undead_additional);
            for (int i = 0; i < c; ++i) {
                Item it = ModItems.spirit_bag;
                if (Util.rand.nextFloat() < this.undead_rarity) {
                    it = ModItems.reliquary;
                }
                ItemStack stack = new ItemStack(it);
                if (info.has(MAGNETISM)) {
                    ItemUtil.spawnItem((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (ItemStack)stack);
                    continue;
                }
                ItemUtil.spawnItem((World)player.field_70170_p, (BlockPos)Util.getRandomWithinRadius((BlockPos)player.func_180425_c(), (int)x, (int)y, (int)z), (ItemStack)stack);
            }
            ++count;
        }
        if (!affectedPositions.isEmpty() && !player.field_70170_p.field_72995_K) {
            MessageHarvestCompleteFX message = new MessageHarvestCompleteFX(affectedPositions);
            PacketHandler.sendToAllTracking((IMessage)message, (Entity)player);
        }
        if (!player.field_70170_p.field_72995_K) {
            for (ItemStack item : drops) {
                ItemUtil.spawnItem((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (ItemStack)item);
            }
            if (info.has(GROWTH)) {
                for (BlockPos pos3 : affectedPositions) {
                    if (!Growth.canGrow(player.field_70170_p, pos3, state = player.field_70170_p.func_180495_p(pos3))) continue;
                    int c = this.growth_count + Util.rand.nextInt(this.growth_additional);
                    for (int i = 0; i < c; ++i) {
                        state.func_177230_c().func_180645_a(player.field_70170_p, pos3, state, Util.rand);
                    }
                    PacketHandler.sendToAllTracking((IMessage)new MessageRampantLifeInfusionFX(pos3.func_177958_n(), pos3.func_177956_o(), pos3.func_177952_p()), (Entity)player);
                }
            }
        }
        return count != 0;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.radius_x = this.properties.get(PROP_RADIUS_X);
        this.radius_y = this.properties.get(PROP_RADIUS_Y);
        this.radius_z = this.properties.get(PROP_RADIUS_Z);
        this.radius_boost = this.properties.get(PROP_RADIUS_BOOST);
        this.radius_unboost = this.properties.get(PROP_RADIUS_UNBOOST);
        this.undead_additional = this.properties.get(PROP_UNDEAD_ADDITIONAL);
        this.undead_chance = this.properties.get(PROP_UNDEAD_CHANCE).floatValue();
        this.undead_count = this.properties.get(PROP_UNDEAD_COUNT);
        this.undead_rarity = this.properties.get(PROP_UNDEAD_RARITY).floatValue();
        this.growth_count = this.properties.get(PROP_GROWTH_COUNT);
        this.growth_additional = this.properties.get(PROP_GROWTH_ADDITIONAL);
    }

    static {
        RADIUS1.addConflict(SMALL_RADIUS);
        spellName = new ResourceLocation("roots", "spell_harvest");
        instance = new SpellHarvest(spellName);
        skipBlocks = Arrays.asList(Blocks.field_150357_h, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150329_H, Blocks.field_150358_i, Blocks.field_150355_j, Blocks.field_150353_l, Blocks.field_150398_cm, Blocks.field_150394_bc, Blocks.field_150393_bb);
    }

    private static interface ItemStackConverter
    extends Function<ItemStack, ItemStack> {
    }
}

