/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.roots.entity.spell.EntityThornTrap;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class SpellRoseThorns
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(24);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("terra_moss", 0.325));
    public static Property.PropertyDamage PROP_DAMAGE = new Property.PropertyDamage(Float.valueOf(4.0f));
    public static Property<Integer> PROP_SLOWNESS_DURATION = new Property<Integer>("slowness_duration", 80).setDescription("duration in ticks of the slowness effect applied when the traps are triggered");
    public static Property<Integer> PROP_SLOWNESS_AMPLIFIER = new Property<Integer>("slowness_amplifier", 0).setDescription("the level of the slowness effect (0 is the first level)");
    public static Property<Integer> PROP_POISON_DURATION = new Property<Integer>("poison_duration", 80).setDescription("duration in ticks of the poison effect applied when the traps are triggered");
    public static Property<Integer> PROP_POISON_AMPLIFIER = new Property<Integer>("poison_amplifier", 0).setDescription("the level of the poison effect (0 is the first level)");
    public static Property<Integer> PROP_DURATION = new Property<Integer>("trap_duration", 600).setDescription("duration in ticks of the trap before it disappears");
    public static Property<Integer> PROP_WEAKNESS_DURATION = new Property<Integer>("weakness_duration", 80).setDescription("how long enemies should be weakened in place for");
    public static Property<Integer> PROP_WEAKNESS_AMPLIFIER = new Property<Integer>("weakness_amplifier", 0).setDescription("the amplifier to be applied to the weakness effect");
    public static Property<Float> PROP_KNOCKBACK = new Property<Float>("knockback", Float.valueOf(1.2f)).setDescription("how much entities should be knocked back by");
    public static Property<Float> PROP_UNDEAD_DAMAGE = new Property<Float>("undead_damage", Float.valueOf(1.0f)).setDescription("how much additional damage against undead");
    public static Property<Float> PROP_KNOCKUP = new Property<Float>("knock_up", Float.valueOf(1.2f)).setDescription("how much a creature should be knocked up by");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 4).setDescription("how long entities should be set aflame for");
    public static Property<Integer> PROP_STRENGTH_DURATION = new Property<Integer>("strength_duration", 100).setDescription("how long the player should be empowered for when the trap triggers");
    public static Property<Integer> PROP_STRENGTH_AMPLIFIER = new Property<Integer>("strength_amplifier", 0).setDescription("the amplifier to be applied to the strength potion effect");
    public float damage;
    public float undead_damage;
    public float knockback;
    public float knockup;
    public int slowness_duration;
    public int slowness_amplifier;
    public int poison_duration;
    public int poison_amplifier;
    public int duration;
    public int strength_duration;
    public int strength_amplifier;
    public int fire_duration;
    public int weakness_duration;
    public int weakness_amplifier;
    public static Modifier BIGGER = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "larger_trap"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.475)));
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "peaceful_trap"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier WEAKNESS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "weakening_trap"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.45)));
    public static Modifier KNOCKBACK = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "repelling_trap"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.375)));
    public static Modifier UNDEAD = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "ghostly_trap"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.275)));
    public static Modifier POISON = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "poisonous_trap"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.125)));
    public static Modifier BOOST = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "boosting_trap"), ModifierCores.CLOUD_BERRY, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.CLOUD_BERRY, 0.345)));
    public static Modifier FIRE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "fire_trap"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.45)));
    public static Modifier STRENGTH = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "empowering_trap"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.475)));
    public static Modifier SLOW = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "slowing_trap"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.125)));
    public static ResourceLocation spellName;
    public static SpellRoseThorns instance;

    public SpellRoseThorns(ResourceLocation name) {
        super(name, TextFormatting.RED, 1.0f, 0.1254902f, 0.2509804f, 0.1254902f, 1.0f, 0.3764706f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_DAMAGE, PROP_SLOWNESS_AMPLIFIER, PROP_SLOWNESS_DURATION, PROP_POISON_AMPLIFIER, PROP_POISON_DURATION, PROP_DURATION, PROP_WEAKNESS_DURATION, PROP_WEAKNESS_AMPLIFIER, PROP_KNOCKBACK, PROP_KNOCKUP, PROP_UNDEAD_DAMAGE, PROP_STRENGTH_AMPLIFIER, PROP_STRENGTH_DURATION, PROP_FIRE_DURATION);
        this.acceptModifiers(BIGGER, PEACEFUL, WEAKNESS, KNOCKBACK, UNDEAD, POISON, BOOST, FIRE, STRENGTH, SLOW);
    }

    @Override
    public void init() {
        this.addIngredients(new OreIngredient("blockCactus"), new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()), new OreIngredient("stickWood"), new OreIngredient("dyeRed"), new ItemStack(ModItems.terra_moss));
        this.setCastSound(ModSounds.Spells.ROSE_THORNS);
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        if (!player.field_70170_p.field_72995_K) {
            EntityThornTrap trap = new EntityThornTrap(player.field_70170_p);
            trap.setPlayer(player.func_110124_au());
            trap.setModifiers(info);
            trap.func_70107_b(player.field_70165_t + player.func_70040_Z().field_72450_a, player.field_70163_u + (double)player.func_70047_e() + player.func_70040_Z().field_72448_b, player.field_70161_v + player.func_70040_Z().field_72449_c);
            trap.field_70159_w = player.func_70040_Z().field_72450_a * 0.75;
            trap.field_70181_x = player.func_70040_Z().field_72448_b * 0.75;
            trap.field_70179_y = player.func_70040_Z().field_72449_c * 0.75;
            player.field_70170_p.func_72838_d((Entity)trap);
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.damage = this.properties.get(PROP_DAMAGE).floatValue();
        this.poison_amplifier = this.properties.get(PROP_POISON_AMPLIFIER);
        this.poison_duration = this.properties.get(PROP_POISON_DURATION);
        this.slowness_amplifier = this.properties.get(PROP_SLOWNESS_AMPLIFIER);
        this.slowness_duration = this.properties.get(PROP_SLOWNESS_DURATION);
        this.duration = this.properties.get(PROP_DURATION);
        this.undead_damage = this.properties.get(PROP_UNDEAD_DAMAGE).floatValue();
        this.knockback = this.properties.get(PROP_KNOCKBACK).floatValue();
        this.knockup = this.properties.get(PROP_KNOCKUP).floatValue();
        this.strength_amplifier = this.properties.get(PROP_STRENGTH_AMPLIFIER);
        this.strength_duration = this.properties.get(PROP_STRENGTH_DURATION);
        this.weakness_duration = this.properties.get(PROP_WEAKNESS_DURATION);
        this.weakness_amplifier = this.properties.get(PROP_WEAKNESS_AMPLIFIER);
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
    }

    static {
        WEAKNESS.addConflicts(KNOCKBACK, BOOST, SLOW);
        BOOST.addConflicts(KNOCKBACK);
        spellName = new ResourceLocation("roots", "spell_rose_thorns");
        instance = new SpellRoseThorns(spellName);
    }
}

