/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell.info.storage;

import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.info.LibrarySpellInfo;
import epicsquid.roots.spell.info.storage.AbstractSpellStorage;
import epicsquid.roots.util.SpellUtil;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LibrarySpellStorage
extends AbstractSpellStorage<LibrarySpellInfo> {
    private LibrarySpellInfo info = null;

    public LibrarySpellStorage() {
    }

    protected LibrarySpellStorage(ItemStack stack) {
        super(stack);
    }

    @Override
    public boolean hasSpellInSlot() {
        return this.info != null;
    }

    @Override
    public boolean isEmpty() {
        return this.info != null;
    }

    @Override
    public boolean isValid() {
        return SpellUtil.isValidDust(this.stack);
    }

    @Override
    @Nullable
    public LibrarySpellInfo getSpellInSlot(int slot) {
        return this.info;
    }

    @Override
    public void clearSelectedSlot() {
        this.info = null;
        this.saveToStack();
    }

    @Override
    public void clearSlot(int slot) {
        this.clearSelectedSlot();
    }

    @Override
    public void previousSlot() {
    }

    @Override
    public void nextSlot() {
    }

    public void setSpellToSlot(SpellBase spell) {
        LibrarySpellInfo info = new LibrarySpellInfo(spell);
        this.addSpell(info);
    }

    @Override
    public void addSpell(LibrarySpellInfo spell) {
        this.info = spell;
        this.saveToStack();
    }

    @Override
    public void setSpellToSlot(int slot, LibrarySpellInfo spell) {
        this.addSpell(spell);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        if (this.info == null) {
            return new NBTTagCompound();
        }
        return this.info.serializeNBT();
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        this.info = LibrarySpellInfo.fromNBT(tag);
    }

    @Nullable
    public static LibrarySpellStorage fromStack(ItemStack stack) {
        return LibrarySpellStorage.fromStack(stack, LibrarySpellStorage::new);
    }
}

