/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.world.data;

import epicsquid.roots.modifiers.instance.library.LibraryModifierInstance;
import epicsquid.roots.modifiers.instance.library.LibraryModifierInstanceList;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.spell.info.LibrarySpellInfo;
import epicsquid.roots.spell.info.SpellDustInfo;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;

public class SpellLibraryData
extends WorldSavedData
implements Iterable<LibrarySpellInfo> {
    private static final String identifier = "SpellData-";
    private Map<SpellBase, LibrarySpellInfo> spells = new HashMap<SpellBase, LibrarySpellInfo>();
    private List<LibrarySpellInfo> list = null;
    private UUID uuid;

    public static String name(UUID uuid) {
        return identifier + uuid.toString();
    }

    public SpellLibraryData(String name) {
        super(name);
        this.uuid = UUID.fromString(name.replace(identifier, ""));
        this.generateMap();
    }

    public SpellLibraryData(UUID uuid) {
        super(SpellLibraryData.name(uuid));
        this.uuid = uuid;
        this.generateMap();
    }

    public SpellLibraryData(EntityPlayer player) {
        super(identifier + player.func_189512_bd());
        this.uuid = player.func_110124_au();
        this.generateMap();
    }

    private void generateMap() {
        this.spells.clear();
        for (SpellBase spell : SpellRegistry.spellRegistry.values()) {
            this.spells.put(spell, new LibrarySpellInfo(spell));
        }
    }

    public void addSpell(SpellDustInfo info) {
        SpellBase spell = info.getSpell();
        if (spell != null) {
            LibrarySpellInfo libinfo = this.spells.get(spell);
            libinfo.setObtained();
            this.list = null;
            this.func_76185_a();
        }
    }

    public void addSpell(SpellBase spell) {
        LibrarySpellInfo info = this.spells.get(spell);
        info.setObtained();
        this.list = null;
        this.func_76185_a();
    }

    public LibrarySpellInfo getData(SpellBase spell) {
        return this.spells.get(spell);
    }

    @Nullable
    public LibraryModifierInstanceList getModifiers(LibrarySpellInfo incoming) {
        SpellBase spell = incoming.getSpell();
        if (spell != null) {
            LibrarySpellInfo current = this.getData(spell);
            return current.getModifiers();
        }
        return null;
    }

    public void updateSpell(LibrarySpellInfo incoming) {
        SpellBase spell = incoming.getSpell();
        if (spell == null) {
            return;
        }
        LibrarySpellInfo current = this.getData(spell);
        if (!current.isObtained() && incoming.isObtained()) {
            current.setObtained();
        }
        for (LibraryModifierInstance instance : incoming.getModifiers()) {
            if (!instance.isApplied()) continue;
            LibraryModifierInstance currentInstance = (LibraryModifierInstance)current.getModifiers().get(instance.getModifier());
            if (currentInstance == null) {
                throw new NullPointerException("Trying to update " + spell.getRegistryName() + " for player " + this.uuid + " but incoming modifier list contained " + instance.getModifier().getRegistryName() + " but our copy does not!");
            }
            if (currentInstance.isApplied()) continue;
            currentInstance.setApplied();
        }
        this.list = null;
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("spells", 10);
        this.generateMap();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            LibrarySpellInfo instance = LibrarySpellInfo.fromNBT(list.func_150305_b(i));
            SpellBase spell = instance.getSpell();
            if (spell == null) continue;
            this.spells.put(spell, instance);
        }
        this.uuid = nbt.func_186857_a("uuid");
        this.list = null;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (LibrarySpellInfo instance : this.spells.values()) {
            if (instance == null) continue;
            list.func_74742_a((NBTBase)instance.serializeNBT());
        }
        compound.func_74782_a("spells", (NBTBase)list);
        compound.func_186854_a("uuid", this.uuid);
        return compound;
    }

    public List<LibrarySpellInfo> asList() {
        if (this.list == null) {
            this.list = this.spells.values().stream().filter(o -> o.getSpell() != null).filter(LibrarySpellInfo::isObtained).collect(Collectors.toList());
        }
        this.list.sort(Comparator.comparing(a -> a.getSpell() == null ? "" : a.getSpell().getRegistryName().func_110623_a()));
        return this.list;
    }

    @Override
    public Iterator<LibrarySpellInfo> iterator() {
        return this.asList().iterator();
    }

    @Nullable
    public LibrarySpellInfo get(int slot) {
        List<LibrarySpellInfo> info = this.asList();
        if (slot < info.size()) {
            return info.get(slot);
        }
        return null;
    }

    public int size() {
        return this.asList().size();
    }
}

