/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.impetus;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;

public class ImpetusStorage
implements IImpetusStorage,
INBTSerializable<NBTTagCompound> {
    protected long energy;
    protected long maxEnergy;
    protected long maxReceive;
    protected long maxExtract;

    public ImpetusStorage(long maxEnergy) {
        this(maxEnergy, maxEnergy, maxEnergy, 0L);
    }

    public ImpetusStorage(long maxEnergy, long maxTransfer) {
        this(maxEnergy, maxTransfer, maxTransfer, 0L);
    }

    public ImpetusStorage(long maxEnergy, long maxReceive, long maxExtract) {
        this(maxEnergy, maxReceive, maxExtract, 0L);
    }

    public ImpetusStorage(long maxEnergy, long maxReceive, long maxExtract, long initialEnergy) {
        this.energy = Math.max(0L, Math.min(maxEnergy, initialEnergy));
        this.maxEnergy = maxEnergy;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    @Override
    public boolean canExtract() {
        return this.maxExtract > 0L;
    }

    @Override
    public boolean canReceive() {
        return this.maxReceive > 0L;
    }

    @Override
    public long extractEnergy(long maxToExtract, boolean simulate) {
        if (this.canExtract()) {
            long amount = Math.min(this.energy, Math.min(this.maxExtract, maxToExtract));
            if (!simulate) {
                this.energy -= amount;
            }
            return amount;
        }
        return 0L;
    }

    @Override
    public long receiveEnergy(long maxToReceive, boolean simulate) {
        if (this.canReceive()) {
            long amount = Math.min(Math.min(this.maxReceive, maxToReceive), this.maxEnergy - this.energy);
            if (!simulate) {
                this.energy += amount;
            }
            return amount;
        }
        return 0L;
    }

    @Override
    public long getEnergyStored() {
        return this.energy;
    }

    @Override
    public long getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_74763_f("energy");
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("energy", this.energy);
        return tag;
    }
}

