/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.util;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public final class RaytraceHelper {
    private RaytraceHelper() {
    }

    public static Vec3d raytracePosition(EntityLivingBase user, double maxDistance) {
        return RaytraceHelper.raytracePosition(user, maxDistance, 1.0f, (Predicate<? super Entity>)Predicates.and((com.google.common.base.Predicate)EntitySelectors.field_180132_d, entity -> entity != null && entity.func_70067_L()));
    }

    public static Vec3d raytracePosition(EntityLivingBase user, double maxDistance, @Nullable Predicate<? super Entity> entityFilter) {
        return RaytraceHelper.raytracePosition(user, maxDistance, 1.0f, entityFilter);
    }

    public static Vec3d raytracePosition(EntityLivingBase user, double maxDistance, float partialTicks) {
        return RaytraceHelper.raytracePosition(user, maxDistance, partialTicks, (Predicate<? super Entity>)Predicates.and((com.google.common.base.Predicate)EntitySelectors.field_180132_d, entity -> entity != null && entity.func_70067_L()));
    }

    public static Vec3d raytracePosition(EntityLivingBase user, double maxDistance, float partialTicks, @Nullable Predicate<? super Entity> entityFilter) {
        Vec3d ret;
        Vec3d eyes = user.func_174824_e(partialTicks);
        Vec3d look = user.func_70676_i(partialTicks);
        Vec3d extended = eyes.func_72441_c(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance);
        RayTraceResult blockCheck = user.func_130014_f_().func_147447_a(eyes, extended, false, true, true);
        Vec3d vec3d = ret = blockCheck != null ? blockCheck.field_72307_f : extended;
        if (entityFilter != null) {
            maxDistance = blockCheck != null ? blockCheck.field_72307_f.func_72438_d(eyes) : maxDistance;
            List list = user.func_130014_f_().func_175674_a((Entity)user, user.func_174813_aQ().func_72321_a(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance).func_72314_b(1.0, 1.0, 1.0), entityFilter::test);
            double dist = maxDistance;
            for (Entity entity : list) {
                double newDist;
                AxisAlignedBB aabb = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y());
                if (aabb.func_72318_a(eyes)) {
                    ret = eyes;
                    break;
                }
                RayTraceResult res = aabb.func_72327_a(eyes, extended);
                if (res == null || !((newDist = eyes.func_72438_d(res.field_72307_f)) < dist)) continue;
                ret = res.field_72307_f;
                dist = newDist;
            }
        }
        return ret;
    }

    @Nullable
    public static Entity raytraceEntity(EntityLivingBase user, double maxDistance) {
        return RaytraceHelper.raytraceEntity(user, maxDistance, e -> true);
    }

    @Nullable
    public static Entity raytraceEntity(EntityLivingBase user, double maxDistance, Predicate<Entity> acceptor) {
        Vec3d eyes = user.func_174824_e(1.0f);
        Vec3d look = user.func_70676_i(1.0f);
        Vec3d extended = eyes.func_72441_c(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance);
        RayTraceResult blockCheck = user.func_130014_f_().func_147447_a(eyes, extended, false, true, true);
        maxDistance = blockCheck != null ? blockCheck.field_72307_f.func_72438_d(eyes) : maxDistance;
        List list = user.func_130014_f_().func_175674_a((Entity)user, user.func_174813_aQ().func_72321_a(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance).func_72314_b(1.0, 1.0, 1.0), Predicates.and(entity -> entity != null && entity.func_70067_L(), (com.google.common.base.Predicate)Predicates.and((com.google.common.base.Predicate)EntitySelectors.field_180132_d, entity -> acceptor.test((Entity)entity))));
        double dist = maxDistance;
        Entity ret = null;
        for (Entity entity2 : list) {
            double newDist;
            AxisAlignedBB aabb = entity2.func_174813_aQ().func_186662_g((double)entity2.func_70111_Y());
            if (aabb.func_72318_a(eyes)) {
                ret = entity2;
                break;
            }
            RayTraceResult res = aabb.func_72327_a(eyes, extended);
            if (res == null || !((newDist = eyes.func_72438_d(res.field_72307_f)) < dist)) continue;
            ret = entity2;
            dist = newDist;
        }
        return ret;
    }

    @Nullable
    public static Pair<Entity, Vec3d> raytraceEntityAndPos(EntityLivingBase user, double maxDistance, Predicate<Entity> acceptor) {
        Vec3d eyes = user.func_174824_e(1.0f);
        Vec3d look = user.func_70676_i(1.0f);
        Vec3d extended = eyes.func_72441_c(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance);
        RayTraceResult blockCheck = user.func_130014_f_().func_147447_a(eyes, extended, false, true, true);
        maxDistance = blockCheck != null ? blockCheck.field_72307_f.func_72438_d(eyes) : maxDistance;
        List list = user.func_130014_f_().func_175674_a((Entity)user, user.func_174813_aQ().func_72321_a(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance).func_72314_b(1.0, 1.0, 1.0), Predicates.and(entity -> entity != null && entity.func_70067_L(), (com.google.common.base.Predicate)Predicates.and((com.google.common.base.Predicate)EntitySelectors.field_180132_d, entity -> acceptor.test((Entity)entity))));
        double dist = maxDistance;
        Pair ret = null;
        for (Entity entity2 : list) {
            double newDist;
            AxisAlignedBB aabb = entity2.func_174813_aQ().func_186662_g((double)entity2.func_70111_Y());
            if (aabb.func_72318_a(eyes)) {
                ret = Pair.of((Object)entity2, (Object)eyes);
                break;
            }
            RayTraceResult res = aabb.func_72327_a(eyes, extended);
            if (res == null || !((newDist = eyes.func_72438_d(res.field_72307_f)) < dist)) continue;
            ret = Pair.of((Object)entity2, (Object)res.field_72307_f);
            dist = newDist;
        }
        return ret;
    }

    public static List<Entity> raytraceEntities(EntityLivingBase user, double maxDistance) {
        Vec3d eyes = user.func_174824_e(1.0f);
        Vec3d look = user.func_70676_i(1.0f);
        Vec3d extended = eyes.func_72441_c(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance);
        RayTraceResult blockCheck = user.func_130014_f_().func_147447_a(eyes, extended, false, true, true);
        maxDistance = blockCheck != null ? blockCheck.field_72307_f.func_72438_d(eyes) : maxDistance;
        List list = user.func_130014_f_().func_175674_a((Entity)user, user.func_174813_aQ().func_72321_a(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance).func_72314_b(1.0, 1.0, 1.0), Predicates.and((com.google.common.base.Predicate)EntitySelectors.field_180132_d, entity -> entity != null && entity.func_70067_L()));
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity entity2 : list) {
            AxisAlignedBB aabb = entity2.func_174813_aQ().func_186662_g((double)entity2.func_70111_Y());
            if (!aabb.func_72318_a(eyes) && aabb.func_72327_a(eyes, extended) == null) continue;
            ret.add(entity2);
        }
        ret.sort((e1, e2) -> Double.compare(e1.func_70068_e((Entity)user), e2.func_70068_e((Entity)user)));
        return ret;
    }

    public static List<Entity> raytraceEntities(World world, Vec3d start, Vec3d end) {
        List list = world.func_175647_a(Entity.class, new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, end.field_72450_a, end.field_72448_b, end.field_72449_c), Predicates.and((com.google.common.base.Predicate)EntitySelectors.field_180132_d, entity -> entity != null && entity.func_70067_L()));
        ArrayList<Entity> ret = new ArrayList<Entity>();
        for (Entity entity2 : list) {
            AxisAlignedBB aabb = entity2.func_174813_aQ().func_186662_g((double)entity2.func_70111_Y());
            if (!aabb.func_72318_a(start) && aabb.func_72327_a(start, end) == null) continue;
            ret.add(entity2);
        }
        ret.sort((e1, e2) -> Double.compare(e1.func_70092_e(start.field_72450_a, start.field_72448_b, start.field_72449_c), e2.func_70092_e(start.field_72450_a, start.field_72448_b, start.field_72449_c)));
        return ret;
    }
}

