/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.golem;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.IGolemAPI;
import thaumcraft.api.golems.seals.ISeal;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.ISealGui;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.golems.tasks.TaskHandler;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;

public class SealAttack
implements ISeal,
ISealGui {
    private static final ResourceLocation ICON = new ResourceLocation("thaumicaugmentation", "items/seal/seal_attack");
    protected int ticks = ThreadLocalRandom.current().nextInt(20);
    protected ISealConfigToggles.SealToggle[] props = new ISealConfigToggles.SealToggle[]{new ISealConfigToggles.SealToggle(true, "pmob", "golem.prop.mob"), new ISealConfigToggles.SealToggle(false, "panimal", "golem.prop.animal"), new ISealConfigToggles.SealToggle(false, "pplayer", "golem.prop.player"), new ISealConfigToggles.SealToggle(false, "pother", "golem.prop.other"), new ISealConfigToggles.SealToggle(true, "psight", "golem.prop.sight")};

    public String getKey() {
        return "thaumicaugmentation:attack";
    }

    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        if (golem == task.getEntity()) {
            return false;
        }
        if (task.getEntity().func_174831_c(golem.getGolemEntity().func_180425_c()) > Math.pow(((EntityCreature)golem.getGolemEntity()).func_110174_bM(), 2.0)) {
            return false;
        }
        if (task.getEntity() instanceof IEntityOwnable && ((IEntityOwnable)task.getEntity()).func_184753_b() != null && ((IEntityOwnable)task.getEntity()).func_184753_b().equals(((IEntityOwnable)golem.getGolemEntity()).func_184753_b())) {
            return false;
        }
        return !golem.getGolemEntity().func_184191_r(task.getEntity()) && (!this.props[4].getValue() || ((EntityLiving)golem.getGolemEntity()).func_70635_at().func_75522_a(task.getEntity()));
    }

    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing face) {
        return !world.func_175623_d(pos);
    }

    protected boolean isValidTarget(EntityLivingBase entity) {
        if (this.props[0].getValue() && entity instanceof IMob) {
            return true;
        }
        if (this.props[1].getValue() && entity instanceof IAnimals) {
            return true;
        }
        if (this.props[2].getValue() && FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W() && entity instanceof EntityPlayer) {
            return true;
        }
        return this.props[3].getValue() && !(entity instanceof IMob) && !(entity instanceof IAnimals) && !(entity instanceof EntityPlayer);
    }

    public void onTaskStarted(World world, IGolemAPI golem, Task task) {
        if (task.getEntity() instanceof EntityLivingBase && this.isValidTarget((EntityLivingBase)task.getEntity())) {
            ((EntityLiving)golem.getGolemEntity()).func_70624_b((EntityLivingBase)task.getEntity());
        }
    }

    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        task.setSuspended(true);
        return true;
    }

    public void tickSeal(World world, ISealEntity seal) {
        if (++this.ticks % 20 == 0) {
            BlockPos sealPos = seal.getSealPos().pos;
            AxisAlignedBB box = new AxisAlignedBB(sealPos).func_186662_g(24.0);
            List targets = world.func_72872_a(EntityLivingBase.class, box);
            targets.sort((entity1, entity2) -> (int)Math.signum(entity1.func_174831_c(sealPos) - entity2.func_174831_c(sealPos)));
            for (EntityLivingBase entity : targets) {
                if (!this.isValidTarget(entity)) continue;
                Task task = new Task(seal.getSealPos(), (Entity)entity);
                task.setPriority(seal.getPriority());
                task.setLifespan((short)10);
                TaskHandler.addTask((int)world.field_73011_w.getDimension(), (Task)task);
            }
        }
    }

    public ResourceLocation getSealIcon() {
        return ICON;
    }

    public int[] getGuiCategories() {
        return new int[]{0, 4};
    }

    public EnumGolemTrait[] getRequiredTags() {
        return new EnumGolemTrait[]{EnumGolemTrait.FIGHTER};
    }

    public EnumGolemTrait[] getForbiddenTags() {
        return null;
    }

    public Object returnContainer(World world, EntityPlayer player, BlockPos pos, EnumFacing face, ISealEntity seal) {
        return ThaumicAugmentation.proxy.getSealContainer(world, player, pos, face, seal);
    }

    @SideOnly(value=Side.CLIENT)
    public Object returnGui(World world, EntityPlayer player, BlockPos pos, EnumFacing face, ISealEntity seal) {
        return ThaumicAugmentation.proxy.getSealGUI(world, player, pos, face, seal);
    }

    public void onTaskSuspension(World world, Task task) {
    }

    public void onRemoval(World world, BlockPos pos, EnumFacing face) {
    }

    public void readCustomNBT(NBTTagCompound tag) {
    }

    public void writeCustomNBT(NBTTagCompound tag) {
    }
}

