/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world.biome;

import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenerator;
import thaumcraft.common.entities.monster.tainted.EntityTaintCrawler;
import thaumcraft.common.entities.monster.tainted.EntityTaintacle;
import thaumcraft.common.entities.monster.tainted.EntityTaintacleSmall;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.block.property.ITAStoneType;
import thecodex6824.thaumicaugmentation.api.world.IPurgeBiomeSpawns;
import thecodex6824.thaumicaugmentation.common.world.biome.BiomeDecoratorTaintedLands;
import thecodex6824.thaumicaugmentation.common.world.biome.IBiomeSpecificSpikeBlockProvider;
import thecodex6824.thaumicaugmentation.common.world.biome.IFluxBiome;
import thecodex6824.thaumicaugmentation.common.world.feature.WorldGenTaintFlower;

public class BiomeTaintedLands
extends Biome
implements IPurgeBiomeSpawns,
IFluxBiome,
IBiomeSpecificSpikeBlockProvider {
    protected static final WorldGenTaintFlower FLOWER_GENERATOR = new WorldGenTaintFlower();
    protected static final Random POS_RNG = new Random();

    public BiomeTaintedLands() {
        super(new Biome.BiomeProperties("Tainted Lands").func_185398_c(-1.8f).func_185400_d(0.15f).func_185396_a().func_185410_a(0.25f).func_185402_a(0xFF00FF));
        this.purgeSpawns();
        this.flowers.clear();
        this.field_76752_A = TABlocks.STONE.func_176223_P().func_177226_a(ITAStoneType.STONE_TYPE, (Comparable)((Object)ITAStoneType.StoneType.SOIL_STONE_TAINT_NODECAY));
        this.field_76753_B = TABlocks.STONE.func_176223_P().func_177226_a(ITAStoneType.STONE_TYPE, (Comparable)((Object)ITAStoneType.StoneType.STONE_VOID));
    }

    @Override
    public void purgeSpawns() {
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTaintCrawler.class, 100, 3, 5));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTaintacleSmall.class, 75, 1, 2));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityTaintacle.class, 50, 1, 1));
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityEnderman.class, 1, 2, 2));
        this.field_76755_L.clear();
        this.field_82914_M.clear();
    }

    @Override
    public IBlockState getSpikeState(World world, BlockPos pos) {
        return TABlocks.STONE.func_176223_P().func_177226_a(ITAStoneType.STONE_TYPE, (Comparable)((Object)ITAStoneType.StoneType.STONE_TAINT_NODECAY));
    }

    @Override
    public float getBaseFluxConcentration() {
        return 0.5f;
    }

    public boolean func_76738_d() {
        return false;
    }

    public int func_76731_a(float currentTemperature) {
        return 0;
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noiseVal) {
        int cX = x & 0xF;
        int cZ = z & 0xF;
        for (int y = Math.min(world.func_72940_L(), 255); y >= 0; --y) {
            IBlockState current = primer.func_177856_a(cZ, y, cX);
            if (current.func_177230_c().isAir(current, (IBlockAccess)world, new BlockPos(x, y, z))) continue;
            primer.func_177855_a(cZ, y, cX, primer.func_177856_a(cZ, y + 1, cX).func_185915_l() ? this.field_76753_B : this.field_76752_A);
        }
    }

    public WorldGenerator func_76730_b(Random rand) {
        return FLOWER_GENERATOR;
    }

    public BiomeDecorator func_76729_a() {
        return new BiomeDecoratorTaintedLands();
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        return BlockFlower.EnumFlowerType.ALLIUM;
    }

    public int func_180625_c(BlockPos pos) {
        POS_RNG.setSeed((long)pos.func_177958_n() + (long)pos.func_177952_p() * Long.MAX_VALUE);
        int colorMod = POS_RNG.nextInt(64) - POS_RNG.nextInt(64);
        return this.getModdedBiomeFoliageColor((102 + colorMod << 16) + 102 + colorMod);
    }

    public int func_180627_b(BlockPos pos) {
        POS_RNG.setSeed((long)pos.func_177958_n() + (long)pos.func_177952_p() * Long.MAX_VALUE);
        int colorMod = POS_RNG.nextInt(64) - POS_RNG.nextInt(64);
        return this.getModdedBiomeGrassColor((102 + colorMod << 16) + 102 + colorMod);
    }
}

