/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.invman;

import com.m4thg33k.tombmanygraves.api.GraveRegistry;
import com.m4thg33k.tombmanygraves.api.IGraveInventory;
import com.m4thg33k.tombmanygraves.api.TempInventory;
import com.m4thg33k.tombmanygraves.util.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;

public class GraveInventoryManager {
    private static GraveInventoryManager INSTANCE = null;
    private Map<String, IGraveInventory> listenerMap = new HashMap<String, IGraveInventory>();
    private List<Map.Entry<String, IGraveInventory>> sortedListeners = new ArrayList<Map.Entry<String, IGraveInventory>>();
    private Map<IGraveInventory, GraveRegistry> annotationMap = new HashMap<IGraveInventory, GraveRegistry>();
    private List<String> sortedGuiNames = new ArrayList<String>();

    private GraveInventoryManager() {
    }

    public static GraveInventoryManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GraveInventoryManager();
        }
        return INSTANCE;
    }

    public Stream<Map.Entry<String, IGraveInventory>> getGraveInventoryStream() {
        return this.sortedListeners.stream();
    }

    public static int getGuiColorForInventory(String key) {
        GraveInventoryManager instance = GraveInventoryManager.getInstance();
        if (instance.listenerMap.containsKey(key)) {
            return instance.annotationMap.get(instance.listenerMap.get(key)).color();
        }
        return 0;
    }

    private int clampPriority(int priority) {
        if (priority < -10) {
            return -10;
        }
        if (priority > 10) {
            return 10;
        }
        return priority;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ParametersAreNonnullByDefault
    public void registerListener(IGraveInventory iGraveInventory, Map<String, Object> annotation) throws Exception {
        String uniqueId = (String)annotation.get("id");
        this.annotationMap.put(iGraveInventory, iGraveInventory.getClass().getDeclaredAnnotation(GraveRegistry.class));
        LogHelper.info("Attempting to register special inventory: " + uniqueId);
        if (this.listenerMap.containsKey(uniqueId)) {
            if (!((Boolean)annotation.get("overridable")).booleanValue()) {
                if (!this.annotationMap.get(this.listenerMap.get(uniqueId)).overridable()) throw new Exception("Unable to register listener for TombManyGraves with unique id: " + uniqueId + ". A listener with that id has already been registered and cannot be overwritten!");
                this.listenerMap.put(uniqueId, iGraveInventory);
                LogHelper.info("Special inventory with id (" + uniqueId + ") already exists, but is able to be overwritten. Replacing existing inventory.");
                return;
            } else {
                LogHelper.info("Special inventory with id (" + uniqueId + ") already exists, but the new one is able to be overwritten. Ignoring new inventory.");
            }
            return;
        } else {
            LogHelper.info("Added special inventory with id (" + uniqueId + ") to TombManyGraves.");
            this.listenerMap.put(uniqueId, iGraveInventory);
        }
    }

    public void finalizeListeners() {
        this.sortedListeners = this.listenerMap.entrySet().stream().sorted((x, y) -> {
            System.out.println(this.annotationMap.get(x.getValue()));
            int flag = -Integer.compare(this.clampPriority(this.annotationMap.get(x.getValue()).priority()), this.annotationMap.get(y.getValue()).priority());
            if (flag == 0) {
                flag = ((String)x.getKey()).compareTo((String)y.getKey());
            }
            return flag;
        }).collect(Collectors.toList());
        this.sortedGuiNames = this.listenerMap.keySet().stream().sorted((x, y) -> {
            if ("vanilla".equals(x)) {
                return -1;
            }
            if ("vanilla".equals(y)) {
                return 1;
            }
            return this.annotationMap.get(this.listenerMap.get(x)).name().compareToIgnoreCase(this.annotationMap.get(this.listenerMap.get(y)).name());
        }).collect(Collectors.toList());
    }

    public List<String> getSortedGuiNames() {
        return this.sortedGuiNames;
    }

    public HashMap<String, TempInventory> grabItemsFromPlayer(EntityPlayer player) {
        Iterator iter = this.getGraveInventoryStream().iterator();
        boolean shouldContinue = true;
        while (iter.hasNext() && (shouldContinue = ((IGraveInventory)((Map.Entry)iter.next()).getValue()).pregrabLogic(player))) {
        }
        HashMap<String, TempInventory> itms = new HashMap<String, TempInventory>();
        if (!shouldContinue) {
            return itms;
        }
        AtomicInteger numAdded = new AtomicInteger(0);
        this.getGraveInventoryStream().forEach(entry -> {
            TempInventory data = ((IGraveInventory)entry.getValue()).getItems(player);
            if (data != null) {
                itms.put((String)entry.getKey(), data);
                numAdded.incrementAndGet();
            }
        });
        return itms;
    }

    public void insertInventory(EntityPlayer player, NBTTagCompound compound, boolean shouldForce) {
        if (compound != null) {
            this.getGraveInventoryStream().forEach(entry -> {
                if (compound.func_74764_b((String)entry.getKey())) {
                    ((IGraveInventory)entry.getValue()).insertInventory(player, new TempInventory(compound.func_150295_c((String)entry.getKey(), 10)), shouldForce);
                }
            });
        }
    }

    public List<ItemStack> generateDrops(NBTTagCompound compound) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (compound != null) {
            this.getGraveInventoryStream().forEach(entry -> {
                if (compound.func_74764_b((String)entry.getKey())) {
                    TempInventory inv = new TempInventory(compound.func_150295_c((String)entry.getKey(), 10));
                    drops.addAll(inv.getListOfNonEmptyItemStacks());
                }
            });
        }
        return drops;
    }

    public Map<String, Tuple<String, List<String>>> createItemListForGui(NBTTagCompound compound) {
        HashMap<String, Tuple<String, List<String>>> theMap = new HashMap<String, Tuple<String, List<String>>>();
        this.getGraveInventoryStream().forEach(entry -> {
            TempInventory inv;
            List<ItemStack> drops;
            if (compound.func_74764_b((String)entry.getKey()) && (drops = (inv = new TempInventory(compound.func_150295_c((String)entry.getKey(), 10))).getListOfNonEmptyItemStacks()).size() > 0) {
                theMap.put((String)entry.getKey(), (Tuple<String, List<String>>)new Tuple((Object)this.annotationMap.get(entry.getValue()).name(), TempInventory.getGuiStringsForItemStackList(drops)));
            }
        });
        return theMap;
    }
}

