/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.init;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemSlab;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.item.ItemBuffaloDrops;
import pokefenn.totemic.item.ItemCeremonyCheat;
import pokefenn.totemic.item.ItemEagleDrops;
import pokefenn.totemic.item.ItemTipi;
import pokefenn.totemic.item.ItemTotemicItems;
import pokefenn.totemic.item.ItemTotempedia;
import pokefenn.totemic.item.equipment.ItemBarkStripper;
import pokefenn.totemic.item.equipment.ItemMedicineBag;
import pokefenn.totemic.item.equipment.ItemTotemWhittlingKnife;
import pokefenn.totemic.item.equipment.ItemTotemicStaff;
import pokefenn.totemic.item.equipment.music.ItemEagleBoneWhistle;
import pokefenn.totemic.item.equipment.music.ItemFlute;
import pokefenn.totemic.item.equipment.music.ItemJingleDress;
import pokefenn.totemic.item.equipment.music.ItemNetherPipe;
import pokefenn.totemic.item.equipment.music.ItemRattle;
import pokefenn.totemic.item.equipment.weapon.ItemBaykokBow;
import pokefenn.totemic.lib.WoodVariant;

@Mod.EventBusSubscriber(modid="totemic")
@GameRegistry.ObjectHolder(value="totemic")
public final class ModItems {
    public static final ItemFlute flute = null;
    public static final ItemRattle rattle = null;
    public static final ItemJingleDress jingle_dress = null;
    public static final ItemEagleBoneWhistle eagle_bone_whistle = null;
    public static final ItemTotemWhittlingKnife totem_whittling_knife = null;
    public static final ItemBarkStripper bark_stripper = null;
    public static final ItemTotemicStaff totemic_staff = null;
    public static final ItemTotemicItems sub_items = null;
    public static final ItemTotempedia totempedia = null;
    public static final ItemBuffaloDrops buffalo_items = null;
    public static final ItemFood buffalo_meat = null;
    public static final ItemFood cooked_buffalo_meat = null;
    public static final ItemBaykokBow baykok_bow = null;
    public static final ItemMedicineBag medicine_bag = null;
    public static final ItemCeremonyCheat ceremony_cheat = null;
    public static final ItemEagleDrops eagle_drops = null;
    public static final ItemNetherPipe nether_pipe = null;

    @SubscribeEvent
    public static void init(RegistryEvent.Register<Item> event) {
        ItemMultiTexture.Mapper pillar_mapper = stack -> {
            int meta = stack.func_77960_j();
            return ((meta & 1) == 1 ? "stripped_" : "") + WoodVariant.fromID(meta >> 1).func_176610_l();
        };
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{ModItems.makeItemBlock((Block)ModBlocks.cedar_log), ModItems.makeItemBlock((Block)ModBlocks.stripped_cedar_log), ModItems.makeItemBlock(ModBlocks.cedar_plank), ModItems.makeItemBlock((Block)ModBlocks.cedar_sapling), ModItems.makeItemBlock((Block)ModBlocks.cedar_leaves), ModItems.makeItemBlock((Block)ModBlocks.cedar_stairs), (Item)new ItemSlab((Block)ModBlocks.cedar_slab, (BlockSlab)ModBlocks.cedar_slab, (BlockSlab)ModBlocks.double_cedar_slab).setRegistryName(ModBlocks.cedar_slab.getRegistryName()), ModItems.makeItemBlock((Block)ModBlocks.cedar_fence), ModItems.makeItemBlock((Block)ModBlocks.cedar_fence_gate), ModItems.makeItemBlock(ModBlocks.totem_base).func_77627_a(true), ModItems.makeItemBlock(ModBlocks.totem_pole).func_77627_a(true), ModItems.makeItemBlock(ModBlocks.totem_torch), ModItems.makeItemBlock(ModBlocks.drum), ModItems.makeItemBlock(ModBlocks.wind_chime), (Item)new ItemTipi(ModBlocks.tipi).setRegistryName(ModBlocks.tipi.getRegistryName()), (Item)new ItemMultiTexture((Block)ModBlocks.wooden_pillar, (Block)ModBlocks.wooden_pillar, pillar_mapper).setRegistryName(ModBlocks.wooden_pillar.getRegistryName()), (Item)new ItemMultiTexture((Block)ModBlocks.wooden_pillar_base, (Block)ModBlocks.wooden_pillar_base, pillar_mapper).setRegistryName(ModBlocks.wooden_pillar_base.getRegistryName()), new ItemFlute(), new ItemRattle(), new ItemJingleDress(), new ItemEagleBoneWhistle(), new ItemTotemWhittlingKnife(), new ItemBarkStripper(), new ItemTotemicStaff(), new ItemTotemicItems(), new ItemTotempedia(), new ItemBuffaloDrops(), ((Item)new ItemFood(3, 0.35f, true).setRegistryName("buffalo_meat")).func_77655_b("totemic:buffalo_meat").func_77637_a(Totemic.tabsTotem), ((Item)new ItemFood(9, 0.9f, true).setRegistryName("cooked_buffalo_meat")).func_77655_b("totemic:cooked_buffalo_meat").func_77637_a(Totemic.tabsTotem), new ItemBaykokBow(), new ItemMedicineBag(), new ItemCeremonyCheat(), new ItemEagleDrops(), new ItemNetherPipe()});
    }

    private static ItemBlock makeItemBlock(Block block) {
        return (ItemBlock)new ItemBlock(block).setRegistryName(block.getRegistryName());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void setItemModels(ModelRegistryEvent event) {
        ModItems.setDefaultModel((Block)ModBlocks.cedar_log);
        ModItems.setDefaultModel((Block)ModBlocks.stripped_cedar_log);
        ModItems.setDefaultModel(ModBlocks.cedar_plank);
        ModItems.setDefaultModel((Block)ModBlocks.cedar_sapling);
        ModItems.setDefaultModel((Block)ModBlocks.cedar_leaves);
        ModItems.setDefaultModel((Block)ModBlocks.cedar_stairs);
        ModItems.setDefaultModel((Block)ModBlocks.cedar_slab);
        ModItems.setDefaultModel((Block)ModBlocks.cedar_fence);
        ModItems.setDefaultModel((Block)ModBlocks.cedar_fence_gate);
        ModItems.setDefaultModel(ModBlocks.totem_torch);
        ModItems.setDefaultModel(ModBlocks.drum);
        ModItems.setDefaultModel(ModBlocks.wind_chime);
        ModItems.setDefaultModel(ModBlocks.tipi);
        for (WoodVariant woodVariant : WoodVariant.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.totem_base), (int)woodVariant.getID(), (ModelResourceLocation)new ModelResourceLocation(ModBlocks.totem_base.getRegistryName(), "facing=north,wood=" + woodVariant.func_176610_l()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.totem_pole), (int)woodVariant.getID(), (ModelResourceLocation)new ModelResourceLocation(ModBlocks.totem_pole.getRegistryName(), "facing=north,wood=" + woodVariant.func_176610_l()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.wooden_pillar), (int)(2 * woodVariant.getID()), (ModelResourceLocation)new ModelResourceLocation(ModBlocks.wooden_pillar.getRegistryName(), "axis=y,stripped=false,wood=" + woodVariant.func_176610_l()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.wooden_pillar), (int)(2 * woodVariant.getID() + 1), (ModelResourceLocation)new ModelResourceLocation(ModBlocks.wooden_pillar.getRegistryName(), "axis=y,stripped=true,wood=" + woodVariant.func_176610_l()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.wooden_pillar_base), (int)(2 * woodVariant.getID()), (ModelResourceLocation)new ModelResourceLocation(ModBlocks.wooden_pillar_base.getRegistryName(), "facing=up,stripped=false,wood=" + woodVariant.func_176610_l()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)ModBlocks.wooden_pillar_base), (int)(2 * woodVariant.getID() + 1), (ModelResourceLocation)new ModelResourceLocation(ModBlocks.wooden_pillar_base.getRegistryName(), "facing=up,stripped=true,wood=" + woodVariant.func_176610_l()));
        }
        ModItems.setDefaultModel(flute);
        ModItems.setModel(flute, 1, flute.getRegistryName().toString());
        ModItems.setDefaultModel(rattle);
        ModItems.setDefaultModel((Item)jingle_dress);
        ModItems.setDefaultModel(eagle_bone_whistle);
        ModItems.setDefaultModel(totem_whittling_knife);
        ModItems.setDefaultModel(bark_stripper);
        ModItems.setDefaultModel(totemic_staff);
        ModItems.setDefaultModel(totempedia);
        ModItems.setDefaultModel((Item)buffalo_meat);
        ModItems.setDefaultModel((Item)cooked_buffalo_meat);
        ModItems.setDefaultModel((Item)baykok_bow);
        ModItems.setModel(medicine_bag, 0, medicine_bag.getRegistryName().toString() + "_closed");
        ModItems.setModel(medicine_bag, 1, medicine_bag.getRegistryName().toString() + "_open");
        ModItems.setDefaultModel(ceremony_cheat);
        ModItems.setDefaultModel(nether_pipe);
        ModItems.setModel(sub_items, 1, "totemic:" + ItemTotemicItems.Type.iron_bells.toString());
        for (Enum enum_ : ItemBuffaloDrops.Type.values()) {
            ModItems.setModel(buffalo_items, enum_.ordinal(), "totemic:" + ((ItemBuffaloDrops.Type)enum_).toString());
        }
        for (Enum enum_ : ItemEagleDrops.Type.values()) {
            ModItems.setModel(eagle_drops, enum_.ordinal(), "totemic:" + ((ItemEagleDrops.Type)enum_).toString());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void setModel(Item item, int meta, String modelName) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(modelName, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void setDefaultModel(Item item) {
        ModItems.setModel(item, 0, item.getRegistryName().toString());
    }

    @SideOnly(value=Side.CLIENT)
    private static void setDefaultModel(Block block) {
        ModItems.setDefaultModel(Item.func_150898_a((Block)block));
    }
}

