/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.network.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.network.CSynchronizedMessageHandler;
import pokefenn.totemic.tileentity.totem.StateStartup;
import pokefenn.totemic.tileentity.totem.TileTotemBase;

public class PacketCeremonyStartupMusic
implements IMessage {
    private BlockPos pos;
    private MusicInstrument instrument;
    private int amount;

    public PacketCeremonyStartupMusic(BlockPos pos, MusicInstrument instrument, int amount) {
        this.pos = pos;
        this.instrument = instrument;
        this.amount = amount;
    }

    public PacketCeremonyStartupMusic() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.instrument = (MusicInstrument)((ForgeRegistry)TotemicRegistries.instruments()).getValue((int)buf.readByte());
        this.amount = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeByte(((ForgeRegistry)TotemicRegistries.instruments()).getID((IForgeRegistryEntry)this.instrument));
        buf.writeShort(this.amount);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public MusicInstrument getInstrument() {
        return this.instrument;
    }

    public int getAmount() {
        return this.amount;
    }

    public static class Handler
    extends CSynchronizedMessageHandler<PacketCeremonyStartupMusic> {
        @Override
        protected void handleClient(PacketCeremonyStartupMusic msg) {
            TileTotemBase totem;
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(msg.pos);
            if (tile instanceof TileTotemBase && (totem = (TileTotemBase)tile).getState() instanceof StateStartup) {
                ((StateStartup)totem.getState()).handleMusicPacket(msg);
            }
        }
    }
}

