/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.common.block;

import com.google.common.base.Predicate;
import exterminatorjeff.undergroundbiomes.api.enums.SedimentaryVariant;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneStyle;
import exterminatorjeff.undergroundbiomes.common.block.SedimentaryStone;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.arl.block.BlockMetaVariants;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SedimentarySpeleothem
extends SedimentaryStone {
    public static final String internal_name = "sedimentary_speleothem";
    public static PropertyEnum<EnumSize> SIZE = PropertyEnum.func_177709_a((String)"size", EnumSize.class);

    public SedimentarySpeleothem() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SIZE, (Comparable)((Object)EnumSize.small)).func_177226_a(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY, (Comparable)SedimentaryVariant.LIMESTONE));
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIZE, SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((SedimentaryVariant)state.func_177229_b(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY)).getMetadata();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SedimentaryVariant.SEDIMENTARY_VARIANT_PROPERTY, (Comparable)SedimentaryVariant.SEDIMENTARY_VARIANTS[meta & 7]);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumSize size = EnumSize.values()[Math.max(0, this.getBearing(worldIn, pos) - 1)];
        if (this.isCenter(worldIn, pos)) {
            size = EnumSize.medium;
        }
        return state.func_177226_a(SIZE, (Comparable)((Object)size));
    }

    @Override
    public String getInternalName() {
        return internal_name;
    }

    @Override
    public UBStoneStyle getStoneStyle() {
        return UBStoneStyle.SPELEOTHEM;
    }

    @Override
    public Block func_149711_c(float hardness) {
        return super.func_149711_c(hardness);
    }

    @Override
    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return this.getBearing((IBlockAccess)worldIn, pos) > 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        EnumSize size = EnumSize.values()[Math.max(0, this.getBearing((IBlockAccess)worldIn, pos) - 1)];
        worldIn.func_175656_a(pos, state.func_177226_a(SIZE, (Comparable)((Object)size)));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int size = ((EnumSize)((Object)state.func_177229_b(SedimentarySpeleothem.SIZE))).strength;
        if (this.getBearing((IBlockAccess)worldIn, pos) < size + 1) {
            worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)worldIn.func_180495_p(pos)));
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Override
    public void getDrops(NonNullList<ItemStack> stacks, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    private int getBearing(IBlockAccess world, BlockPos pos) {
        return Math.max(this.getStrength(world, pos.func_177977_b()), this.getStrength(world, pos.func_177984_a()));
    }

    private boolean isCenter(IBlockAccess world, BlockPos pos) {
        return this.isThis(world, pos.func_177977_b()) && this.isThis(world, pos.func_177984_a());
    }

    private boolean isThis(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof SedimentarySpeleothem;
    }

    private int getStrength(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().func_149730_j(state)) {
            return 3;
        }
        if (state.func_177227_a().contains(SIZE)) {
            return ((EnumSize)((Object)state.func_177229_b(SedimentarySpeleothem.SIZE))).strength;
        }
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((EnumSize)((Object)state.func_177229_b(SedimentarySpeleothem.SIZE))).aabb;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.func_185496_a(blockState, worldIn, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public static enum EnumSize implements BlockMetaVariants.EnumBase
    {
        small(0, 2),
        medium(1, 4),
        big(2, 8);

        public final int strength;
        public final AxisAlignedBB aabb;

        private EnumSize(int strength, int width) {
            this.strength = strength;
            float pad = (float)((16 - width) / 2) / 16.0f;
            this.aabb = new AxisAlignedBB((double)pad, 0.0, (double)pad, (double)(1.0f - pad), 1.0, (double)(1.0f - pad));
        }

        public String func_176610_l() {
            return this.name();
        }
    }
}

