/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.recipe.ShapelessMekanismRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.lib.recipe.RecipeAttributes;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.common.Util;
import wanion.unidict.recipe.AbstractRecipeResearcher;
import wanion.unidict.resource.UniResourceContainer;

public class MekanismRecipeResearcher
extends AbstractRecipeResearcher<ShapedMekanismRecipe, ShapelessMekanismRecipe> {
    public int getShapedRecipeKey(@Nonnull ShapedMekanismRecipe recipe) {
        TIntList recipeKeys = Util.getList(recipe.func_192400_c().toArray(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    public int getShapelessRecipeKey(@Nonnull ShapelessMekanismRecipe recipe) {
        TIntList recipeKeys = Util.getList(recipe.func_192400_c().toArray(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Nonnull
    public List<Class<? extends ShapedMekanismRecipe>> getShapedRecipeClasses() {
        return Collections.singletonList(ShapedMekanismRecipe.class);
    }

    @Nonnull
    public List<Class<? extends ShapelessMekanismRecipe>> getShapelessRecipeClasses() {
        return Collections.singletonList(ShapelessMekanismRecipe.class);
    }

    public ShapedOreRecipe getNewShapedRecipe(@Nonnull ShapedMekanismRecipe recipe) {
        NonNullList recipeInputs = recipe.func_192400_c();
        int width = recipe.getRecipeWidth();
        int height = recipe.getRecipeHeight();
        int root = Math.max(height, width);
        Object[] newRecipeInputs = new Object[root * root];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Ingredient ingredient;
                Ingredient ingredient2 = ingredient = i < recipeInputs.size() ? (Ingredient)recipeInputs.get(i) : null;
                if (ingredient instanceof OreIngredient) {
                    ItemStack itemStack;
                    UniResourceContainer container;
                    OreIngredient oreIngredient = (OreIngredient)ingredient;
                    ItemStack[] matching = oreIngredient.func_193365_a();
                    newRecipeInputs[y * root + x] = matching.length > 0 && (container = this.resourceHandler.getContainer(itemStack = matching[0])) != null ? (itemStacksOnly ? container.getMainEntry(itemStack) : container.name) : Util.getOreNameFromIngredient(oreIngredient);
                } else if (ingredient != null && ingredient.func_193365_a().length > 0) {
                    ItemStack itemStack = ingredient.func_193365_a()[0];
                    UniResourceContainer container = this.resourceHandler.getContainer(itemStack);
                    newRecipeInputs[y * root + x] = container != null ? (itemStacksOnly ? container.getMainEntry(itemStack) : container.name) : itemStack;
                }
                ++x;
                ++i;
            }
        }
        UniResourceContainer outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        RecipeAttributes newRecipeAttributes = RecipeHelper.rawShapeToShape((Object[])newRecipeInputs);
        return new ShapedMekanismRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_shape." + newRecipeAttributes.shape), outputStack, newRecipeAttributes.actualShape);
    }

    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull ShapelessMekanismRecipe recipe) {
        NonNullList recipeInputs = recipe.func_192400_c();
        Object[] newRecipeInputs = new Object[9];
        for (int i = 0; i < 9; ++i) {
            Ingredient ingredient;
            Ingredient ingredient2 = ingredient = i < recipeInputs.size() ? (Ingredient)recipeInputs.get(i) : null;
            if (ingredient instanceof OreIngredient) {
                ItemStack itemStack;
                UniResourceContainer container;
                OreIngredient oreIngredient = (OreIngredient)ingredient;
                ItemStack[] matching = oreIngredient.func_193365_a();
                if (matching.length > 0 && (container = this.resourceHandler.getContainer(itemStack = matching[0])) != null) {
                    newRecipeInputs[i] = itemStacksOnly ? container.getMainEntry(itemStack) : container.name;
                    continue;
                }
                newRecipeInputs[i] = Util.getOreNameFromIngredient(oreIngredient);
                continue;
            }
            if (ingredient == null || ingredient.func_193365_a().length <= 0) continue;
            ItemStack itemStack = ingredient.func_193365_a()[0];
            UniResourceContainer container = this.resourceHandler.getContainer(itemStack);
            newRecipeInputs[i] = container != null ? (itemStacksOnly ? container.getMainEntry(itemStack) : container.name) : itemStack;
        }
        UniResourceContainer outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        RecipeAttributes newRecipeAttributes = RecipeHelper.rawShapeToShape((Object[])newRecipeInputs);
        return new ShapedMekanismRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_shape." + newRecipeAttributes.shape), outputStack, newRecipeAttributes.actualShape);
    }

    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull ShapelessMekanismRecipe recipe) {
        ArrayList inputs = new ArrayList();
        if (itemStacksOnly) {
            recipe.func_192400_c().forEach(ingredient -> {
                if (ingredient != null && ingredient.func_193365_a().length > 0) {
                    inputs.add(this.resourceHandler.getMainItemStack(ingredient.func_193365_a()[0]));
                }
            });
        } else {
            recipe.func_192400_c().forEach(ingredient -> {
                if (ingredient instanceof OreIngredient) {
                    OreIngredient oreIngredient = (OreIngredient)ingredient;
                    inputs.add(Util.getOreNameFromIngredient(oreIngredient));
                } else if (ingredient != null && ingredient.func_193365_a().length > 0) {
                    ItemStack input = ingredient.func_193365_a()[0];
                    UniResourceContainer container = this.resourceHandler.getContainer(input);
                    inputs.add(container != null ? container.name : input);
                }
            });
        }
        UniResourceContainer outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        return new ShapelessMekanismRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_size." + inputs.size()), outputStack, inputs.toArray());
    }

    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull ShapedMekanismRecipe recipe) {
        UniResourceContainer outputContainer;
        ArrayList<Object> inputs = new ArrayList<Object>();
        if (itemStacksOnly) {
            for (Ingredient ingredient : recipe.func_192400_c()) {
                if (ingredient == null || ingredient.func_193365_a().length <= 0) continue;
                inputs.add(this.resourceHandler.getMainItemStack(ingredient.func_193365_a()[0]));
            }
        } else {
            for (Ingredient ingredient : recipe.func_192400_c()) {
                if (ingredient instanceof OreIngredient) {
                    OreIngredient oreIngredient = (OreIngredient)ingredient;
                    inputs.add(Util.getOreNameFromIngredient(oreIngredient));
                    continue;
                }
                if (ingredient == null || ingredient.func_193365_a().length <= 0) continue;
                ItemStack input = ingredient.func_193365_a()[0];
                UniResourceContainer container = this.resourceHandler.getContainer(input);
                inputs.add(container != null ? container.name : input);
            }
        }
        if ((outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b())) == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        return new ShapelessMekanismRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_size." + inputs.size()), outputStack, inputs.toArray());
    }

    @Override
    public void postProcess() {
    }
}

