/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.handler;

import codechicken.lib.util.ClientUtils;
import codechicken.lib.util.ServerUtils;
import codechicken.wirelessredstone.client.render.RenderWireless;
import codechicken.wirelessredstone.client.render.RenderWirelessBolt;
import codechicken.wirelessredstone.client.texture.TriangTexManager;
import codechicken.wirelessredstone.entity.EntityWirelessTracker;
import codechicken.wirelessredstone.entity.WirelessBolt;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherAddons;
import net.minecraft.client.Minecraft;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WREventHandler {
    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            RedstoneEther.loadClientEther(event.getWorld());
            RedstoneEtherAddons.loadClientManager();
        } else {
            RedstoneEther.loadServerWorld(event.getWorld());
            RedstoneEtherAddons.loadServerWorld();
        }
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        RedstoneEther.loadServerWorld(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        RedstoneEther.unloadServerWorld(event.getWorld());
        if (!ServerUtils.mc().func_71278_l()) {
            RedstoneEther.unloadServer();
            RedstoneEtherAddons.unloadServer();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.getWorld().field_72995_K || RedstoneEther.server() == null) {
            return;
        }
        RedstoneEther.server().saveEther(event.getWorld());
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (RedstoneEther.server() != null) {
            RedstoneEther.loadServerWorld(event.getWorld());
            RedstoneEther.server().verifyChunkTransmitters(event.getWorld(), event.getChunk().field_76635_g, event.getChunk().field_76647_h);
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        Chunk chunk = event.getChunk();
        for (int i = 0; i < chunk.func_177429_s().length; ++i) {
            for (Object o : chunk.func_177429_s()[i]) {
                if (!(o instanceof EntityWirelessTracker)) continue;
                ((EntityWirelessTracker)o).onChunkUnload();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        RenderWirelessBolt.render(event.getPartialTicks(), Minecraft.func_71410_x().func_175606_aa());
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        RedstoneEther.server().resetPlayer(event.player);
        RedstoneEtherAddons.server().onLogin(event.player);
    }

    @SubscribeEvent
    public void playerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        RedstoneEther.server().resetPlayer(event.player);
        RedstoneEtherAddons.server().onDimensionChange(event.player);
    }

    @SubscribeEvent
    public void playerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (RedstoneEther.server() != null) {
            RedstoneEther.server().removePlayer(event.player);
        }
        if (RedstoneEtherAddons.server() != null) {
            RedstoneEtherAddons.server().onLogout(event.player);
        }
    }

    @SubscribeEvent
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        RedstoneEther.server().resetPlayer(event.player);
        RedstoneEtherAddons.server().onLogin(event.player);
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            WirelessBolt.update(WirelessBolt.clientboltlist);
        }
        if (ClientUtils.inWorld()) {
            if (event.phase == TickEvent.Phase.START) {
                TriangTexManager.processAllTextures();
            } else {
                RedstoneEtherAddons.client().tick();
            }
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (RedstoneEtherAddons.server() != null) {
            if (event.phase == TickEvent.Phase.START) {
                WirelessBolt.update(WirelessBolt.serverboltlist);
                RedstoneEtherAddons.server().processTrackers();
            } else {
                RedstoneEtherAddons.server().tickTriangs();
                RedstoneEtherAddons.server().updateREPTimeouts();
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K) {
            if (event.phase == TickEvent.Phase.END) {
                if (RedstoneEther.server() != null) {
                    RedstoneEther.server().tick(event.world);
                }
            } else {
                RedstoneEtherAddons.server().processSMPMaps(event.world);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureLoadPost(TextureStitchEvent.Post event) {
        RenderWireless.postRegisterIcons();
    }
}

