/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.manager;

import codechicken.lib.util.CommonUtils;
import codechicken.lib.util.ServerUtils;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.api.FreqCoord;
import codechicken.wirelessredstone.api.ITileJammer;
import codechicken.wirelessredstone.api.ITileWireless;
import codechicken.wirelessredstone.api.WirelessReceivingDevice;
import codechicken.wirelessredstone.api.WirelessTransmittingDevice;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherFrequency;
import codechicken.wirelessredstone.manager.SaveManager;
import codechicken.wirelessredstone.network.WRServerPH;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneEtherServer
extends RedstoneEther {
    public RedstoneEtherServer() {
        super(false);
    }

    @Override
    public void init(World world) {
        super.init(world);
        SaveManager.resetWorld();
        SaveManager.loadFreqInfo();
        SaveManager.loadDimensionHash();
        this.publicfrequencyend = SaveManager.generalProp.getProperty("PublicFrequencies", 1000);
        this.sharedfrequencyend = SaveManager.generalProp.getProperty("SharedFrequencies", 5000);
        this.numprivatefreqs = SaveManager.generalProp.getProperty("PrivateFrequencies", 50);
    }

    @Override
    protected void addEther(World world, int dimension) {
        if (this.ethers.get(dimension) != null) {
            return;
        }
        super.addEther(world, dimension);
        SaveManager.reloadSave(world);
        SaveManager.getInstance(dimension).loadEther();
    }

    @Override
    public void remEther(World world, int dimension) {
        if (this.ethers.get(dimension) == null) {
            return;
        }
        super.remEther(world, dimension);
        SaveManager.unloadSave(dimension);
    }

    public void saveEther(World world) {
        int dimension = CommonUtils.getDimension((World)world);
        if (!this.ethers.containsKey(dimension)) {
            return;
        }
        for (RedstoneEtherFrequency freq : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).freqsToSave) {
            freq.saveFreq(dimension);
        }
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).freqsToSave.clear();
        SaveManager.getInstance(dimension).removeTrailingSectors();
        SaveManager.saveDimensionHash();
    }

    public void verifyChunkTransmitters(World world, int chunkx, int chunkz) {
        int dimension = CommonUtils.getDimension((World)world);
        RedstoneEther.DimensionalEtherHash ether = (RedstoneEther.DimensionalEtherHash)this.ethers.get(dimension);
        int blockxmin = chunkx * 16;
        int blockxmax = blockxmin + 15;
        int blockzmin = chunkz * 16;
        int blockzmax = blockzmin + 15;
        ArrayList<BlockPos> transmittingblocks = new ArrayList<BlockPos>(ether.transmittingblocks.keySet());
        for (BlockPos node : transmittingblocks) {
            if (node.func_177958_n() < blockxmin || node.func_177958_n() > blockxmax || node.func_177952_p() < blockzmin || node.func_177952_p() > blockzmax) continue;
            TileEntity tile = RedstoneEther.getTile(world, node);
            int freq = ether.transmittingblocks.get((Object)node).freq;
            if (tile instanceof ITileWireless && ((ITileWireless)tile).getFreq() == freq) continue;
            this.remTransmitter(world, node, freq);
            System.out.println("Removed Badly Synced node at:" + node.func_177958_n() + "," + node.func_177956_o() + "," + node.func_177952_p() + " on " + freq + " in dim" + dimension);
        }
    }

    public void setTransmitter(World world, BlockPos node, int freq, boolean on) {
        RedstoneEther.TXNodeInfo info;
        if (freq == 0) {
            return;
        }
        int dimension = CommonUtils.getDimension((World)world);
        if (this.isNodeInAOEofJammer(node, dimension)) {
            this.jamNodeSometime(world, node, dimension, freq);
        }
        if ((info = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks.get(node)) == null) {
            ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks.put(node, new RedstoneEther.TXNodeInfo(freq, on));
        } else {
            info.on = on;
        }
        this.freqarray[freq].setTransmitter(world, node, dimension, on);
    }

    public void remTransmitter(World world, BlockPos node, int freq) {
        if (freq == 0) {
            return;
        }
        int dimension = CommonUtils.getDimension((World)world);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.remove(node);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks.remove(node);
        this.freqarray[freq].remTransmitter(world, node, dimension);
    }

    public void addReceiver(World world, BlockPos node, int freq) {
        if (freq == 0) {
            return;
        }
        int dimension = CommonUtils.getDimension((World)world);
        if (this.isNodeInAOEofJammer(node, dimension)) {
            this.jamNodeSometime(world, node, dimension, freq);
        }
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).recievingblocks.put(node, freq);
        this.freqarray[freq].addReceiver(world, node, dimension);
    }

    public void remReceiver(World world, BlockPos node, int freq) {
        if (freq == 0) {
            return;
        }
        int dimension = CommonUtils.getDimension((World)world);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.remove(node);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).recievingblocks.remove(node);
        this.freqarray[freq].remReceiver(world, node, dimension);
    }

    public void addJammer(World world, BlockPos jammer) {
        int dimension = CommonUtils.getDimension((World)world);
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset.add(jammer);
        this.jamNodesInAOEOfJammer(world, jammer, dimension);
    }

    public void remJammer(World world, BlockPos jammer) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)CommonUtils.getDimension((World)world)))).jammerset.remove(jammer);
    }

    public boolean isNodeJammed(World world, int x, int y, int z) {
        Integer timeout = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)CommonUtils.getDimension((World)world)))).jammednodes.get(new BlockPos(x, y, z));
        return timeout != null && timeout > 0;
    }

    public boolean isNodeInAOEofJammer(BlockPos node, int dimension) {
        for (BlockPos jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            if (RedstoneEtherServer.pythagorasPow2(jammer, node) >= jammerrangePow2) continue;
            return true;
        }
        return false;
    }

    public boolean isPointInAOEofJammer(Vector3 point, int dimension) {
        for (BlockPos jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            if (!(RedstoneEtherServer.pythagorasPow2(jammer, point) < (double)jammerrangePow2)) continue;
            return true;
        }
        return false;
    }

    public BlockPos getClosestJammer(BlockPos node, int dimension) {
        BlockPos closestjammer = null;
        double closestdist = jammerrangePow2;
        for (BlockPos jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            double distance = RedstoneEtherServer.pythagorasPow2(jammer, node);
            if (!(distance < closestdist)) continue;
            closestjammer = jammer;
            closestdist = distance;
        }
        return closestjammer;
    }

    public BlockPos getClosestJammer(Vector3 point, int dimension) {
        BlockPos closestjammer = null;
        double closestdist = jammerrangePow2;
        for (BlockPos jammer : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset) {
            double distance = RedstoneEtherServer.pythagorasPow2(jammer, point);
            if (!(distance < closestdist)) continue;
            closestjammer = jammer;
            closestdist = distance;
        }
        return closestjammer;
    }

    public void jamNodeSometime(World world, BlockPos node, int dimension, int freq) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.put(node, -world.field_73012_v.nextInt(jammerblockwait));
    }

    public void jamEntitySometime(EntityLivingBase entity) {
        this.jammedentities.put(entity, -entity.field_70170_p.field_73012_v.nextInt(jammerentitywait));
    }

    public void jamNode(World world, BlockPos node, int dimension, int freq) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.put(node, RedstoneEtherServer.getRandomTimeout(world.field_73012_v));
        this.freqarray[freq].remTransmitter(world, node, dimension);
        this.freqarray[freq].remReceiver(world, node, dimension);
    }

    public void jamNode(World world, BlockPos pos, int freq) {
        if (freq == 0) {
            return;
        }
        this.jamNode(world, pos, CommonUtils.getDimension((World)world), freq);
    }

    @Override
    public void jamEntity(EntityLivingBase entity, boolean jam) {
        if (jam) {
            this.jammedentities.put(entity, RedstoneEtherServer.getRandomTimeout(entity.field_70170_p.field_73012_v));
        }
        if (entity instanceof EntityPlayer) {
            WRServerPH.sendJamPlayerPacketTo((EntityPlayer)entity, jam);
        }
    }

    public void jamNodesInAOEOfJammer(World world, BlockPos jammer, int dimension) {
        for (int freq = 1; freq <= 5000; ++freq) {
            TreeMap<BlockPos, Boolean> transmittermap = this.freqarray[freq].getTransmitters(dimension);
            for (BlockPos node : transmittermap.keySet()) {
                if (RedstoneEtherServer.pythagorasPow2(node, jammer) >= jammerrangePow2) continue;
                this.jamNodeSometime(world, node, dimension, freq);
            }
            TreeSet<BlockPos> receiverset = this.freqarray[freq].getReceivers(dimension);
            for (BlockPos node : receiverset) {
                if (RedstoneEtherServer.pythagorasPow2(node, jammer) >= jammerrangePow2) continue;
                this.jamNodeSometime(world, node, dimension, freq);
            }
        }
    }

    public void unjamTile(World world, int x, int y, int z) {
        BlockPos node = new BlockPos(x, y, z);
        int dimension = CommonUtils.getDimension((World)world);
        Integer timeout = ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.remove(node);
        if (timeout != null && timeout >= 0) {
            ITileWireless tile = (ITileWireless)RedstoneEtherServer.getTile(world, node);
            tile.unjamTile();
        }
    }

    public void saveJammedFrequencies(String username) {
        String jammedfreqs = this.getJammedFrequencies(username = username.toLowerCase());
        if (jammedfreqs.equals("" + (this.sharedfrequencyend + 1) + "-" + 5000)) {
            SaveManager.generalProp.removeProperty(username + ".jammedFreqs");
        } else {
            SaveManager.generalProp.setProperty(username + ".jammedFreqs", jammedfreqs);
        }
    }

    public void loadJammedFrequencies(String jammedString, String username) {
        String[] freqranges;
        for (String freqrange : freqranges = jammedString.split(",")) {
            int startfreq;
            int endfreq;
            String[] currentrange = freqrange.split("-");
            if (currentrange.length == 1) {
                try {
                    startfreq = endfreq = Integer.parseInt(currentrange[0]);
                }
                catch (NumberFormatException numberformatexception) {
                    continue;
                }
            }
            try {
                startfreq = Integer.parseInt(currentrange[0]);
                endfreq = Integer.parseInt(currentrange[1]);
            }
            catch (NumberFormatException numberformatexception1) {
                continue;
            }
            this.setFrequencyRange(username, startfreq, endfreq, true);
        }
    }

    @Override
    protected void loadJammedFrequencies(String username) {
        String openstring = SaveManager.generalProp.getProperty(username + ".jammedFreqs");
        if (openstring == null) {
            this.jamDefaultRange(username);
        } else {
            this.loadJammedFrequencies(openstring, username);
        }
    }

    public void setFrequencyRangeCommand(String username, int startfreq, int endfreq, boolean flag) {
        this.setFrequencyRange(username, startfreq, endfreq, flag);
        this.saveJammedFrequencies(username);
    }

    public void jamAllFrequencies(String username) {
        this.setFrequencyRange(username, 1, 5000, true);
    }

    public void jamDefaultRange(String username) {
        this.setFrequencyRange(username, 1, 5000, false);
        this.setFrequencyRange(username, this.sharedfrequencyend + 1, 5000, true);
    }

    public void setFreqClean(int freq, int dimension) {
        this.freqarray[freq].setClean(dimension);
    }

    public void resetPlayer(EntityPlayer player) {
        WRServerPH.sendPublicFrequencyTo(player, this.publicfrequencyend);
        WRServerPH.sendSharedFrequencyTo(player, this.sharedfrequencyend);
        String openstring = SaveManager.generalProp.getProperty(player.func_70005_c_() + ".jammedFreqs");
        if (openstring == null) {
            this.jamDefaultRange(player.func_70005_c_());
        } else {
            this.loadJammedFrequencies(openstring, player.func_70005_c_());
        }
        this.sendFreqInfoTo(player);
        this.sendPrivateFreqsTo(player);
    }

    public void removePlayer(EntityPlayer player) {
        this.playerJammedMap.remove(player.func_70005_c_());
    }

    private void sendFreqInfoTo(EntityPlayer player) {
        ArrayList<Integer> freqsWithInfo = new ArrayList<Integer>();
        for (int freq = 1; freq <= 5000; ++freq) {
            if (this.freqarray[freq].getName().equals("") && this.freqarray[freq].getColourId() == -1) continue;
            freqsWithInfo.add(freq);
        }
        WRServerPH.sendFreqInfoTo(player, freqsWithInfo);
    }

    private void sendPrivateFreqsTo(EntityPlayer player) {
        ArrayList<Integer> freqsWithOwners = new ArrayList<Integer>();
        for (int freq = 1; freq <= 5000; ++freq) {
            if (!this.isFreqPrivate(freq)) continue;
            freqsWithOwners.add(freq);
        }
        WRServerPH.sendFreqOwnerTo(player, freqsWithOwners);
    }

    public TreeMap<Integer, Integer> getLoadedFrequencies() {
        TreeMap<Integer, Integer> treemap = new TreeMap<Integer, Integer>();
        for (int freq = 1; freq <= 5000; ++freq) {
            if (this.freqarray[freq].nodeCount() == 0) continue;
            treemap.put(freq, this.freqarray[freq].getActiveTransmitters());
        }
        return treemap;
    }

    public Map<BlockPos, Boolean> getTransmittersOnFreq(int freq, int dimension) {
        return Collections.unmodifiableMap(this.freqarray[freq].getTransmitters(dimension));
    }

    public Collection<BlockPos> getReceiversOnFreq(int freq, int dimension) {
        return Collections.unmodifiableCollection(this.freqarray[freq].getReceivers(dimension));
    }

    public Map<BlockPos, RedstoneEther.TXNodeInfo> getTransmittersInDimension(int dimension) {
        return Collections.unmodifiableMap(((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingblocks);
    }

    public Set<WirelessTransmittingDevice> getTransmittingDevicesInDimension(int dimension) {
        return Collections.unmodifiableSet(((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).transmittingdevices);
    }

    public ArrayList<FreqCoord> getActiveTransmittersOnFreq(int freq, int dimension) {
        ArrayList<FreqCoord> txnodes = new ArrayList<FreqCoord>();
        this.freqarray[freq].putActiveTransmittersInList(dimension, txnodes);
        return txnodes;
    }

    public TreeSet<BlockPos> getJammers(int dimension) {
        return ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammerset;
    }

    public TreeMap<BlockPos, Integer> getJammedNodes(int dimension) {
        return ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes;
    }

    public TreeSet<BlockPos> getNodesInRangeofPoint(int dimension, Vector3 point, float range, boolean includejammed) {
        TreeSet<BlockPos> nodes = new TreeSet<BlockPos>();
        float rangePow2 = range * range;
        for (int freq = 1; freq <= 5000; ++freq) {
            TreeMap<BlockPos, Boolean> transmittermap = this.freqarray[freq].getTransmitters(dimension);
            for (BlockPos node : transmittermap.keySet()) {
                if (!(RedstoneEtherServer.pythagorasPow2(node, point) < (double)rangePow2)) continue;
                nodes.add(node);
            }
            TreeSet<BlockPos> receiverset = this.freqarray[freq].getReceivers(dimension);
            for (BlockPos node : receiverset) {
                if (!(RedstoneEtherServer.pythagorasPow2(node, point) < (double)rangePow2)) continue;
                nodes.add(node);
            }
        }
        if (includejammed) {
            for (BlockPos node : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.keySet()) {
                if (!(RedstoneEtherServer.pythagorasPow2(node, point) < (double)rangePow2)) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public TreeSet<BlockPos> getNodesInRangeofNode(int dimension, BlockPos block, float range, boolean includejammed) {
        TreeSet<BlockPos> nodes = new TreeSet<BlockPos>();
        float rangePow2 = range * range;
        for (int freq = 1; freq <= 5000; ++freq) {
            TreeMap<BlockPos, Boolean> transmittermap = this.freqarray[freq].getTransmitters(dimension);
            for (BlockPos node : transmittermap.keySet()) {
                if (!((float)RedstoneEtherServer.pythagorasPow2(node, block) < rangePow2)) continue;
                nodes.add(node);
            }
            TreeSet<BlockPos> receiverset = this.freqarray[freq].getReceivers(dimension);
            for (BlockPos node : receiverset) {
                if (!((float)RedstoneEtherServer.pythagorasPow2(node, block) < rangePow2)) continue;
                nodes.add(node);
            }
        }
        if (includejammed) {
            for (BlockPos node : ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).jammednodes.keySet()) {
                if (!((float)RedstoneEtherServer.pythagorasPow2(node, block) < rangePow2)) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public void updateReceivingDevices(int freq, boolean on) {
        for (WirelessReceivingDevice receivingdevice : this.receivingdevices) {
            receivingdevice.updateDevice(freq, on);
        }
    }

    public List<WirelessTransmittingDevice> getTransmittingDevicesOnFreq(int freq) {
        return Collections.unmodifiableList(this.freqarray[freq].getTransmittingDevices());
    }

    public void addTransmittingDevice(WirelessTransmittingDevice device) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)device.getDimension()))).transmittingdevices.add(device);
        this.freqarray[device.getFreq()].addTransmittingDevice(device);
    }

    public void removeTransmittingDevice(WirelessTransmittingDevice device) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)device.getDimension()))).transmittingdevices.remove(device);
        this.freqarray[device.getFreq()].removeTransmittingDevice(device);
    }

    public void addReceivingDevice(WirelessReceivingDevice device) {
        this.receivingdevices.add(device);
    }

    public void removeReceivingDevice(WirelessReceivingDevice device) {
        this.receivingdevices.remove(device);
    }

    public void setDimensionTransmitterCount(int freq, int dimension, int count) {
        this.freqarray[freq].setActiveTransmittersInDim(dimension, count);
    }

    public void addFreqToSave(RedstoneEtherFrequency freq, int dimension) {
        ((RedstoneEther.DimensionalEtherHash)this.ethers.get((Object)Integer.valueOf((int)dimension))).freqsToSave.add(freq);
    }

    public void tick(World world) {
        this.updateJammedNodes(world);
        this.randomJamTest(world);
        this.updateJammedEntities(world);
        this.entityJamTest(world);
        this.unloadJammedMap();
    }

    private void unloadJammedMap() {
        Iterator iterator = this.playerJammedMap.keySet().iterator();
        while (iterator.hasNext()) {
            String username = (String)iterator.next();
            if (ServerUtils.getPlayer((String)username) != null) continue;
            this.saveJammedFrequencies(username);
            iterator.remove();
        }
    }

    private void updateJammedNodes(World world) {
        int dimension = CommonUtils.getDimension((World)world);
        RedstoneEther.DimensionalEtherHash e = (RedstoneEther.DimensionalEtherHash)this.ethers.get(dimension);
        if (e != null) {
            Iterator<BlockPos> iterator = e.jammednodes.keySet().iterator();
            while (iterator.hasNext()) {
                BlockPos node = iterator.next();
                int inactivetime = e.jammednodes.get(node);
                if (--inactivetime == 0 || inactivetime < 0 && inactivetime % jammerrandom == 0) {
                    ITileJammer jammertile;
                    ITileWireless tile = (ITileWireless)RedstoneEtherServer.getTile(world, node);
                    if (tile == null) {
                        iterator.remove();
                        continue;
                    }
                    BlockPos jammer = this.getClosestJammer(node, dimension);
                    ITileJammer iTileJammer = jammertile = jammer == null ? null : (ITileJammer)RedstoneEtherServer.getTile(world, jammer);
                    if (jammertile == null) {
                        iterator.remove();
                        tile.unjamTile();
                        continue;
                    }
                    jammertile.jamTile(tile);
                }
                if (inactivetime == 0) {
                    inactivetime = jammertimeout;
                }
                e.jammednodes.put(node, inactivetime);
            }
        }
    }

    private void randomJamTest(World world) {
        if (world.func_82737_E() % 600L != 0L) {
            return;
        }
        for (Map.Entry entry : this.ethers.entrySet()) {
            if (((RedstoneEther.DimensionalEtherHash)entry.getValue()).jammerset == null) continue;
            for (BlockPos blockPos : ((RedstoneEther.DimensionalEtherHash)entry.getValue()).jammerset) {
                this.jamNodesInAOEOfJammer(world, blockPos, (Integer)entry.getKey());
            }
        }
    }

    private void updateJammedEntities(World world) {
        int dimension = CommonUtils.getDimension((World)world);
        Iterator iterator = this.jammedentities.keySet().iterator();
        while (iterator.hasNext()) {
            EntityLivingBase entity = (EntityLivingBase)iterator.next();
            int inactivetime = (Integer)this.jammedentities.get(entity);
            --inactivetime;
            if (entity == null || entity.field_70128_L) {
                iterator.remove();
                continue;
            }
            if (inactivetime == 0 || inactivetime < 0 && inactivetime % jammerentitywait == 0 || inactivetime > 0 && inactivetime % jammerentityretry == 0) {
                ITileJammer jammertile;
                BlockPos jammer = this.getClosestJammer(Vector3.fromEntity((Entity)entity), dimension);
                ITileJammer iTileJammer = jammertile = jammer == null ? null : (ITileJammer)RedstoneEtherServer.getTile(world, jammer);
                if (jammertile == null) {
                    if (inactivetime <= 0) {
                        iterator.remove();
                        this.jamEntity(entity, false);
                        continue;
                    }
                } else {
                    jammertile.jamEntity((Entity)entity);
                }
            }
            if (inactivetime == 0) {
                inactivetime = jammertimeout;
            }
            this.jammedentities.put(entity, inactivetime);
        }
    }

    private void entityJamTest(World world) {
        if (world.func_82737_E() % 10L != 0L) {
            return;
        }
        int dimension = CommonUtils.getDimension((World)world);
        RedstoneEther.DimensionalEtherHash e = (RedstoneEther.DimensionalEtherHash)this.ethers.get(dimension);
        if (e != null) {
            for (BlockPos jammer : e.jammerset) {
                List entitiesinrange = world.func_72839_b(null, new AxisAlignedBB((double)jammer.func_177958_n() - 9.5, (double)jammer.func_177956_o() - 9.5, (double)jammer.func_177952_p() - 9.5, (double)jammer.func_177958_n() + 10.5, (double)jammer.func_177956_o() + 10.5, (double)jammer.func_177952_p() + 10.5));
                for (Entity entity : entitiesinrange) {
                    if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer && this.isPlayerJammed((EntityPlayer)entity)) continue;
                    this.jamEntitySometime((EntityLivingBase)entity);
                }
            }
        }
    }

    public void unload() {
        SaveManager.unloadAll();
    }

    @Override
    public void setFreq(ITileWireless tile, int freq) {
        tile.setFreq(freq);
    }
}

