/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wft.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.wft.api.IWirelessFluidTerminalItem;
import p455w0rd.wft.api.WFTApi;
import p455w0rd.wft.container.ContainerWFT;
import p455w0rd.wft.init.ModKeybindings;
import p455w0rdslib.LibGlobals;

public class WFTUtils {
    public static final String INFINITY_ENERGY_NBT = "InfinityEnergy";
    public static final String BOOSTER_SLOT_NBT = "BoosterSlot";
    public static final String IN_RANGE_NBT = "IsInRange";
    public static final String AUTOCONSUME_BOOSTER_NBT = "AutoConsumeBoosters";

    public static NonNullList<ItemStack> getFluidTerminals(EntityPlayer player) {
        NonNullList terminalList = NonNullList.func_191196_a();
        InventoryPlayer playerInventory = player.field_71071_by;
        for (ItemStack fluidTerm : playerInventory.field_70462_a) {
            if (!WFTUtils.isAnyWFT(fluidTerm)) continue;
            terminalList.add((Object)fluidTerm);
        }
        if (LibGlobals.Mods.BAUBLES.isLoaded()) {
            Set pairSet = WTApi.instance().getBaublesUtility().getAllWTBaublesByType(player, IWirelessFluidTerminalItem.class);
            for (Pair pair : pairSet) {
                terminalList.add(pair.getRight());
            }
        }
        return terminalList;
    }

    @Nonnull
    public static ItemStack getFluidTerm(InventoryPlayer playerInv) {
        ArrayList baubleList;
        if (!playerInv.field_70458_d.func_184614_ca().func_190926_b() && (playerInv.field_70458_d.func_184614_ca().func_77973_b() instanceof IWirelessFluidTerminalItem || WTApi.instance().getWUTUtility().doesWUTSupportType(playerInv.field_70458_d.func_184614_ca(), IWirelessFluidTerminalItem.class))) {
            return playerInv.field_70458_d.func_184614_ca();
        }
        ItemStack fluidTerm = ItemStack.field_190927_a;
        if (LibGlobals.Mods.BAUBLES.isLoaded() && (baubleList = Lists.newArrayList((Iterable)WTApi.instance().getBaublesUtility().getAllWTBaublesByType(playerInv.field_70458_d, IWirelessFluidTerminalItem.class))).size() > 0) {
            fluidTerm = (ItemStack)((Pair)baubleList.get(0)).getRight();
        }
        if (fluidTerm.func_190926_b()) {
            int invSize = playerInv.func_70302_i_();
            if (invSize <= 0) {
                return ItemStack.field_190927_a;
            }
            for (int i = 0; i < invSize; ++i) {
                ItemStack item = playerInv.func_70301_a(i);
                if (item.func_190926_b() || !(item.func_77973_b() instanceof IWirelessFluidTerminalItem) && !WTApi.instance().getWUTUtility().doesWUTSupportType(item, IWirelessFluidTerminalItem.class)) continue;
                fluidTerm = item;
                break;
            }
        }
        return fluidTerm;
    }

    public static ItemStack getWFTBySlot(EntityPlayer player, int slot) {
        if (slot >= 0) {
            return WTApi.instance().getWTBySlot(player, slot, IWirelessFluidTerminalItem.class);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static Pair<Boolean, Pair<Integer, ItemStack>> getFirstWirelessFluidTerminal(InventoryPlayer playerInv) {
        boolean isBauble = false;
        int slotID = -1;
        ItemStack wirelessTerm = ItemStack.field_190927_a;
        if (!playerInv.field_70458_d.func_184614_ca().func_190926_b() && (playerInv.field_70458_d.func_184614_ca().func_77973_b() instanceof IWirelessFluidTerminalItem || WTApi.instance().getWUTUtility().doesWUTSupportType(playerInv.field_70458_d.func_184614_ca(), IWirelessFluidTerminalItem.class))) {
            slotID = playerInv.field_70461_c;
            wirelessTerm = playerInv.field_70458_d.func_184614_ca();
        } else {
            int invSize;
            Pair bauble;
            if (LibGlobals.Mods.BAUBLES.isLoaded() && !((ItemStack)(bauble = WTApi.instance().getBaublesUtility().getFirstWTBaubleByType(playerInv.field_70458_d, IWirelessFluidTerminalItem.class)).getRight()).func_190926_b()) {
                wirelessTerm = (ItemStack)bauble.getRight();
                slotID = (Integer)bauble.getLeft();
                if (!wirelessTerm.func_190926_b()) {
                    isBauble = true;
                }
            }
            if (wirelessTerm.func_190926_b() && (invSize = playerInv.func_70302_i_()) > 0) {
                for (int i = 0; i < invSize; ++i) {
                    ItemStack item = playerInv.func_70301_a(i);
                    if (item.func_190926_b() || !(item.func_77973_b() instanceof IWirelessFluidTerminalItem) && !WTApi.instance().getWUTUtility().doesWUTSupportType(item, IWirelessFluidTerminalItem.class)) continue;
                    wirelessTerm = item;
                    slotID = i;
                    break;
                }
            }
        }
        return Pair.of((Object)isBauble, (Object)Pair.of((Object)slotID, (Object)wirelessTerm));
    }

    public static boolean isAnyWFT(@Nonnull ItemStack fluidTerm) {
        return fluidTerm.func_77973_b() instanceof IWirelessFluidTerminalItem || WTApi.instance().getWUTUtility().doesWUTSupportType(fluidTerm, IWirelessFluidTerminalItem.class);
    }

    public static boolean isWFTCreative(ItemStack fluidTerm) {
        return !fluidTerm.func_190926_b() && ((ICustomWirelessTerminalItem)fluidTerm.func_77973_b()).isCreative();
    }

    @SideOnly(value=Side.CLIENT)
    public static String color(String color) {
        switch (color) {
            case "white": {
                return TextFormatting.WHITE.toString();
            }
            case "black": {
                return TextFormatting.BLACK.toString();
            }
            case "green": {
                return TextFormatting.GREEN.toString();
            }
            case "red": {
                return TextFormatting.RED.toString();
            }
            case "yellow": {
                return TextFormatting.YELLOW.toString();
            }
            case "aqua": {
                return TextFormatting.AQUA.toString();
            }
            case "blue": {
                return TextFormatting.BLUE.toString();
            }
            case "italics": {
                return TextFormatting.ITALIC.toString();
            }
            case "bold": {
                return TextFormatting.BOLD.toString();
            }
        }
        return TextFormatting.GRAY.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer player() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static EntityPlayer player(InventoryPlayer playerInv) {
        return playerInv.field_70458_d;
    }

    @SideOnly(value=Side.CLIENT)
    public static World world() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static World world(EntityPlayer player) {
        return player.func_130014_f_();
    }

    public static void chatMessage(EntityPlayer player, ITextComponent message) {
        player.func_145747_a(message);
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleKeybind() {
        EntityPlayer p = WFTUtils.player();
        if (p.field_71070_bA == null) {
            return;
        }
        if (ModKeybindings.openFluidTerminal.func_151463_i() != 0 && ModKeybindings.openFluidTerminal.func_151468_f()) {
            ItemStack is = WFTUtils.getFluidTerm(p.field_71071_by);
            if (is.func_190926_b()) {
                return;
            }
            ICustomWirelessTerminalItem fluidTerm = (ICustomWirelessTerminalItem)is.func_77973_b();
            if (fluidTerm != null) {
                if (!(p.field_71070_bA instanceof ContainerWFT)) {
                    Pair<Boolean, Pair<Integer, ItemStack>> wftPair = WFTUtils.getFirstWirelessFluidTerminal(p.field_71071_by);
                    WFTApi.instance().openWFTGui(p, (Boolean)wftPair.getLeft(), (Integer)((Pair)wftPair.getRight()).getLeft());
                } else {
                    p.func_71053_j();
                }
            }
        }
    }
}

