/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.world.storage.loot.functions;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.moa.AetherMoaType;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class SetMoaType
extends LootFunction {
    private final ResourceLocation moaTypeId;

    protected SetMoaType(ResourceLocation moaTypeIdIn, LootCondition[] conditionsIn) {
        super(conditionsIn);
        this.moaTypeId = moaTypeIdIn;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        int typeId = this.getMoaTypeId();
        if (typeId == -1) {
            return stack;
        }
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
        }
        nbttagcompound.func_74768_a("typeId", typeId);
        stack.func_77982_d(nbttagcompound);
        return stack;
    }

    private int getMoaTypeId() {
        AetherMoaType type = AetherAPI.getInstance().getMoaType(this.moaTypeId);
        if (type == null) {
            return -1;
        }
        return AetherAPI.getInstance().getMoaTypeId(type);
    }

    public static class Serializer
    extends LootFunction.Serializer<SetMoaType> {
        protected Serializer() {
            super(Aether.locate("set_moa_type"), SetMoaType.class);
        }

        public void serialize(JsonObject object, SetMoaType function, JsonSerializationContext serializationContext) {
            object.addProperty("moa_type", function.moaTypeId.toString());
        }

        public SetMoaType deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            String type = JsonUtils.func_151200_h((JsonObject)object, (String)"moa_type");
            if (type.indexOf(58) == -1) {
                return new SetMoaType(Aether.locate(type), conditionsIn);
            }
            return new SetMoaType(new ResourceLocation(type), conditionsIn);
        }
    }
}

