/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.plant;

import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.misc.IAgriRegisterable;
import com.infinityraider.agricraft.api.v1.render.RenderMethod;
import com.infinityraider.agricraft.api.v1.requirement.IGrowthRequirement;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.util.FuzzyStack;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IAgriPlant
extends IAgriRegisterable {
    @Override
    @Nonnull
    public String getId();

    @Nonnull
    public String getPlantName();

    @Nonnull
    public String getSeedName();

    @Nonnull
    public Collection<FuzzyStack> getSeedItems();

    public boolean isWeed();

    default public boolean isAggressive() {
        return false;
    }

    public boolean isFertilizable();

    public double getSpreadChance();

    public double getSpawnChance();

    public double getGrowthChanceBase();

    public double getGrowthChanceBonus();

    public double getSeedDropChanceBase();

    public double getSeedDropChanceBonus();

    public double getGrassDropChance();

    public int getGrowthStages();

    public int getTier();

    @Nonnull
    public String getInformation();

    @Nonnull
    public ItemStack getSeed();

    @Nonnull
    public IGrowthRequirement getGrowthRequirement();

    public void getPossibleProducts(@Nonnull Consumer<ItemStack> var1);

    public void getHarvestProducts(@Nonnull Consumer<ItemStack> var1, @Nonnull IAgriCrop var2, @Nonnull IAgriStat var3, @Nonnull Random var4);

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSeedTexture();

    public float getHeight(int var1);

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public RenderMethod getRenderMethod();

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getPrimaryPlantTexture(int var1);

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSecondaryPlantTexture(int var1);

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getPlantQuads(IExtendedBlockState var1, int var2, EnumFacing var3, Function<ResourceLocation, TextureAtlasSprite> var4);

    public boolean equals(@Nullable Object var1);

    public int hashCode();
}

