/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.decoration;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityGrate
extends TileEntityCustomWood
implements IDebuggable {
    private static final double WIDTH = 0.125;
    private static final double LENGTH = 1.0;
    @Nonnull
    private EnumFacing.Axis axis = EnumFacing.Axis.X;
    @Nonnull
    private EnumOffset offset = EnumOffset.NEAR;
    @Nonnull
    private EnumVines vines = EnumVines.NONE;

    public boolean hasVines(boolean front) {
        return this.vines.hasVines(front);
    }

    @Nonnull
    public EnumFacing.Axis getAxis() {
        return this.axis;
    }

    @Nonnull
    public EnumOffset getOffset() {
        return this.offset;
    }

    @Nonnull
    public EnumVines getVines() {
        return this.vines;
    }

    @Nonnull
    public AxisAlignedBB getBounds() {
        return this.offset.getBounds(this.axis);
    }

    public void setAxis(@Nonnull EnumFacing.Axis axis) {
        Preconditions.checkNotNull((Object)axis);
        if (this.axis != axis) {
            this.axis = axis;
            this.markForUpdate();
        }
    }

    public void setOffset(@Nonnull EnumOffset offset) {
        Preconditions.checkNotNull((Object)((Object)offset));
        if (this.offset != offset) {
            this.offset = offset;
            this.markForUpdate();
        }
    }

    public boolean setVines(@Nonnull EnumVines vines) {
        Preconditions.checkNotNull((Object)((Object)vines));
        if (this.vines != vines) {
            this.vines = vines;
            this.markForUpdate();
            return true;
        }
        return false;
    }

    public boolean addVines(boolean front) {
        return this.setVines(this.vines.addVines(front));
    }

    public boolean removeVines(boolean front) {
        return this.setVines(this.vines.removeVines(front));
    }

    public boolean isPlayerInFront(EntityPlayer player) {
        return player != null && this.axis == player.func_174811_aO().func_176740_k() && player.func_174811_aO().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
    }

    @Override
    protected void writeNBT(NBTTagCompound tag) {
        tag.func_74777_a("agri_meta", (short)this.offset.ordinal());
        tag.func_74777_a("agri_vine", (short)this.vines.ordinal());
        tag.func_74777_a("agri_axis", (short)this.axis.ordinal());
    }

    @Override
    protected void readNBT(NBTTagCompound tag) {
        this.offset = EnumOffset.values()[tag.func_74765_d("agri_meta") % EnumOffset.values().length];
        this.vines = EnumVines.values()[tag.func_74765_d("agri_vine") % EnumVines.values().length];
        this.axis = EnumFacing.Axis.values()[tag.func_74765_d("agri_axis") % EnumFacing.Axis.values().length];
    }

    @Override
    public void addServerDebugInfo(Consumer<String> consumer) {
        consumer.accept("Grate:");
        super.addServerDebugInfo(consumer);
        consumer.accept(" - Offset: " + (Object)((Object)this.offset));
        consumer.accept(" - Axis  : " + this.axis);
        consumer.accept(" - Bounds: ");
        consumer.accept("   - x: " + this.getBounds().field_72340_a + " - " + this.getBounds().field_72336_d);
        consumer.accept("   - y: " + this.getBounds().field_72338_b + " - " + this.getBounds().field_72337_e);
        consumer.accept("   - z: " + this.getBounds().field_72339_c + " - " + this.getBounds().field_72334_f);
    }

    public static enum EnumOffset implements IStringSerializable
    {
        NEAR(0.0f),
        CENTER(0.4375f),
        FAR(0.875f);

        private final float offset;
        private final AxisAlignedBB boundsX;
        private final AxisAlignedBB boundsY;
        private final AxisAlignedBB boundsZ;

        private EnumOffset(float offset) {
            this.offset = offset;
            this.boundsX = new AxisAlignedBB((double)offset, 0.0, 0.0, 0.125 + (double)offset, 1.0, 1.0);
            this.boundsY = new AxisAlignedBB(0.0, (double)offset, 0.0, 1.0, 0.125 + (double)offset, 1.0);
            this.boundsZ = new AxisAlignedBB(0.0, 0.0, (double)offset, 1.0, 1.0, 0.125 + (double)offset);
        }

        public float getOffset() {
            return this.offset;
        }

        @Nonnull
        public AxisAlignedBB getBounds(@Nonnull EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return this.boundsX;
                }
                case Y: {
                    return this.boundsY;
                }
                case Z: {
                    return this.boundsZ;
                }
            }
            throw new NullPointerException();
        }

        @Nonnull
        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }

    public static enum EnumVines implements IStringSerializable
    {
        NONE(false, false),
        FRONT(true, true),
        BACK(true, false),
        BOTH(true, true);

        private final boolean vines;
        private final boolean front;

        private EnumVines(boolean hasVines, boolean front) {
            this.vines = hasVines;
            this.front = front;
        }

        public boolean hasVines(boolean front) {
            return this.vines && this.front == front;
        }

        public EnumVines addVines(boolean front) {
            switch (this) {
                case NONE: {
                    return front ? FRONT : BACK;
                }
                case FRONT: {
                    return front ? FRONT : BOTH;
                }
                case BACK: {
                    return front ? BOTH : BACK;
                }
                case BOTH: {
                    return BOTH;
                }
            }
            throw new AssertionError();
        }

        public EnumVines removeVines(boolean front) {
            switch (this) {
                case NONE: {
                    return NONE;
                }
                case FRONT: {
                    return front ? NONE : FRONT;
                }
                case BACK: {
                    return front ? BACK : NONE;
                }
                case BOTH: {
                    return front ? BACK : FRONT;
                }
            }
            throw new AssertionError();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

