/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.auxiliary.link;

import hellfirepvp.astralsorcery.common.auxiliary.link.ILinkableTile;
import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LinkHandler
implements ITickHandler {
    private static Map<EntityPlayer, LinkSession> players = new HashMap<EntityPlayer, LinkSession>();

    @Nonnull
    public static RightClickResult onRightClick(EntityPlayer clicked, World world, BlockPos pos, boolean sneak) {
        if (!players.containsKey(clicked)) {
            TileEntity te = world.func_175625_s(pos);
            if (te == null || !(te instanceof ILinkableTile)) {
                return new RightClickResult(RightClickResultType.NONE, null);
            }
            ILinkableTile tile = (ILinkableTile)te;
            players.put(clicked, new LinkSession(tile));
            return new RightClickResult(RightClickResultType.SELECT, tile);
        }
        LinkSession l = players.get(clicked);
        if (sneak) {
            return new RightClickResult(RightClickResultType.TRY_UNLINK, l.selected);
        }
        return new RightClickResult(RightClickResultType.TRY_LINK, l.selected);
    }

    public static void propagateClick(RightClickResult result, EntityPlayer playerIn, World worldIn, BlockPos pos) {
        ILinkableTile tile = result.getInteracted();
        Style green = new Style().func_150238_a(TextFormatting.GREEN);
        switch (result.getType()) {
            case SELECT: {
                String name = tile.getUnLocalizedDisplayName();
                if (!tile.onSelect(playerIn) || name == null) break;
                playerIn.func_145747_a(new TextComponentTranslation("misc.link.start", new Object[]{new TextComponentTranslation(name, new Object[0])}).func_150255_a(green));
                break;
            }
            case TRY_LINK: {
                String linkedFrom;
                String unloc;
                TileEntity te = worldIn.func_175625_s(pos);
                if (te != null && te instanceof ILinkableTile && !((ILinkableTile)te).doesAcceptLinks()) {
                    return;
                }
                if (!tile.tryLink(playerIn, pos)) break;
                tile.onLinkCreate(playerIn, pos);
                String linkedTo = "misc.link.link.block";
                if (te != null && te instanceof ILinkableTile && (unloc = ((ILinkableTile)te).getUnLocalizedDisplayName()) != null) {
                    linkedTo = unloc;
                }
                if ((linkedFrom = tile.getUnLocalizedDisplayName()) == null) break;
                playerIn.func_145747_a(new TextComponentTranslation("misc.link.link", new Object[]{new TextComponentTranslation(linkedFrom, new Object[0]), new TextComponentTranslation(linkedTo, new Object[0])}).func_150255_a(green));
                break;
            }
            case TRY_UNLINK: {
                String linkedFrom;
                String unloc;
                if (!tile.tryUnlink(playerIn, pos)) break;
                String linkedTo = "misc.link.link.block";
                TileEntity te = worldIn.func_175625_s(pos);
                if (te != null && te instanceof ILinkableTile && (unloc = ((ILinkableTile)te).getUnLocalizedDisplayName()) != null) {
                    linkedTo = unloc;
                }
                if ((linkedFrom = tile.getUnLocalizedDisplayName()) == null) break;
                playerIn.func_145747_a(new TextComponentTranslation("misc.link.unlink", new Object[]{new TextComponentTranslation(linkedFrom, new Object[0]), new TextComponentTranslation(linkedTo, new Object[0])}).func_150255_a(green));
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        Iterator<EntityPlayer> iterator = players.keySet().iterator();
        while (iterator.hasNext()) {
            int dimId;
            EntityPlayer pl = iterator.next();
            LinkSession session = players.get(pl);
            boolean needsRemoval = true;
            ItemStack inhand = pl.func_184614_ca();
            if (!inhand.func_190926_b() && inhand.func_77973_b() instanceof IItemLinkingTool) {
                needsRemoval = false;
            }
            if (!(inhand = pl.func_184592_cb()).func_190926_b() && inhand.func_77973_b() instanceof IItemLinkingTool) {
                needsRemoval = false;
            }
            if ((dimId = ((LinkSession)session).selected.getLinkWorld().field_73011_w.getDimension()) != pl.field_71093_bK) {
                needsRemoval = true;
            }
            if (!needsRemoval) continue;
            iterator.remove();
            pl.func_145747_a(new TextComponentTranslation("misc.link.stop", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "LinkHandler";
    }

    public static interface IItemLinkingTool {
    }

    public static enum RightClickResultType {
        SELECT,
        TRY_LINK,
        TRY_UNLINK,
        NONE;

    }

    public static class RightClickResult {
        private final RightClickResultType type;
        private final ILinkableTile interacted;

        public RightClickResult(RightClickResultType type, ILinkableTile interacted) {
            this.type = type;
            this.interacted = interacted;
        }

        public RightClickResultType getType() {
            return this.type;
        }

        public ILinkableTile getInteracted() {
            return this.interacted;
        }
    }

    public static class LinkSession {
        private final ILinkableTile selected;

        public LinkSession(ILinkableTile selected) {
            this.selected = selected;
        }
    }
}

