/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.item.tool.ItemChargedCrystalPickaxe;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PktOreScan
implements IMessage,
IMessageHandler<PktOreScan, IMessage> {
    private Collection<BlockPos> positions = Lists.newArrayList();
    private boolean tumble = false;

    public PktOreScan() {
    }

    public PktOreScan(Collection<BlockPos> positions, boolean doTumble) {
        this.positions = positions;
        this.tumble = doTumble;
    }

    public void fromBytes(ByteBuf buf) {
        this.tumble = buf.readBoolean();
        int size = buf.readInt();
        this.positions = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            this.positions.add(ByteBufUtils.readPos(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.tumble);
        buf.writeInt(this.positions.size());
        for (BlockPos pos : this.positions) {
            ByteBufUtils.writePos(buf, pos);
        }
    }

    public IMessage onMessage(PktOreScan message, MessageContext ctx) {
        this.playEffect(message);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffect(PktOreScan message) {
        AstralSorcery.proxy.scheduleClientside(() -> ItemChargedCrystalPickaxe.playClientEffects(message.positions, message.tumble));
    }
}

