/*
 * Decompiled with CFR 0.152.
 */
package com.teamacronymcoders.base.json.deserializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLongArray;

public class NBTDeserializer
implements JsonDeserializer<NBTTagCompound> {
    public NBTTagCompound deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            return this.parseObject(json.getAsJsonObject());
        }
        throw new JsonParseException("NBT is required to be an object");
    }

    private NBTTagCompound parseObject(JsonObject json) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        for (Map.Entry property : json.entrySet()) {
            String name = (String)property.getKey();
            JsonElement jsonElement = (JsonElement)property.getValue();
            if (jsonElement.isJsonObject()) {
                tagCompound.func_74782_a(name, (NBTBase)this.parseObject(json));
                continue;
            }
            if (json.isJsonArray()) {
                this.handleJsonArray(tagCompound, name, jsonElement.getAsJsonArray());
                continue;
            }
            if (!json.isJsonPrimitive()) continue;
            this.handleJsonPrimitive(tagCompound, name, jsonElement.getAsJsonPrimitive());
        }
        return tagCompound;
    }

    private void handleJsonPrimitive(NBTTagCompound tagCompound, String propertyName, JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isBoolean()) {
            tagCompound.func_74757_a(propertyName, jsonPrimitive.getAsBoolean());
        } else if (jsonPrimitive.isString()) {
            tagCompound.func_74778_a(propertyName, jsonPrimitive.getAsString());
        } else if (jsonPrimitive.isNumber()) {
            Number number = jsonPrimitive.getAsNumber();
            if (number instanceof Long) {
                tagCompound.func_74772_a(propertyName, number.longValue());
            } else if (number instanceof Integer) {
                tagCompound.func_74768_a(propertyName, number.intValue());
            } else if (number instanceof Short) {
                tagCompound.func_74777_a(propertyName, number.shortValue());
            } else if (number instanceof Double) {
                tagCompound.func_74780_a(propertyName, number.doubleValue());
            } else if (number instanceof Byte) {
                tagCompound.func_74774_a(propertyName, number.byteValue());
            } else if (number instanceof Float) {
                tagCompound.func_74776_a(propertyName, number.floatValue());
            }
        }
    }

    private void handleJsonArray(NBTTagCompound tagCompound, String propertyName, JsonArray jsonArray) {
        boolean allLongs = true;
        boolean allInts = true;
        boolean allBytes = true;
        for (JsonElement element : jsonArray) {
            if (!element.isJsonPrimitive()) {
                throw new JsonParseException("Only Longs, Ints, and Bytes are supported in NBT Arrays");
            }
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                Number number = primitive.getAsNumber();
                if (number instanceof Byte) {
                    allLongs = false;
                    allInts = false;
                    continue;
                }
                if (number instanceof Integer) {
                    allLongs = false;
                    allBytes = false;
                    continue;
                }
                if (number instanceof Long) {
                    allInts = false;
                    allBytes = false;
                    continue;
                }
                throw new JsonParseException("Only Longs, Ints, and Bytes are supported in NBT Arrays");
            }
            throw new JsonParseException("Only Longs, Ints, and Bytes are supported in NBT Arrays");
        }
        if (allLongs) {
            this.handleJsonLongArray(tagCompound, propertyName, jsonArray);
        } else if (allInts) {
            this.handleJsonIntArray(tagCompound, propertyName, jsonArray);
        } else if (allBytes) {
            this.handleJsonByteArray(tagCompound, propertyName, jsonArray);
        } else {
            throw new JsonParseException("NBT Arrays must all be the Same Type");
        }
    }

    private void handleJsonByteArray(NBTTagCompound tagCompound, String propertyName, JsonArray jsonArray) {
        byte[] byteArray = new byte[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            byteArray[i] = jsonArray.get(i).getAsJsonPrimitive().getAsByte();
        }
        tagCompound.func_74773_a(propertyName, byteArray);
    }

    private void handleJsonIntArray(NBTTagCompound tagCompound, String propertyName, JsonArray jsonArray) {
        int[] intArray = new int[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            intArray[i] = jsonArray.get(i).getAsJsonPrimitive().getAsInt();
        }
        tagCompound.func_74783_a(propertyName, intArray);
    }

    private void handleJsonLongArray(NBTTagCompound tagCompound, String propertyName, JsonArray jsonArray) {
        long[] longArray = new long[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            longArray[i] = jsonArray.get(i).getAsJsonPrimitive().getAsLong();
        }
        tagCompound.func_74782_a(propertyName, (NBTBase)new NBTTagLongArray(longArray));
    }
}

