/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.registry.entity;

import com.bewitchment.Bewitchment;
import com.bewitchment.api.capability.magicpower.MagicPower;
import com.bewitchment.api.message.SyncBroom;
import java.lang.reflect.Field;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public abstract class EntityBroom
extends Entity {
    private static final Field jumping = ReflectionHelper.findField(EntityLivingBase.class, (String)"isJumping", (String)"field_70703_bu");
    public ItemStack item;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean canFly = true;

    public EntityBroom(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.7f);
        this.func_189654_d(true);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        this.tickLerp();
        Entity rider = this.func_184179_bs();
        if (rider instanceof EntityPlayer) {
            this.field_70177_z = rider.field_70177_z;
            boolean jump = false;
            try {
                jump = jumping.getBoolean(rider);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (this.field_70170_p.func_82737_E() % 20L == 0L && (!this.field_70122_E || jump)) {
                this.canFly = MagicPower.attemptDrain(null, (EntityPlayer)rider, this.getMagicCost());
            }
            if (this.canFly && jump && this.field_70181_x < 1.0) {
                this.field_70181_x += (double)(0.1f + this.getThrust());
            }
            this.field_70159_w += rider.field_70159_w * (double)this.getSpeed();
            this.field_70179_y += rider.field_70179_y * (double)this.getSpeed();
        }
        float friction = 0.98f;
        if (this.field_70122_E) {
            friction = 0.4f;
        }
        this.field_70159_w *= (double)friction;
        this.field_70179_y *= (double)friction;
        if (this.field_70123_F) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
        }
        this.field_70181_x -= (double)0.1f;
        this.field_70181_x *= 0.75;
        this.field_70159_w = MathHelper.func_151237_a((double)this.field_70159_w, (double)(-this.getMaxSpeed()), (double)this.getMaxSpeed());
        this.field_70179_y = MathHelper.func_151237_a((double)this.field_70179_y, (double)(-this.getMaxSpeed()), (double)this.getMaxSpeed());
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70018_K();
        for (EntityPlayer player : this.field_70170_p.field_73010_i) {
            if (this.field_70170_p.field_72995_K || !(player instanceof EntityPlayerMP) || player == this.func_184179_bs()) continue;
            Bewitchment.network.sendTo((IMessage)new SyncBroom(this), (EntityPlayerMP)player);
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
            this.field_70125_A = (float)this.lerpPitch;
        }
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double newX = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double newY = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double newZ = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double deltaYaw = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + deltaYaw / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(newX, newY, newZ);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    protected void func_184231_a(double y, boolean onGround, IBlockState state, BlockPos pos) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() != null && this.func_184179_bs() == null) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)this.item.func_77946_l());
            }
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return this.func_70067_L();
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.item = tag.func_74764_b("item") ? new ItemStack(tag.func_74775_l("item")) : ItemStack.field_190927_a;
        this.canFly = tag.func_74767_n("canFly");
        this.field_70159_w = tag.func_74769_h("motionX");
        this.field_70181_x = tag.func_74769_h("motionY");
        this.field_70179_y = tag.func_74769_h("motionZ");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        if (this.item != null) {
            tag.func_74782_a("item", (NBTBase)this.item.serializeNBT());
        }
        tag.func_74757_a("canFly", this.canFly);
        tag.func_74780_a("motionX", this.field_70159_w);
        tag.func_74780_a("motionY", this.field_70181_x);
        tag.func_74780_a("motionZ", this.field_70179_y);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !this.func_184207_aI()) {
            player.func_184220_m((Entity)this);
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public double func_70042_X() {
        return 0.4;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_184186_bw() {
        return true;
    }

    private Vec3d getRiderPosition() {
        if (!this.func_184188_bt().isEmpty()) {
            float distance = 0.0f;
            double dx = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0) * (double)distance;
            return new Vec3d(this.field_70165_t + dx, this.field_70163_u + this.func_70042_X() + ((Entity)this.func_184188_bt().get(0)).func_70033_W(), this.field_70161_v + dz);
        }
        return new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void func_184232_k(Entity passenger) {
        if (!this.func_184188_bt().isEmpty()) {
            Vec3d riderPos = this.getRiderPosition();
            ((Entity)this.func_184188_bt().get(0)).func_70107_b(riderPos.field_72450_a, riderPos.field_72448_b, riderPos.field_72449_c);
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    protected abstract float getSpeed();

    protected abstract float getMaxSpeed();

    protected abstract float getThrust();

    protected abstract int getMagicCost();
}

