/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.command;

import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import com.bewitchment.api.registry.Curse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class CommandCurse
extends CommandBase {
    public String func_71517_b() {
        return "curse";
    }

    public String func_71518_a(ICommandSender iCommandSender) {
        return "/curse <player> <get/add/remove/clear> <time>";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Curse curse;
        List<Curse> curses;
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayer player = null;
        for (WorldServer world : server.field_71305_c) {
            EntityPlayer temp = world.func_72924_a(args[0]);
            if (temp == null) continue;
            player = temp;
        }
        if (args[0].equals("@p")) {
            player = (EntityPlayer)sender.func_174793_f();
        }
        if (player == null) {
            throw new CommandException("commands.generic.player.notFound", new Object[]{args[0]});
        }
        if (args.length <= 1) return;
        if (args[1].equals("get")) {
            if (args.length != 2) throw new CommandException("commands.generic.syntax", new Object[0]);
            curses = ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).getCurses();
            ArrayList<String> cursesStrings = new ArrayList<String>();
            for (Curse curse2 : curses) {
                cursesStrings.add(curse2.getRegistryName().toString());
            }
            if (cursesStrings.isEmpty()) throw new CommandException("commands.curse.empty", new Object[]{player.getDisplayNameString()});
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.curse.get", new Object[]{player.getDisplayNameString(), ((Object)cursesStrings).toString()}));
        }
        if (args[1].equals("add")) {
            if (args.length != 4) throw new CommandException("commands.generic.syntax", new Object[0]);
            curse = (Curse)GameRegistry.findRegistry(Curse.class).getValue(new ResourceLocation(args[2]));
            if (curse == null) {
                throw new CommandException("commands.curse.null", new Object[]{args[2]});
            }
            ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).addCurse(curse, Integer.parseInt(args[3]));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.curse.add", new Object[]{args[2], player.getDisplayNameString()}));
        }
        if (args[1].equals("remove")) {
            if (args.length != 3) throw new CommandException("commands.generic.syntax", new Object[0]);
            curse = (Curse)GameRegistry.findRegistry(Curse.class).getValue(new ResourceLocation(args[2]));
            if (curse == null) {
                throw new CommandException("commands.fortune.null", new Object[]{args[2]});
            }
            if (!((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).hasCurse(curse)) {
                throw new CommandException("commands.curse.nocurse", new Object[]{player.getDisplayNameString(), args[2]});
            }
            ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).removeCurse(curse);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.curse.remove", new Object[]{args[2], player.getDisplayNameString()}));
        }
        if (!args[1].equals("clear")) return;
        if (args.length != 2) throw new CommandException("commands.generic.syntax", new Object[0]);
        curses = ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).getCurses();
        if (curses.isEmpty()) throw new CommandException("commands.curse.empty", new Object[]{player.getDisplayNameString()});
        for (Curse curse3 : curses) {
            ((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).removeCurse(curse3);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.curse.clear", new Object[]{player.getDisplayNameString()}));
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandCurse.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandCurse.func_175762_a((String[])args, Arrays.asList("get", "add", "remove", "clear"));
        }
        if (args.length == 3 && (args[1].equals("add") || args[1].equals("remove"))) {
            ArrayList<String> curses = new ArrayList<String>();
            for (Curse curse : GameRegistry.findRegistry(Curse.class)) {
                curses.add(curse.getRegistryName().toString());
            }
            return CommandCurse.func_175762_a((String[])args, curses);
        }
        return Collections.emptyList();
    }
}

