/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.network;

import com.bewitchment.Bewitchment;
import com.bewitchment.common.world.BiomeChangingUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBiomeUpdate
implements IMessage {
    private BlockPos pos;
    private int biomeId;

    public PacketBiomeUpdate(BlockPos pos, int biomeId) {
        this.pos = pos;
        this.biomeId = biomeId;
    }

    public PacketBiomeUpdate() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.biomeId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.biomeId);
    }

    public static class Handler
    implements IMessageHandler<PacketBiomeUpdate, IMessage> {
        public IMessage onMessage(PacketBiomeUpdate packet, MessageContext ctx) {
            if (ctx.side.isClient()) {
                BlockPos pos = packet.pos;
                int id = packet.biomeId;
                Minecraft.func_71410_x().func_152344_a(() -> {
                    World world = Bewitchment.proxy.getPlayer((MessageContext)ctx).field_70170_p;
                    BiomeChangingUtils.setBiome(world, pos, id);
                    int r = 2;
                    world.func_175704_b(pos.func_177982_a(-r, -r, -r), pos.func_177982_a(r, r, r));
                });
            }
            return null;
        }
    }
}

