/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.effects.Effects;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderFurnace;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnderFurnace
extends BlockEnderUtilitiesInventory {
    public static final PropertyEnum<EnumMachineMode> MODE = PropertyEnum.func_177709_a((String)"mode", EnumMachineMode.class);

    public BlockEnderFurnace(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a(MODE, (Comparable)((Object)EnumMachineMode.OFF)).func_177226_a((IProperty)FACING_H, (Comparable)BlockEnderUtilities.DEFAULT_FACING));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_H, MODE});
    }

    @Override
    protected String[] generateUnlocalizedNames() {
        return new String[]{"ender_furnace"};
    }

    @Override
    protected TileEntityEnderUtilities createTileEntityInstance(World worldIn, IBlockState state) {
        return new TileEntityEnderFurnace();
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityEnderFurnace te = BlockEnderFurnace.getTileEntitySafely(world, pos, TileEntityEnderFurnace.class);
        if (te != null) {
            if (te.isBurningLast) {
                return 15;
            }
            if (te.isCookingLast) {
                return 7;
            }
        }
        return super.getLightValue(state, world, pos);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = super.func_176221_a(state, world, pos);
        TileEntityEnderFurnace te = BlockEnderFurnace.getTileEntitySafely(world, pos, TileEntityEnderFurnace.class);
        if (te != null) {
            EnumMachineMode mode = !te.isCookingLast ? EnumMachineMode.OFF : (!te.isBurningLast ? EnumMachineMode.ON_NOFUEL : (te.fastMode ? EnumMachineMode.ON_FAST : EnumMachineMode.ON_NORMAL));
            state = state.func_177226_a(MODE, (Comparable)((Object)mode));
        }
        return state;
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntityEnderFurnace te = BlockEnderFurnace.getTileEntitySafely((IBlockAccess)world, pos, TileEntityEnderFurnace.class);
        if (te != null && te.isBurningLast) {
            Effects.spawnParticlesAround(world, EnumParticleTypes.PORTAL, pos, 2, rand);
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    public static enum EnumMachineMode implements IStringSerializable
    {
        OFF("off"),
        ON_NOFUEL("on_nofuel"),
        ON_NORMAL("on_normal"),
        ON_FAST("on_fast");

        private final String name;

        private EnumMachineMode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.ordinal();
        }
    }
}

