/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.block.base;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.block.base.property.PropertyBlockState;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class BlockEnderUtilitiesTileEntity
extends BlockEnderUtilities {
    public static final PropertyBool CREATIVE = PropertyBool.func_177716_a((String)"creative");
    public static final PropertyBlockState CAMOBLOCKSTATE = new PropertyBlockState("camo");
    public static final PropertyBlockState CAMOBLOCKSTATEEXTENDED = new PropertyBlockState("camoext");

    public BlockEnderUtilitiesTileEntity(String name, float hardness, float resistance, int harvestLevel, Material material) {
        super(name, hardness, resistance, harvestLevel, material);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.createTileEntityInstance(world, state);
    }

    protected abstract TileEntityEnderUtilities createTileEntityInstance(World var1, IBlockState var2);

    protected boolean isCamoBlock() {
        return false;
    }

    public boolean isTileEntityValid(TileEntity te) {
        return te != null && !te.func_145837_r();
    }

    protected EnumFacing getPlacementFacing(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        return placer.func_174811_aO().func_176734_d();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityEnderUtilities te = BlockEnderUtilitiesTileEntity.getTileEntitySafely((IBlockAccess)world, pos, TileEntityEnderUtilities.class);
        if (te == null) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("BlockEntityTag", 10)) {
            te.readFromNBTCustom(nbt.func_74775_l("BlockEntityTag"));
        } else {
            if (placer instanceof EntityPlayer) {
                te.setOwner((Entity)((EntityPlayer)placer));
            }
            if (te instanceof TileEntityEnderUtilitiesInventory && stack.func_82837_s()) {
                ((TileEntityEnderUtilitiesInventory)te).setInventoryName(stack.func_82833_r());
            }
        }
        te.setFacing(this.getPlacementFacing(world, pos, state, placer, stack));
        te.onLoad();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityEnderUtilities te = BlockEnderUtilitiesTileEntity.getTileEntitySafely((IBlockAccess)world, pos, TileEntityEnderUtilities.class);
        if (te != null && this.isTileEntityValid(te)) {
            if (te.onRightClickBlock(player, hand, side, hitX, hitY, hitZ)) {
                return true;
            }
            if (te.hasGui()) {
                if (!world.field_72995_K) {
                    player.openGui((Object)EnderUtilities.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
                return true;
            }
        }
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        TileEntityEnderUtilities te;
        if (!world.field_72995_K && (te = BlockEnderUtilitiesTileEntity.getTileEntitySafely((IBlockAccess)world, pos, TileEntityEnderUtilities.class)) != null) {
            te.onLeftClickBlock(playerIn);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityEnderUtilities te;
        if (!worldIn.field_72995_K && (te = BlockEnderUtilitiesTileEntity.getTileEntitySafely((IBlockAccess)worldIn, pos, TileEntityEnderUtilities.class)) != null) {
            te.onNeighborBlockChange(worldIn, pos, state, blockIn);
        }
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.isCamoBlock() || layer == this.func_180664_k();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityEnderUtilities te = BlockEnderUtilitiesTileEntity.getTileEntitySafely(world, pos, TileEntityEnderUtilities.class);
        if (te != null) {
            EnumFacing facing = te.getFacing();
            if (this.propFacing == FACING || facing.func_176740_k() != EnumFacing.Axis.Y) {
                state = state.func_177226_a((IProperty)this.propFacing, (Comparable)te.getFacing());
            }
        }
        return state;
    }

    public IBlockState getExtendedState(IBlockState oldState, IBlockAccess world, BlockPos pos) {
        TileEntityEnderUtilities te;
        if (this.isCamoBlock() && (te = BlockEnderUtilitiesTileEntity.getTileEntitySafely(world, pos, TileEntityEnderUtilities.class)) != null) {
            IExtendedBlockState state = (IExtendedBlockState)oldState;
            state = state.withProperty((IUnlistedProperty)CAMOBLOCKSTATE, (Object)te.getCamoState());
            state = state.withProperty((IUnlistedProperty)CAMOBLOCKSTATEEXTENDED, (Object)te.getCamoExtendedState());
            return state;
        }
        return oldState;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState;
        IBlockState stateCamo;
        if (this.isCamoBlock() && (stateCamo = (IBlockState)(extendedState = (IExtendedBlockState)this.getExtendedState(state.func_185899_b(world, pos), world, pos)).getValue((IUnlistedProperty)CAMOBLOCKSTATE)) != null) {
            return stateCamo.func_185906_d();
        }
        return super.getLightValue(state, world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.isCamoBlock();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)this.propFacing, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)this.propFacing)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)this.propFacing)));
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityEnderUtilities te = BlockEnderUtilitiesTileEntity.getTileEntitySafely((IBlockAccess)world, pos, TileEntityEnderUtilities.class);
        if (te != null) {
            te.func_189667_a(Rotation.CLOCKWISE_90);
            IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
            world.func_184138_a(pos, state, state, 3);
            return true;
        }
        return false;
    }
}

