/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.effects;

import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import java.util.Random;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Effects {
    public static void playSoundEffectServer(World world, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume) {
        Effects.playSoundEffectServer(world, x, y, z, soundIn, category, volume, 1.0f + (world.field_73012_v.nextFloat() * 0.5f - world.field_73012_v.nextFloat() * 0.5f) * 0.5f);
    }

    public static void playSoundEffectServer(World world, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        world.func_184148_a(null, x, y, z, soundIn, category, volume, pitch);
    }

    public static void playSoundClient(World world, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        world.func_184134_a(x, y, z, soundIn, category, volume, pitch, false);
    }

    public static void spawnParticles(World world, EnumParticleTypes type, double x, double y, double z, int count, double offset, double velocity) {
        for (int i = 0; i < count; ++i) {
            double offX = ((double)world.field_73012_v.nextFloat() - 0.5) * offset;
            double offY = ((double)world.field_73012_v.nextFloat() - 0.5) * offset;
            double offZ = ((double)world.field_73012_v.nextFloat() - 0.5) * offset;
            double velX = ((double)world.field_73012_v.nextFloat() - 0.5) * velocity;
            double velY = ((double)world.field_73012_v.nextFloat() - 0.5) * velocity;
            double velZ = ((double)world.field_73012_v.nextFloat() - 0.5) * velocity;
            world.func_175688_a(type, x + offX, y + offY, z + offZ, -velX, -velY, -velZ, new int[0]);
        }
    }

    public static void spawnParticlesAround(World world, EnumParticleTypes type, BlockPos pos, int count, Random rand) {
        for (int i = 0; i < count; ++i) {
            int i1 = rand.nextInt(2) * 2 - 1;
            int j1 = rand.nextInt(2) * 2 - 1;
            double x1 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)i1;
            double y1 = (float)pos.func_177956_o() + rand.nextFloat();
            double z1 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j1;
            double vx = rand.nextFloat() * 1.0f * (float)i1;
            double vy = ((double)rand.nextFloat() - 0.5) * 0.125;
            double vz = rand.nextFloat() * 1.0f * (float)j1;
            world.func_175688_a(type, x1, y1, z1, vx, vy, vz, new int[0]);
        }
    }

    public static void spawnParticlesFromServer(int dimension, BlockPos pos, EnumParticleTypes particle) {
        Effects.spawnParticlesFromServer(dimension, pos, particle, 20);
    }

    public static void spawnParticlesFromServer(int dimension, BlockPos pos, EnumParticleTypes particle, int count) {
        Effects.spawnParticlesFromServer(dimension, pos, particle, count, 1.8f, 0.9f);
    }

    public static void spawnParticlesFromServer(int dimension, BlockPos pos, EnumParticleTypes particle, int count, float offset, float velocity) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(100, particle.func_179348_c(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, count, offset, velocity), new NetworkRegistry.TargetPoint(dimension, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 24.0));
    }

    public static void addItemTeleportEffects(World world, BlockPos pos) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(2, 3, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 8, 0.2f, 0.3f), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 24.0));
    }
}

