/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.event.PlayerItemPickupEvent;
import fi.dy.masa.enderutilities.inventory.container.ContainerNullifier;
import fi.dy.masa.enderutilities.inventory.item.InventoryItem;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemNullifier
extends ItemEnderUtilities
implements IKeyBound {
    public static final String TAG_NAME_CONTAINER = "Nullifier";
    public static final String TAG_NAME_DISABLED = "Disabled";
    public static final String TAG_NAME_SLOT_SELECTION = "Slot";
    public static final int GUI_ACTION_SELECT_SLOT = 0;
    public static final int GUI_ACTION_TOGGLE_DISABLED = 1;
    public static final int NUM_SLOTS = 9;
    public static final int MAX_STACK_SIZE = 1024;

    public ItemNullifier(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack useStack = this.getItemForUse(stack, player);
        if (!useStack.func_190926_b() && world.func_175660_a(player, pos.func_177972_a(facing))) {
            EntityUtils.setHeldItemWithoutEquipSound(player, hand, useStack);
            EnumActionResult result = useStack.func_179546_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
            if (!(world.field_72995_K || player.field_71075_bZ.field_75098_d || useStack.func_190926_b())) {
                ItemNullifier.tryInsertItemsToNullifier(useStack, stack, player);
            }
            EntityUtils.setHeldItemWithoutEquipSound(player, hand, stack);
            return result;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public static boolean isNullifierEnabled(ItemStack stack) {
        return !NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_DISABLED);
    }

    private ItemStack getItemForUse(ItemStack stackNullifier, EntityPlayer player) {
        ItemHandlerNullifier inv = ItemNullifier.createInventoryForItem(stackNullifier, false);
        int slot = MathHelper.func_76125_a((int)NBTUtils.getByte(stackNullifier, TAG_NAME_CONTAINER, TAG_NAME_SLOT_SELECTION), (int)0, (int)(inv.getSlots() - 1));
        boolean simulate = player.func_130014_f_().field_72995_K || player.field_71075_bZ.field_75098_d;
        return inv.extractItem(slot, 1, simulate);
    }

    public static ItemStack getSelectedStack(ItemStack stackNullifier) {
        ItemHandlerNullifier inv = ItemNullifier.createInventoryForItem(stackNullifier, false);
        int slot = MathHelper.func_76125_a((int)NBTUtils.getByte(stackNullifier, TAG_NAME_CONTAINER, TAG_NAME_SLOT_SELECTION), (int)0, (int)(inv.getSlots() - 1));
        return inv.getStackInSlot(slot);
    }

    private static ItemHandlerNullifier getInventoryForItem(ItemStack stackNullifier, EntityPlayer player) {
        ItemHandlerNullifier inv = null;
        inv = player.field_71070_bA instanceof ContainerNullifier && ((ContainerNullifier)player.field_71070_bA).getContainerItem() == stackNullifier ? ((ContainerNullifier)player.field_71070_bA).inventoryItem : ItemNullifier.createInventoryForItem(stackNullifier, player.func_130014_f_().field_72995_K);
        if (!inv.isAccessibleBy((Entity)player)) {
            return null;
        }
        return inv;
    }

    public static ItemHandlerNullifier createInventoryForItem(ItemStack stack, boolean isRemote) {
        ItemHandlerNullifier inv = new ItemHandlerNullifier(stack, 9, 1024, true, isRemote);
        inv.readFromContainerItemStack();
        return inv;
    }

    public static boolean onEntityItemPickupEvent(EntityItemPickupEvent event) {
        int origStackSize;
        EntityItem entityItem = event.getItem();
        ItemStack stack = entityItem.func_92059_d();
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_130014_f_().field_72995_K || entityItem.field_70128_L || stack.func_190926_b()) {
            return true;
        }
        ItemStack origStack = ItemStack.field_190927_a;
        int stackSizeLast = origStackSize = stack.func_190916_E();
        boolean ret = false;
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems(playerInv, EnderUtilitiesItems.NULLIFIER);
        for (int slot : slots) {
            ItemStack nullifierStack = playerInv.getStackInSlot(slot);
            if (nullifierStack.func_190926_b() || !ItemNullifier.isNullifierEnabled(nullifierStack)) continue;
            if (origStack == ItemStack.field_190927_a) {
                origStack = stack.func_77946_l();
            }
            if ((stack = ItemNullifier.handleItems(stack, nullifierStack, player)).func_190926_b() || stack.func_190916_E() != stackSizeLast) {
                if (stack.func_190926_b()) {
                    entityItem.func_70106_y();
                    event.setCanceled(true);
                    ret = true;
                    break;
                }
                ItemStack pickedUpStack = origStack.func_77946_l();
                pickedUpStack.func_190920_e(stackSizeLast - stack.func_190916_E());
                FMLCommonHandler.instance().firePlayerItemPickupEvent(player, entityItem, pickedUpStack);
                player.func_71001_a((Entity)entityItem, origStackSize);
            }
            stackSizeLast = stack.func_190916_E();
        }
        if (!entityItem.field_70128_L && stack.func_190916_E() != origStackSize) {
            entityItem.func_92058_a(stack);
        }
        if (!entityItem.func_174814_R() && (entityItem.field_70128_L || stack.func_190916_E() != origStackSize)) {
            player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.MASTER, 0.2f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        return ret;
    }

    public static boolean onItemPickupEvent(PlayerItemPickupEvent event) {
        if (event.getEntityPlayer().func_130014_f_().field_72995_K) {
            return false;
        }
        boolean pickedUp = false;
        EntityPlayer player = event.getEntityPlayer();
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<Integer> nullifierSlots = InventoryUtils.getSlotNumbersOfMatchingItems(playerInv, EnderUtilitiesItems.NULLIFIER);
        Iterator<ItemStack> iter = event.drops.iterator();
        while (iter.hasNext()) {
            ItemStack stack = iter.next();
            if (stack.func_190926_b()) {
                iter.remove();
                continue;
            }
            for (int slot : nullifierSlots) {
                ItemStack nullifierStack = playerInv.getStackInSlot(slot);
                if (nullifierStack.func_190926_b() || !ItemNullifier.isNullifierEnabled(nullifierStack)) continue;
                ItemStack stackOrig = stack;
                if ((stack = ItemNullifier.handleItems(stack, nullifierStack, player)).func_190926_b()) {
                    iter.remove();
                    pickedUp = true;
                    continue;
                }
                if (stackOrig.func_190916_E() == stack.func_190916_E()) continue;
                stackOrig.func_190920_e(stack.func_190916_E());
                pickedUp = true;
            }
        }
        if (pickedUp) {
            player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.MASTER, 0.2f, ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (event.drops.isEmpty()) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    private static ItemStack handleItems(ItemStack itemsIn, ItemStack nullifierStack, EntityPlayer player) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        itemsIn = InventoryUtils.tryInsertItemStackToExistingStacksInInventory(playerInv, itemsIn);
        if (!itemsIn.func_190926_b()) {
            itemsIn = ItemNullifier.tryInsertItemsToNullifier(itemsIn, nullifierStack, player);
        }
        return itemsIn;
    }

    private static ItemStack tryInsertItemsToNullifier(ItemStack itemsIn, ItemStack nullifierStack, EntityPlayer player) {
        ItemHandlerNullifier nullifierInv = ItemNullifier.getInventoryForItem(nullifierStack, player);
        if (nullifierInv != null && !(itemsIn = InventoryUtils.tryInsertItemStackToExistingStacksInInventory(nullifierInv, itemsIn)).func_190926_b() && InventoryUtils.getSlotOfFirstMatchingItemStack(nullifierInv, itemsIn) != -1) {
            return ItemStack.field_190927_a;
        }
        return itemsIn;
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        ItemStack stack;
        if (player.field_71070_bA instanceof ContainerNullifier && !(stack = ((ContainerNullifier)player.field_71070_bA).getContainerItem()).func_190926_b()) {
            if (action == 0) {
                NBTUtils.setByte(stack, TAG_NAME_CONTAINER, TAG_NAME_SLOT_SELECTION, (byte)MathHelper.func_76125_a((int)element, (int)0, (int)8));
            } else if (action == 1) {
                NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_DISABLED);
            }
        }
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
            ItemNullifier.openGui(stack, player);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
            NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_DISABLED);
            return true;
        }
        if (HotKeys.EnumKey.SCROLL.matches(key, 131072) || HotKeys.EnumKey.TOGGLE.matches(key, 131072)) {
            NBTUtils.cycleByteValue(stack, TAG_NAME_CONTAINER, TAG_NAME_SLOT_SELECTION, 8, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
            return true;
        }
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        int slot = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_SLOT_SELECTION) + 1;
        ItemStack selectedStack = ItemNullifier.getSelectedStack(stack);
        if (!selectedStack.func_190926_b()) {
            return name + " - " + slot + " / " + 9 + " - " + selectedStack.func_82833_r();
        }
        return name + " - " + slot + " / " + 9;
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        if (stack.func_77978_p() == null) {
            return;
        }
        String preBlue = TextFormatting.BLUE.toString();
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String str = ItemNullifier.isNullifierEnabled(stack) ? preGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst : preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + str);
        int slot = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_SLOT_SELECTION) + 1;
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.selected", (Object[])new Object[0]) + ": " + preBlue + slot + " / " + 9 + rst);
        ArrayList<String> lines = new ArrayList<String>();
        int itemCount = UtilItemModular.getFormattedItemListFromContainerItem(stack, lines, 20);
        if (lines.size() > 0) {
            NBTTagList tagList = NBTUtils.getStoredItemsList(stack, false);
            int stackCount = tagList != null ? tagList.func_74745_c() : 0;
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.items.stackcount", (Object[])new Object[]{stackCount, itemCount}));
            list.addAll(lines);
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.memorycard.noitems", (Object[])new Object[0]));
        }
    }

    public static void openGui(ItemStack stack, EntityPlayer player) {
        NBTUtils.getUUIDFromItemStack(stack, "UUID", true);
        player.field_71070_bA.func_75142_b();
        player.openGui((Object)EnderUtilities.instance, 1006, player.func_130014_f_(), 0, 0, 0);
    }

    public static class ItemHandlerNullifier
    extends InventoryItem {
        public ItemHandlerNullifier(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote) {
            super(containerStack, invSize, stackLimit, allowCustomStackSizes, isRemote);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77976_d() > 1 && !stack.func_77984_f();
        }
    }
}

