/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.block;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.item.block.ItemBlockEnderUtilities;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.ItemType;
import fi.dy.masa.enderutilities.util.PlacementProperties;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ItemBlockPlacementProperty
extends ItemBlockEnderUtilities
implements IKeyBound {
    private final HashMap<Integer, PlacementProperties.PlacementProperty> placementProperties = new HashMap();

    public ItemBlockPlacementProperty(BlockEnderUtilities block) {
        super(block);
    }

    public boolean hasPlacementProperty(ItemStack stack) {
        return this.placementProperties.containsKey(Short.MAX_VALUE) || this.placementProperties.containsKey(stack.func_77960_j());
    }

    @Nullable
    public PlacementProperties.PlacementProperty getPlacementProperty(ItemStack stack) {
        PlacementProperties.PlacementProperty pp = this.placementProperties.get(stack.func_77960_j());
        if (pp == null) {
            pp = this.placementProperties.get(Short.MAX_VALUE);
        }
        return pp;
    }

    @Nonnull
    public PlacementProperties.PlacementProperty getOrCreatePlacementProperty(int stackMeta) {
        PlacementProperties.PlacementProperty pp = this.placementProperties.get(stackMeta);
        if (pp == null) {
            pp = new PlacementProperties.PlacementProperty();
            this.placementProperties.put(stackMeta, pp);
        }
        return pp;
    }

    public void addPlacementProperty(int stackMeta, String key, int type, int minValue, int maxValue) {
        PlacementProperties.PlacementProperty pp = this.getOrCreatePlacementProperty(stackMeta);
        pp.addProperty(key, type, minValue, maxValue);
    }

    public void addPlacementPropertyValueNames(int stackMeta, String key, String[] names) {
        PlacementProperties.PlacementProperty pp = this.getOrCreatePlacementProperty(stackMeta);
        pp.addValueNames(key, names);
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        ItemBlockPlacementProperty item = (ItemBlockPlacementProperty)stack.func_77973_b();
        if (item.hasPlacementProperty(stack) && player instanceof EntityPlayerMP) {
            PlacementProperties.PlacementProperty pp = this.getPlacementProperty(stack);
            ItemType type = new ItemType(stack, pp.isNBTSensitive());
            int index = PlacementProperties.getInstance().getPropertyIndex(player.func_110124_au(), type);
            if (HotKeys.EnumKey.TOGGLE.matches(key, 0) || HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
                if ((index += HotKeys.EnumKey.TOGGLE.matches(key, 65536) ? -1 : 1) < 0) {
                    index = Math.max(0, pp.getPropertyCount() - 1);
                } else if (index >= pp.getPropertyCount()) {
                    index = 0;
                }
                PlacementProperties.getInstance().setPropertyIndex(player.func_110124_au(), type, index);
                PlacementProperties.getInstance().syncCurrentlyHeldItemDataForPlayer((EntityPlayerMP)player, stack);
            } else {
                int maxValue;
                Pair<String, Integer> pair = pp.getProperty(index);
                Pair<Integer, Integer> range = pp.getPropertyValueRange(index);
                int minValue = range != null ? (Integer)range.getLeft() : 0;
                int n = maxValue = range != null ? (Integer)range.getRight() : 1;
                if (pair != null && HotKeys.EnumKey.getBaseKey(key) == HotKeys.EnumKey.SCROLL.getKeyCode() && (!HotKeys.EnumKey.keypressContainsShift(key) || HotKeys.EnumKey.keypressContainsControl(key) || HotKeys.EnumKey.keypressContainsAlt(key))) {
                    int change;
                    int n2 = change = HotKeys.EnumKey.keypressActionIsReversed(key) ? -1 : 1;
                    if (HotKeys.EnumKey.keypressContainsShift(key)) {
                        change *= 10;
                    }
                    if (HotKeys.EnumKey.keypressContainsControl(key)) {
                        change *= HotKeys.EnumKey.keypressContainsAlt(key) ? 100 : 10;
                    }
                    int value = PlacementProperties.getInstance().getPropertyValue(player.func_110124_au(), type, (String)pair.getLeft(), (Integer)pair.getRight());
                    if ((value += change) < minValue) {
                        value = maxValue;
                    }
                    if (value > maxValue) {
                        value = minValue;
                    }
                    PlacementProperties.getInstance().setPropertyValue(player.func_110124_au(), type, (String)pair.getLeft(), (Integer)pair.getRight(), value);
                    PlacementProperties.getInstance().syncCurrentlyHeldItemDataForPlayer((EntityPlayerMP)player, stack);
                }
            }
            return true;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasPlacementProperty(stack)) {
            NBTTagCompound tag;
            ItemType type = new ItemType(stack, this.getPlacementProperty(stack).isNBTSensitive());
            stack = stack.func_77946_l();
            EnumActionResult result = super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
            if (result == EnumActionResult.SUCCESS && (tag = PlacementProperties.getInstance().getPropertyTag(player.func_110124_au(), type)) != null) {
                Block block = worldIn.func_180495_p(pos).func_177230_c();
                if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
                    pos = pos.func_177972_a(facing);
                    block = worldIn.func_180495_p(pos).func_177230_c();
                }
                if (block instanceof BlockEnderUtilities) {
                    ((BlockEnderUtilities)block).setPlacementProperties(worldIn, pos, stack, tag);
                }
            }
            return result;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public void addTooltips(ItemStack stack, List<String> list, boolean verbose) {
        super.addTooltips(stack, list, verbose);
        if (this.hasPlacementProperty(stack)) {
            ItemEnderUtilities.addTranslatedTooltip("enderutilities.tooltip.placementproperties.tooltips", list, verbose, new Object[0]);
        }
    }
}

