/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerEnderUtilities;
import fi.dy.masa.enderutilities.item.ItemHandyBag;
import fi.dy.masa.enderutilities.item.ItemInventorySwapper;
import fi.dy.masa.enderutilities.item.ItemNullifier;
import fi.dy.masa.enderutilities.item.ItemPickupManager;
import fi.dy.masa.enderutilities.item.ItemQuickStacker;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageGuiAction
implements IMessage {
    private int guiId;
    private int action;
    private int elementId;
    private int dimension;
    private int posX;
    private int posY;
    private int posZ;

    public MessageGuiAction() {
    }

    public MessageGuiAction(int dim, BlockPos pos, int guiId, int action, int elementId) {
        this.dimension = dim;
        this.posX = pos.func_177958_n();
        this.posY = pos.func_177956_o();
        this.posZ = pos.func_177952_p();
        this.guiId = guiId;
        this.action = action;
        this.elementId = elementId;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.posX = buf.readInt();
        this.posY = buf.readInt();
        this.posZ = buf.readInt();
        this.guiId = buf.readInt();
        this.action = buf.readInt();
        this.elementId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeInt(this.guiId);
        buf.writeInt(this.action);
        buf.writeInt(this.elementId);
    }

    public static class Handler
    implements IMessageHandler<MessageGuiAction, IMessage> {
        public IMessage onMessage(final MessageGuiAction message, MessageContext ctx) {
            if (ctx.side != Side.SERVER) {
                EnderUtilities.logger.error("Wrong side in MessageGuiAction: " + ctx.side);
                return null;
            }
            final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (sendingPlayer == null) {
                EnderUtilities.logger.error("Sending player was null in MessageGuiAction");
                return null;
            }
            WorldServer playerWorldServer = sendingPlayer.func_71121_q();
            if (playerWorldServer == null) {
                EnderUtilities.logger.error("World was null in MessageGuiAction");
                return null;
            }
            playerWorldServer.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message, (EntityPlayer)sendingPlayer);
                }
            });
            return null;
        }

        protected void processMessage(MessageGuiAction message, EntityPlayer player) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension);
            if (world != null) {
                switch (message.guiId) {
                    case 0: {
                        TileEntity te;
                        BlockPos pos = new BlockPos(message.posX, message.posY, message.posZ);
                        if (!world.func_175667_e(pos) || (te = world.func_175625_s(pos)) == null || !(te instanceof TileEntityEnderUtilities)) break;
                        ((TileEntityEnderUtilities)te).performGuiAction(player, message.action, message.elementId);
                        break;
                    }
                    case 1: {
                        if (!(player.field_71070_bA instanceof ContainerEnderUtilities)) break;
                        ((ContainerEnderUtilities)player.field_71070_bA).performGuiAction(player, message.action, message.elementId);
                        break;
                    }
                    case 1001: {
                        ItemHandyBag.performGuiAction(player, message.action, message.elementId);
                        break;
                    }
                    case 1003: {
                        ItemInventorySwapper.performGuiAction(player, message.action, message.elementId);
                        break;
                    }
                    case 1004: {
                        ItemPickupManager.performGuiAction(player, message.action, message.elementId);
                        break;
                    }
                    case 1005: {
                        ItemQuickStacker.performGuiAction(player, message.action, message.elementId);
                        break;
                    }
                    case 1006: {
                        ItemNullifier.performGuiAction(player, message.action, message.elementId);
                        break;
                    }
                }
            }
        }
    }
}

