/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.gui.client.GuiPortalPanel;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerPortalPanel;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperContainer;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperSelectiveModifiable;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.tileentity.TileEntityPortal;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.PortalFormer;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.StringUtils;

public class TileEntityPortalPanel
extends TileEntityEnderUtilitiesInventory {
    private final ItemHandlerWrapper inventoryWrapper;
    private int activeTargetId;
    private int portalTargetId;
    private String displayName = "";
    private String[] targetDisplayNames = new String[9];
    private int[] colors = new int[9];

    public TileEntityPortalPanel() {
        super("portal_panel");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(0, 16, 1, false, "Items", this);
        this.inventoryWrapper = new ItemHandlerWrapper(this.itemHandlerBase);
    }

    @Override
    public IItemHandler getWrappedInventoryForContainer(EntityPlayer player) {
        return new ItemHandlerWrapperContainer(this.itemHandlerBase, this.inventoryWrapper);
    }

    public int getActiveTargetId() {
        return this.activeTargetId;
    }

    private TargetData getActiveTarget() {
        ItemStack stack = this.itemHandlerBase.getStackInSlot(this.getActiveTargetId());
        return !stack.func_190926_b() ? TargetData.getTargetFromItem(stack) : null;
    }

    public boolean targetIsPortal() {
        ItemStack stack = this.itemHandlerBase.getStackInSlot(this.getActiveTargetId());
        if (!stack.func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.LINK_CRYSTAL) {
            return ((IModule)stack.func_77973_b()).getModuleTier(stack) == 2;
        }
        return false;
    }

    private OwnerData getOwner() {
        ItemStack stack = this.itemHandlerBase.getStackInSlot(this.getActiveTargetId());
        return !stack.func_190926_b() ? OwnerData.getOwnerDataFromItem(stack) : null;
    }

    public void setActiveTargetId(int target) {
        this.activeTargetId = MathHelper.func_76125_a((int)target, (int)0, (int)7);
    }

    private int getPortalColor() {
        return this.getColorFromDyeMeta(this.getDyeMetaFromItem(8));
    }

    private int getDyeMetaFromItem(int target) {
        ItemStack stack;
        if (target == 8) {
            target = this.getActiveTargetId();
        }
        if (target >= 0 && target < 8 && !(stack = this.itemHandlerBase.getStackInSlot(target + 8)).func_190926_b() && stack.func_77973_b() == Items.field_151100_aR) {
            return stack.func_77960_j();
        }
        return -1;
    }

    private int getColorFromDyeMeta(int dyeMeta) {
        return dyeMeta >= 0 && dyeMeta <= 15 ? MapColor.func_193558_a((EnumDyeColor)EnumDyeColor.func_176766_a((int)dyeMeta)).field_76291_p : 0xFFFFFF;
    }

    public int getColor(int target) {
        return this.colors[MathHelper.func_76125_a((int)target, (int)0, (int)8)];
    }

    private String getActiveName() {
        return this.getTargetName(this.getActiveTargetId());
    }

    private String getTargetName(int targetId) {
        ItemStack stack;
        if (targetId >= 0 && targetId <= 7 && !(stack = this.itemHandlerBase.getStackInSlot(targetId)).func_190926_b()) {
            return stack.func_82833_r();
        }
        return "";
    }

    public String getPanelDisplayName() {
        return this.displayName;
    }

    public String getTargetDisplayName(int targetId) {
        if (targetId >= 0 && targetId <= 7) {
            String name = this.targetDisplayNames[targetId];
            return name != null ? name : "";
        }
        return "";
    }

    public void setTargetName(String name) {
        ItemStack stack;
        int id = this.getActiveTargetId();
        if (id >= 0 && id < 8 && !(stack = this.itemHandlerBase.getStackInSlot(id)).func_190926_b()) {
            if (StringUtils.isBlank((CharSequence)name)) {
                stack.func_135074_t();
            } else {
                stack.func_151001_c(name);
            }
            this.itemHandlerBase.setStackInSlot(id, stack);
        }
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        this.setActiveTargetId(nbt.func_74771_c("SelectedTarget"));
        this.portalTargetId = nbt.func_74771_c("PortalTarget");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("SelectedTarget", (byte)this.activeTargetId);
        nbt.func_74774_a("PortalTarget", (byte)this.portalTargetId);
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        int i;
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("s", (byte)this.activeTargetId);
        String name = this.getActiveName();
        if (!StringUtils.isBlank((CharSequence)name)) {
            nbt.func_74778_a("n", name);
        }
        for (i = 0; i < 9; ++i) {
            nbt.func_74774_a("mt" + i, (byte)this.getDyeMetaFromItem(i));
        }
        for (i = 0; i < 8; ++i) {
            nbt.func_74778_a("n" + i, this.getTargetName(i));
        }
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        int i;
        this.activeTargetId = tag.func_74771_c("s");
        this.displayName = tag.func_74779_i("n");
        for (i = 0; i < 9; ++i) {
            this.colors[i] = this.getColorFromDyeMeta(tag.func_74771_c("mt" + i));
        }
        for (i = 0; i < 8; ++i) {
            if (!tag.func_150297_b("n" + i, 8)) continue;
            this.targetDisplayNames[i] = tag.func_74779_i("n" + i);
        }
        super.handleUpdateTag(tag);
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 2);
    }

    @Override
    public void performGuiAction(EntityPlayer player, int action, int element) {
        if (action == 0 && element >= 0 && element < 8) {
            this.setActiveTargetId(element);
            this.func_70296_d();
            this.notifyBlockUpdate(this.func_174877_v());
        }
    }

    public void tryTogglePortal() {
        boolean recreate;
        World world = this.func_145831_w();
        BlockPos posPanel = this.func_174877_v();
        BlockEnderUtilities blockPanel = EnderUtilitiesBlocks.PORTAL_PANEL;
        BlockPos posFrame = posPanel.func_177972_a(((EnumFacing)world.func_180495_p(posPanel).func_177229_b((IProperty)blockPanel.propFacing)).func_176734_d());
        PortalFormer portalFormer = new PortalFormer(world, posFrame, EnderUtilitiesBlocks.PORTAL_FRAME, EnderUtilitiesBlocks.PORTAL);
        TileEntityPortal.PortalData data = new TileEntityPortal.PortalData(this.getActiveTarget(), this.getOwner(), this.getPortalColor(), this.targetIsPortal());
        portalFormer.setPortalData(data);
        portalFormer.analyzePortal();
        boolean state = portalFormer.getPortalState();
        boolean bl = recreate = this.activeTargetId != this.portalTargetId;
        if (!state) {
            if (portalFormer.togglePortalState(false)) {
                this.portalTargetId = this.activeTargetId;
                world.func_184133_a(null, posPanel, SoundEvents.field_187606_E, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
        } else if (portalFormer.togglePortalState(recreate)) {
            if (recreate) {
                this.portalTargetId = this.activeTargetId;
                world.func_184133_a(null, posPanel, SoundEvents.field_187606_E, SoundCategory.BLOCKS, 0.5f, 1.0f);
            } else {
                world.func_184133_a(null, posPanel, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 0.4f, 0.85f);
            }
        }
    }

    @Override
    public ContainerPortalPanel getContainer(EntityPlayer player) {
        return new ContainerPortalPanel(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiPortalPanel(this.getContainer(player), this);
    }

    private class ItemHandlerWrapper
    extends ItemHandlerWrapperSelectiveModifiable {
        public ItemHandlerWrapper(IItemHandlerModifiable baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack.func_190926_b()) {
                return false;
            }
            if (slot < 8) {
                if (stack.func_77973_b() == EnderUtilitiesItems.LINK_CRYSTAL) {
                    int tier = ((IModule)stack.func_77973_b()).getModuleTier(stack);
                    return tier == 2 || tier == 0 && !Configs.portalOnlyAllowsPortalTypeLinkCrystals;
                }
                return false;
            }
            return InventoryUtils.doesStackMatchOreDictName(stack, "dye");
        }
    }
}

