/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.item.ItemStack;

public class EUStringUtils {
    public static final String EMPTY = "";
    public static final String[] SI_PREFIXES = new String[]{"", "k", "M", "G", "T", "P", "E", "Z", "Y"};

    public static String getStackSizeString(ItemStack stack, int maxChars) {
        return EUStringUtils.formatNumber(stack.func_190916_E(), 9999L, maxChars);
    }

    public static String formatNumber(long value, long maxUnformatted, int maxChars) {
        if (value <= maxUnformatted) {
            return String.valueOf(value);
        }
        double dValue = value;
        int prefixIndex = 0;
        while (dValue >= 1000.0) {
            dValue /= 1000.0;
            ++prefixIndex;
        }
        int digits = 1;
        for (double div = 10.0; dValue >= div && digits < 64; div *= 10.0, ++digits) {
        }
        try {
            int maxDecimals = maxChars - digits - 1 - SI_PREFIXES[prefixIndex].length();
            String valueStr = String.valueOf(dValue);
            int endIndex = maxDecimals > 0 ? Math.min(digits + 1 + maxDecimals, valueStr.length()) : digits;
            valueStr = valueStr.substring(0, endIndex);
            return valueStr + SI_PREFIXES[prefixIndex];
        }
        catch (Exception e) {
            return "OOPS";
        }
    }

    public static String formatNumberWithKSeparators(long value) {
        return NumberFormat.getNumberInstance(Locale.US).format(value);
    }

    public static String getInitialsWithDots(String str) {
        String[] split;
        StringBuilder sb = new StringBuilder(64);
        block0: for (String s : split = str.split(" ")) {
            for (int i = 0; i < s.length(); ++i) {
                if (!Character.isAlphabetic(s.charAt(i))) continue;
                sb.append(s.substring(i, i + 1)).append(".");
                continue block0;
            }
        }
        return sb.toString();
    }
}

